<?php
/*
 * member/mail/CreateList.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
require_once( dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'util'
.DIRECTORY_SEPARATOR.'LockProcess.class.php' );
/**
 * spider : メンバーメール 配信リスト作成用アクションモジュールクラス
 * 
 * @package member メンバー管理パッケージ
 * @subpackage mail メールパッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_mail_CreateList extends system_login_ModuleBase {
	function member_mail_CreateList(){
		array_push($this->require_module_array,'database2.Connect');
	}
	/**
	 * executeメソッド
	 * delivery_status : 配信結果ステータス
	 * 	1=正常配信完了
	 * 	11=メールマガジン種別に設定されている為配信スキップ
	 * 	12=対象メールアドレス(PC/携帯)が登録されていない為配信スキップ
	 * 	101=送信失敗
	 * 	102=配信成功するもリターンメール（スクリプト未実装）
	 * 	201=送信予約情報の読み込み失敗
	 * 	202=メンバー情報の読み込み失敗
	 */
	function execute( & $request ) {
		
		$dbo				= $request->getAttribute( 'dbo' );
		$insert_once		= stripslashes( $_GET['sao'] );
		$mail_id		= trim(stripslashes( $_GET['magid'] ));
		if( preg_match('/^([1-9]|[1-9][0-9])$/',$insert_once) == 0 ) {
			if( defined('MEMBER_MAIL_SEND_COUNT_DEFAULT') && preg_match('/^(|[1-9])[1-9]$/',MEMBER_MAIL_SEND_COUNT_DEFAULT) > 0 ) {
				$insert_once		= MEMBER_MAIL_SEND_COUNT_DEFAULT;
			} else {
				$insert_once		= 10;
			}
		}

		// プロセスロック
		$lock	= new util_LockProcess( "member.mail.createlist.lock" );
		$lock->lock();
		
		// マガジンが指定されていないなら
		if( strlen( $mail_id ) == 0 ) {
			// 配信準備前のメール情報を取得
			$mail_object_array	= array();
			$sql	= "SELECT mail_id FROM " . TABLE_NAME_MEMBER_MAIL
				. " WHERE status_flag=0 "
				. " AND reserve_date<NOW() "
				. " ORDER BY reserve_date DESC"
			;
			$mail_result			= $dbo->queryAll( $sql, 'hash' );
			if ( false === $mail_result ) {
				$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
			} else if ( count($mail_result) > 0 ){
				$mail_id		= trim($mail_result[0]['mail_id']);
			}
		}
		$create_listed_count	= 0;
		$mail_object	= spider_Controller::createObject('member_DaoMemberMail');
		if( strlen($mail_id) == 0 ) {
			$request->addLocaledError('member.error.mail.nowaitmail',SPIDER_LOG_LEVEL_FATAL,array(''));
		} else if ( !$dbo->loadById( $mail_object, $mail_id ) ) {
			$request->addLocaledError('member.error.mail.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
		} else {
			// 存在するならSQLで取り出し
			list( $count_sql, $list_sql )		= explode(' ; ', $mail_object->select_condition );
			// メール作成後に追加されたメンバーに配信しないようmember_number ASCでソートする為
			// list_sqlはORDER BY以降を切り捨てる
			if( strpos($list_sql,' ORDER BY') > 0 ) {
				$list_sql	= substr( $list_sql, 0, strpos($list_sql,' ORDER BY') );
				$list_sql	.= ' ORDER BY '.TABLE_NAME_MEMBER.'.member_number ASC';
				// FROMの前にmember_numberをつける
				$list_sql	= str_replace(' FROM '.TABLE_NAME_MEMBER,
					', '.TABLE_NAME_MEMBER.'.member_number FROM '.TABLE_NAME_MEMBER,
					$list_sql);
			}
			// オフセットから指定件数分取得する
			$dbo->setLimit( $insert_once, $mail_object->list_count );
			$result	= $dbo->queryAll( $list_sql,'hash' );
			if ( $result === false ) {
				$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($list_sql));
			} else {
				// 取得できたら
				$create_listed_count	= count($result);
				foreach ( $result as $row ) {
					$is_insert	= true;
					$delivery_status	= 0;
					$log_message		= '';
					$member_id			= trim($row['member_id']);
					$delivery_address	= '';
					$member_object	= spider_Controller::createObject('member_DaoMember');
					// 該当メールの送信リストに登録済みの同じメンバーIDの重複がないか再度チェック
					$sql	= "SELECT COUNT(*) FROM " . TABLE_NAME_MEMBER_MAIL_LOG
						. " WHERE mail_id=" . $dbo->quote( $mail_object->mail_id )
						. " AND member_id=" . $dbo->quote( $member_id )
					;
					$member_sended_count		= $dbo->queryOne($sql);
					if ( false === $member_sended_count ) {
						$delivery_status	= 251;
						$log_message		= '[NG]'.date('Y-m-d H:i:s').' Query Error! : '. $sql;
					} else if( $member_sended_count > 0 ) {
						// 既に処理済みのメンバーならスキップ
						continue;
					}
					// 配信メールマガジン種別に含まれているか確認
					if( 0 == $delivery_status ) {
						$sql	= 'SELECT COUNT(*) FROM ' . TABLE_NAME_MEMBER_MAIL_REJECT_MEMBER
							. ' WHERE list_id='.$dbo->quote($mail_object->list_id)
							. ' AND member_id='.$dbo->quote(trim($member_id))
						;
						$count	= $dbo->queryOne($sql);
						if(false === $count) {
							$log_message		= '[NG]'.date('Y-m-d H:i:s').'Fail to load reject information!';
							$delivery_status	= 205;
						} else if( $count > 0 ) {
							$log_message		= '[NG]'.date('Y-m-d H:i:s').'This member belong to reject list!';
							$delivery_status	= 103;
						}
					}
					// 対象会員情報の読み込み
					if( 0 == $delivery_status ) {
						if( !$dbo->loadById( $member_object, $member_id ) ) {
							// メンバー情報を読み込めないか削除済みなら、情報読み込み失敗で追加
							$delivery_status	= 203;
							$log_message		= '[NG]'.date('Y-m-d H:i:s').' No Member! : ' . $member_id;
						} else if( 200 < $member_object->status_flag ) {
							// メンバーが退会済みなら
							$delivery_status	= 102;
							$log_message		= '[NG]'.date('Y-m-d H:i:s').' Member has left! : ' . $member_id;
						} else {
							// 配信対象メールアドレスを確定
							$delivery_address	= $member_object->pc_mail;
							if( 'm' == $mail_object->target_type ) {
								$delivery_address	= $member_object->mb_mail;
							}
							if ( strlen(trim($delivery_address)) == 0 ) {
								// 配信対象メールアドレスが設定されていない
								$delivery_status	= 101;
								$log_message		= '[NG]'.date('Y-m-d H:i:s').'Target Mail Address is not registed!';
							}
						}
					}
					// メール配信ログテーブルに行を追加
					$sql	= "INSERT INTO " . TABLE_NAME_MEMBER_MAIL_LOG
						. "( mail_id, member_id, delivery_address, delivery_status, delivery_log ) VALUES ("
						. $dbo->quote( $mail_id )
						. ", " . $dbo->quote( $member_id )
						. ", ". $dbo->quote( $delivery_address )
						. ", ". $dbo->quote( $delivery_status )
						. ", ". $dbo->quote( $log_message )
						. " )"
					;
					$insert_result	= $dbo->query( $sql );
					if ( false === $insert_result ) {
						$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
					} else {
						$mail_object->list_count++;
					}
				}
				// リスト化の状態に応じてメールの状態を変更
				if( $mail_object->list_count >= $mail_object->total_count || $create_listed_count ) {
					// リスト化が終了しているか、クエリの残り件数がない場合は配信準備完了
					$mail_object->status_flag	= 1;
				} else {
					$mail_object->status_flag	= 0;
				}
				$mail_object->updated_date		= date('Y-m-d H:i:s');
				if( $dbo->update( $mail_object, false ) ) {
				} else {
					$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			}
		}
		// プロセスロック解除
		$lock->release();

		$request->setAttribute('member.mail.mail_object',$mail_object );
	}
}
?>