<?php
/*
 * member/PackageConfig.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-09-18
 */
require_once(dirname(__FILE__)
.DIRECTORY_SEPARATOR.'package_define.inc.php');
require_once(dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'database2'
.DIRECTORY_SEPARATOR.'PackageConfigBase.class.php' );
require_once(dirname(__FILE__)
.DIRECTORY_SEPARATOR.'Connector.class.php');
require_once(dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'system'
.DIRECTORY_SEPARATOR.'login'
.DIRECTORY_SEPARATOR.'ModuleBase.class.php');
require_once(dirname(dirname( __FILE__ ))
.DIRECTORY_SEPARATOR.'database2'
.DIRECTORY_SEPARATOR.'AbstractData.class.php' );
require_once(dirname(dirname( __FILE__ ))
.DIRECTORY_SEPARATOR.'database2'
.DIRECTORY_SEPARATOR.'AbstractUser.class.php' );
require_once( dirname(dirname( __FILE__ ))
.DIRECTORY_SEPARATOR.'system'
.DIRECTORY_SEPARATOR.'DataFileWriter.class.php' );
require_once( dirname(dirname( __FILE__ ))
.DIRECTORY_SEPARATOR.'util'
.DIRECTORY_SEPARATOR.'CharUtility.class.php' );
if( is_object($GLOBALS['request_object']) ) {
	$GLOBALS['member.existsConnectorHash']
	= member_Connector::getExistsConnecterHash( $GLOBALS['request_object'] );
}
/**
 * 会員管理パッケージ基本情報保持クラス
 * 
 * - 概要
 *   Webサイトにおける一般的な会員登録とログイン機能、会員管理機能を提供します。
 * - 対応データベース
 *   MySQL
 *   PostgreSQL
 * - パッケージの詳細
 * 
 * @package member 会員管理パッケージ
 * @version 1.1.00
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.3.9
 * 
 */
class member_PackageConfig extends database2_PackageConfigBase {
	function member_PackageConfig() {
		$this->definitionHash						= array(
			'MEMBER_INIT_OPTION'			=> '2',
			'MEMBER_REGIST_ITEM'			=> array('name'),
			'MEMBER_REQUIRE_ITEM'		=> array(),
			'MEMBER_INITIAL_POINT'		=> '0',
			'MEMBER_PERMIT_REGIST_BY_USER'		=> 'true',
			'MEMBER_MAIL_DOMAIN'					=> '',
			'MEMBER_REGIST_MAIL_PREFIX'			=> 'reg',
			'MEMBER_RETURN_MAIL_PREFIX'			=> 'ret',
			'MEMBER_MAIL_SEND_COUNT_DEFAULT'	=> '10',
			'MEMBER_MAIL_SEND_COUNT_MOBILE'	=> '2',
			'MEMBER_MAIL_SEND_METHOD'			=> '',
			'MEMBER_MAIL_SEND_METHOD_OPTIONS'	=> array('sendmail_path'=>'/usr/sbin/sendmail','smtp_port'=>25),
			'MEMBER_REGIST_MAIL_URL'			=> SPIDER_URL_BASE.'member/join/form.php?tkey=',
			'MEMBER_MODIFY_MAIL_URL'			=> SPIDER_URL_BASE.'member/modify/form.php?tkey=',
		);
	}
	/**
	 * パッケージの表示順序を取得
	 * @return int パッケージ順序
	 */
	function getPackageOrder() {
		return 30;
	}
	/**
	 * パッケージの表示名を取得
	 * @return string パッケージ名称
	 */
	function getPackageViewName() {
		return $GLOBALS['MEMBER_PERSONAL_LABEL'].'管理';
	}
	/**
	 * パッケージ概要説明を取得します。
	 */
	function getPackageDescription() {
		return 'Webサイトに会員制機能を提供します。'.$GLOBALS['SHOPPING_LABEL_ORDER'].'者や会員の管理をおこないます。会員へのメール配信や対応履歴入力などもここからおこなうことができます。';
	}
	/**
	 * パッケージ依存関係のハッシュを取得
	 * @return hash array('packageId'=>array('version','version',...))
	 */
	function getPackageDependenciesHash() {
		return array(
			'content'	=> array('1.1.00'),
			'design'	=> array('1.1.00'),
			'database2'	=> array('1.0.02'),
		);
	}
	//
	// インストール関連メソッド
	//
	/**
	 * definitionHashに設定された値の妥当性検査を行います。
	 * @param $request spider_HttpRequestクラスオブジェクトの参照
	 * @return boolean エラーがあるならfalse
	 */
	function validateDifinitionHash( & $request ) {
		if( preg_match('/^[0-3]+$/',$this->definitionHash['MEMBER_INIT_OPTION']) == 0 ) {
			$request->addLocaledError('member.error.config.initdboption',SPIDER_LOG_LEVEL_FATAL,array());
		}
		if( !is_array($this->definitionHash['MEMBER_REGIST_ITEM']) ) {
			$request->addLocaledError('member.error.config.invalidregitem',SPIDER_LOG_LEVEL_FATAL,array());
		}
		if( !is_array($this->definitionHash['MEMBER_REQUIRE_ITEM']) ) {
			$request->addLocaledError('member.error.config.invalidreqitem',SPIDER_LOG_LEVEL_FATAL,array());
		}
		$this->definitionHash['MEMBER_INITIAL_POINT']	= mb_convert_kana($this->definitionHash['MEMBER_INITIAL_POINT'],'a');
		if( preg_match('/^[0-9]{1,7}$/',$this->definitionHash['MEMBER_INITIAL_POINT']) == 0 ) {
			$request->addLocaledError('member.error.config.invalidpoint',SPIDER_LOG_LEVEL_FATAL,array());
		}
		if( $this->definitionHash['MEMBER_PERMIT_REGIST_BY_USER'] != 'true' ) {
			$this->definitionHash['MEMBER_PERMIT_REGIST_BY_USER']	= 'false';
		}

		$this->definitionHash['MEMBER_MAIL_SEND_COUNT_DEFAULT']	= mb_convert_kana($this->definitionHash['MEMBER_MAIL_SEND_COUNT_DEFAULT'],'a');
		if( preg_match('/^([1-9]|[1-9][0-9])$/',$this->definitionHash['MEMBER_MAIL_SEND_COUNT_DEFAULT']) == 0 ) {
			$request->addLocaledError('member.error.config.invalidmailoc',SPIDER_LOG_LEVEL_FATAL,array());
		}
		$this->definitionHash['MEMBER_MAIL_SEND_COUNT_MOBILE']	= mb_convert_kana($this->definitionHash['MEMBER_MAIL_SEND_COUNT_MOBILE'],'a');
		if( preg_match('/^([1-9]|[1-9][0-9])$/',$this->definitionHash['MEMBER_MAIL_SEND_COUNT_MOBILE']) == 0 ) {
			$request->addLocaledError('member.error.config.invalidmailoc',SPIDER_LOG_LEVEL_FATAL,array());
		}
		return true;
	}
	/**
	 * インストールを実行します。
	 */
	function install( & $request ) {
		$result		= parent::install( $request );
		$instPath	= DIR_PATH_DATA.'/member.define.inc.php';
		if( $result ) {
			// 通知メールテンプレートをインサート
			$databaseConfig	= new database2_PackageConfig();
			if( $databaseConfig->load( $request ) ) {
			} else {
				$databaseConfig	= $request->getAttribute('database.configuration_object');
				if( is_null($databaseConfig) || get_class($databaseConfig) != get_class(new database2_PackageConfig()) ) {
					$request->addLocaledError('member.error.config.requiredb2',SPIDER_LOG_LEVEL_FATAL,array());
				}
			}
			if( !$request->isError() ) {
				// システムメールテンプレートのインストール
				$connection	= $databaseConfig->getWritableConnection( $request );
				$request->setAttribute('dbo',$connection);
				spider_Controller::loadClassDefinition('member_DaoMemberMailTemplate');
				if(member_DaoMemberMailTemplate::insertTemplateByRootFolder( $request,
				dirname(__FILE__).DIRECTORY_SEPARATOR.'install'.DIRECTORY_SEPARATOR.'mail')){
				} else {
					$request->addLocaledError('member.error.config.failtoctemplate',SPIDER_LOG_LEVEL_FATAL,array());
				}
				$connection->disconnect();
			}
			if( $request->isError() ) {
				return false;
			} else {
				return true;
			}
		} else {
			return false;
		}
	}
	/**
	 * アンインストールを実行します。
	 */
	function uninstall( & $request ) {
		return parent::uninstall( $request );
	}
	/**
	 * ログインユーザーとして利用できるクラス名称を取得するインターフェースメソッド
	 */
	function getLoginClassNameArray( & $request ) {
		return array('member_DaoMember');
	}
}
?>