<?php
/*
 * member/MemberBankAccount.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-09-10
 */
require_once( dirname( __FILE__ )
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
require_once( dirname(dirname( __FILE__ ))
.DIRECTORY_SEPARATOR.'database2'
.DIRECTORY_SEPARATOR.'AbstractData.class.php');
/**
 * member_DaoMemberBankAccount
 * memberパッケージ データアクセスオブジェクトクラス member_bank_accountテーブル用
 */
class member_DaoMemberBankAccount extends database2_AbstractData {
	/** シリアル番号	*/
	var $account_number;
	/** 口座ID	*/
	var $account_id;
	/** 会員ID	*/
	var $member_id;
	/** 状態フラグ： 0=新規, 101=稼働中, 255=削除済	*/
	var $status_flag	= 0;
	/** 順序番号	*/
	var $order_number	= 0;
	/** 金融機関コード	*/
	var $bank_code;
	/** 金融機関名	*/
	var $bank_name;
	/** 金融機関名フリガナ	*/
	var $bank_kana;
	/** 支店コード	*/
	var $bank_branch_code;
	/** 支店名	*/
	var $bank_branch_name;
	/** 支店名フリガナ	*/
	var $bank_branch_kana;
	/** 口座種別	*/
	var $bank_account_type;
	/** 口座番号	*/
	var $bank_account_code;
	/** 口座名義	*/
	var $bank_account_name;
	/** 口座名義フリガナ	*/
	var $bank_account_kana;
	/** 更新日	*/
	var $updated_date;
	/** 登録日	*/
	var $registered_date;
	/** 登録者ID	*/
	var $owner_id;
	/** 変更者ＩＤ	*/
	var $modifier_id;
	
	/**
	 * コンストラクタ
	 */
	function member_DaoMemberBankAccount(){
	}
	/**
	 * インサート前に行いたい処理
	 * @param MDBObject $dbo MDB2オブジェクトかその互換オブジェクト
	 * @return boolean 成功したらtrue
	 */
	function pre_insert( $dbo ) {
		return true;
	}
	/**
	 * インサート後に行いたい処理
	 * @param MDBObject $dbo MDB2オブジェクトかその互換オブジェクト
	 * @return boolean 成功したらtrue
	 */
	function post_insert( $dbo ) {
		return true;
	}
	/**
	 * アップデート前に行いたい処理
	 * @param MDBObject $dbo MDB2オブジェクトかその互換オブジェクト
	 * @return boolean 成功したらtrue
	 */
	function pre_update( $dbo ) {
		return true;
	}
	/**
	 * アップデート後に行いたい処理
	 * @param MDBObject $dbo MDB2オブジェクトかその互換オブジェクト
	 * @return boolean 成功したらtrue
	 */
	function post_update( $dbo ) {
		return true;
	}
	/**
	 * 設定された値の妥当性検査を行います
	 */
	function validate( & $request ) {
		$dbo	= $request->getAttribute( 'dbo' );
		// 金融機関コード
		if( strlen($this->bank_code) == 0 ) {
		} else if( preg_match('/^[0-9a-zA-Z]{1,8}$/',$this->bank_code) == 0 ) {
			$request->addLocaledError('member.error.bank.invalidcode',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		// 金融機関名
		if( strlen($this->bank_name) == 0 ) {
		} else if( strlen($this->bank_name) > 240 ) {
			$request->addLocaledError('member.error.bank.invalidname',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		// 金融機関名フリガナ
		if( strlen($this->bank_kana) == 0 ) {
		} else if( strlen($this->bank_kana) > 240 ) {
			$request->addLocaledError('member.error.bank.invalidkana',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		// 支店コード
		if( strlen($this->bank_branch_code) == 0 ) {
		} else if( preg_match('/^[0-9a-zA-Z]{1,16}$/',$this->bank_branch_code) == 0 ) {
			$request->addLocaledError('member.error.bank.invalidbranchcode',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		// 支店名
		if( strlen($this->bank_branch_name) == 0 ) {
		} else if( strlen($this->bank_branch_name) > 240 ) {
			$request->addLocaledError('member.error.bank.invalidbranchname',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		// 支店名フリガナ
		if( strlen($this->bank_branch_kana) == 0 ) {
		} else if( strlen($this->bank_branch_kana) > 240 ) {
			$request->addLocaledError('member.error.bank.invalidbranchkana',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		// 口座種別
		if( strlen($this->bank_account_type) == 0 ) {
		} else if( preg_match('/^[0-9]{1,2}$/',$this->bank_account_type) == 0 ) {
			$request->addLocaledError('member.error.bank.invalidtype',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		// 口座番号
		if( strlen($this->bank_account_code) == 0 ) {
		} else if( preg_match('/^[0-9a-zA-Z]{1,16}$/',$this->bank_account_code) == 0 ) {
			$request->addLocaledError('member.error.bank.invalidaccount',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		// 口座名義
		if( strlen($this->bank_account_name) == 0 ) {
		} else if( strlen($this->bank_account_name) > 240 ) {
			$request->addLocaledError('member.error.bank.invalidaccountname',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		// 口座名義フリガナ
		if( strlen($this->bank_account_kana) == 0 ) {
		} else if( strlen($this->bank_account_kana) > 240 ) {
			$request->addLocaledError('member.error.bank.invalidaccountkana',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		return true;
	}
	/**
	 * 渡されたAbstractDataオブジェクトに対する編集権限があるか確認します
	 * @param &$request spider_HttpRequestオブジェクト
	 * @param $abstractUser system_login_AbstractUser実装クラスインスタンス
	 */
	function canEditData( & $request, $abstractUser ) {
		if( is_a($abstractUser,'system_login_UserAdministrator') ) {
			// システム管理者ならtrue
			return true;
		} else if( is_a($abstractUser,'admin_DaoAdminMember') ) {
			// adminパッケージのログインユーザの場合
			return true;
		} else if( is_a($abstractUser,'member_DaoMember') ) {
			// memberパッケージのログインユーザなら自分自身はtrue
			if( $this->member_id == $abstractUser->member_id ) {
				return true;
			} else {
				return false;
			}
		} else {
			// パッケージユーザ以外は編集不可
			return false;
		}
	}
}
?>