<?php
/*
 * member/DaoMember.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(__FILE__)
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * 会員テーブルレコード対応 DAOクラス
 * 
 * @package member 会員管理パッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_DaoMember extends database2_AbstractUser {
	/** 会員シリアル番号	*/
	var $member_number;
	/** 会員ID	*/
	var $member_id;
	/** 会員種別：0=非会員, 1=正規会員	*/
	var $member_class	= 1;
	/** ログインID	*/
	var $login_id;
	/** ログインパスワード	*/
	var $login_password;
	/** 認証キー	*/
	var $auth_key;
	/** 表示名称	*/
	var $view_name;
	/** PCメールアドレス	*/
	var $pc_mail;
	/** モバイルメールアドレス	*/
	var $mb_mail;
	/** モバイル端末識別番号	*/
	var $terminal_id;
	/** モバイルSIM識別番号	*/
	var $sim_id;
	/** 現在の保持ポイント数	*/
	var $point			= 0;
	/** 状態フラグ	*/
	var $status_flag	= 0;
	/** 名	*/
	var $first_name;
	/** 姓	*/
	var $family_name;
	/** 名カナ	*/
	var $first_kana;
	/** 姓カナ	*/
	var $family_kana;
	/** 国名	*/
	var $country_name;
	/** 郵便番号	*/
	var $zip_code;
	/** 都道府県番号	*/
	var $prefecture_number;
	/** 住所・番地	*/
	var $address;
	/** 建物名・部屋番号	*/
	var $building;
	/** 電話番号	*/
	var $telephone_number;
	/** FAX番号	*/
	var $faximili_number;
	/** 携帯番号	*/
	var $mobile_number; 
	/** 郵便番号2	*/
	var $zip_code2;
	/** 都道府県番号2	*/
	var $prefecture_number2;
	/** 住所・番地2	*/
	var $address2;
	/** 建物名・部屋番号2	*/
	var $building2;
	/** 電話番号2	*/
	var $telephone_number2;
	/** FAX番号2	*/
	var $faximili_number2;
	/** ホームページURL	*/
	var $url;
	/** 生年	*/
	var $birth_year;
	/** 生月	*/
	var $birth_month;
	/** 生日	*/
	var $birth_day;
	/** 性別	1=女性, 2=男性 */
	var $sex;
	/** 血液型	1=A, 2=B, 3=O, 4=AB */
	var $blood_type;
	/** 身長		mm単位で保管 */
	var $height;
	/** 体重		g単位で保管 */
	var $weight;
	/** バスト	 */
	var $bust;
	/** ウエスト	 */
	var $waist;
	/** ヒップ	 */
	var $hip;
	/** 自己紹介	*/
	var $introduction;
	/** 会社名	*/
	var $company_name;
	/** 部署名	*/
	var $section_name;
	/** 管理用概要メモ	*/
	var $description;
	/** アクセス拒否URI	改行区切りで設定 */
	var $deny_uris;
	/** 更新日時	*/
	var $updated_date;
	/** 登録日時	*/
	var $registered_date;
	/** 所有者ID	*/
	var $owner_id;
	/** 更新者ID	*/
	var $modifier_id;
	// オブジェクト拡張
	/** メールマガジン種別ID配列	*/
	var $rejectListIdArray		= array();
	var $rejectListIdArray_org	= array();
	/** オプションハッシュ	*/
	var $optionHash		= array();
	var $optionHash_org	= array();
	// エラー記録
	/** ログインエラー回数	*/
	var $login_error_count	= 0;
	/** ログインエラー最終日時	*/
	var $login_error_date		= null;
	/** ＰＣメールリターン回数	*/
	var $pc_mail_error_count	= 0;
	/** ＰＣメールリターン日時	*/
	var $pc_mail_error_date	= null;
	/** モバイルメールリターン回数	*/
	var $mb_mail_error_count	= 0;
	/** モバイルメールリターン日時	*/
	var $mb_mail_error_date	= null;
	// 郵便番号・電話番号の分活表示用一時プロパティ
	var $zip_code_pre;
	var $zip_code_pst;
	var $zip_code2_pre;
	var $zip_code2_pst;
	var $telephone_number_area;
	var $telephone_number_city;
	var $telephone_number_local;
	var $faximili_number_area;
	var $faximili_number_city;
	var $faximili_number_local;
	var $telephone_number2_area;
	var $telephone_number2_city;
	var $telephone_number2_local;
	var $faximili_number2_area;
	var $faximili_number2_city;
	var $faximili_number2_local;
	var $mobile_number_area;
	var $mobile_number_city;
	var $mobile_number_local;
	var $last_correspond_date_year;
	var $last_correspond_date_month;
	var $last_correspond_date_day;
	var $height_view;
	var $weight_view;
	
	/**
	 * コンストラクタ
	 */
	function member_DaoMember(){
		$this->rejectListIdArray		= array();
		$this->rejectListIdArray_org	= array();
	}
	/**
	 * ログインIDからユーザーを読み込む抽象メソッド
	 * @param object $request spider_HttpRequestクラスのインスタンス
	 * @param string $loginId ログインID
	 * @return boolean 一意のユーザを読み込むことができればtrue
	 */
	function loadLoginUser( & $request, $loginId ) {
		$isConnected	= true;
		$dbo			= $request->getAttribute( 'dbo' );
		if( !is_object($dbo) ) {
			$isConnected	= false;
			require_once(DIR_PATH_LIB.DIRECTORY_SEPARATOR.'database2'.DIRECTORY_SEPARATOR.'Connect.class.php');
			database2_Connect::execute($request);
			$dbo	= $request->getAttribute( 'dbo' );
		}
		// 携帯電話の端末IDまたはSIMのログインに対応
		$isSimSet	= ( preg_match('/^([oO][nN]|[tT][rR][uU][eE]|[yY][eE][sS])$/',trim(stripslashes($_POST['simset']))) > 0 );
		$isSimLogin	= ( preg_match('/^([oO][nN]|[tT][rR][uU][eE]|[yY][eE][sS])$/',trim(stripslashes($_POST['simlogin']))) > 0 );
		$terminalId	= '';
		$sql		= '';
		$agentClass	= $request->getAttribute('spider.access_agent_class');
		if( 'docomo' == $agentClass || 'docomo2' == $agentClass ) {
			$this->setTerminalInformationDoCoMo();
		} else if( 'au' == $agentClass ) {
			$this->setTerminalInformationAu();
		} else if( 'softbank' == $agentClass ) {
			$this->setTerminalInformationSoftBank();
		}
		// 簡単ログイン
		if( ( $isSimLogin ) && strlen($this->sim_id) > 0 ) {
			// SIMが設定されているなら読み込みを試みる
			$sql		= 'SELECT * FROM '.TABLE_NAME_MEMBER
				.' WHERE sim_id='.$dbo->quote($this->sim_id)
				.' AND status_flag>=100 AND status_flag<200'
				.' AND member_class>0'
			;
			$result	= $dbo->queryAll( $sql, 'hash' );
			if( !$isConnected ) {
				database2_Connect::post_process($request);
			}
			if( false === $result ) {
			} else if( count($result) == 0 ) {
			} else if( count($result) == 1 ) {
				// 結果が一つだけなら成功
				$dbo->setRowToFields( $result[0], $this );
				$this->login_password	= 'SYSTEM_SIM_ID_TERMINAL_LOGIN_METHOD';
				return true;
			} else {
			}
		}
		// パスワードログイン
		$accessSimId	= $this->sim_id;
		$accessTmId		= $this->terminal_id;
		if ( $dbo->loadById( $this, array( 'login_id' => $loginId ) ) && $this->status_flag >= 100 && $this->status_flag < 200 && $this->member_class > 0 ) {
			if( strlen($accessSimId) > 0 && $accessSimId != $this->sim_id ) {
				// アクセス時にsim番号が送られていてデータベース登録と異なるなら更新する
				$this->sim_id		= $accessSimId;
				$this->terminal_id	= $accessTmId;
			}
			if( !$isConnected ) {
				database2_Connect::post_process($request);
			}
			if( 'docomo' == $agentClass || 'docomo2' == $agentClass ) {
				$this->setTerminalInformationDoCoMo();
			} else if( 'au' == $agentClass ) {
				$this->setTerminalInformationAu();
			} else if( 'softbank' == $agentClass ) {
				$this->setTerminalInformationSoftBank();
			}
			return true;
		} else {
			if( !$isConnected ) {
				database2_Connect::post_process($request);
			}
			return false;
		}
	}
	/**
	 * ユーザーユニークIDからユーザーを読み込む抽象メソッド
	 * @param object $request spider_HttpRequestクラスのインスタンス
	 * @param string $loginId ログインID
	 * @return boolean 一意のユーザを読み込むことができればtrue
	 */
	function loadLoginUserByUniqueId( & $request, $uniqueId ) {
		$isConnected	= true;
		$dbo			= $request->getAttribute( 'dbo' );
		if( !is_object($dbo) ) {
			$isConnected	= false;
			require_once(DIR_PATH_LIB.DIRECTORY_SEPARATOR.'database2'.DIRECTORY_SEPARATOR.'Connect.class.php');
			database2_Connect::execute($request);
			$dbo	= $request->getAttribute( 'dbo' );
		}
		$id_hush = array( 'member_id' => $uniqueId );
		if ( $dbo->loadById( $this, $id_hush ) ) {
			if( !$isConnected ) {
				database2_Connect::post_process($request);
			}
			return true;
		} else {
			if( !$isConnected ) {
				database2_Connect::post_process($request);
			}
			return false;
		}
	}
	/**
	 * メールアドレスからユーザーを読み込むメソッドの実装
	 * @param object $request spider_HttpRequestクラスのインスタンス
	 * @param string $loginId ログインID
	 * @return boolean 一意のユーザを読み込むことができればtrue
	 */
	function loadLoginUserByEmail( & $request, $email ) {
		$isConnected	= true;
		$dbo			= $request->getAttribute( 'dbo' );
		if( !is_object($dbo) ) {
			$isConnected	= false;
			require_once(DIR_PATH_LIB.DIRECTORY_SEPARATOR.'database2'.DIRECTORY_SEPARATOR.'Connect.class.php');
			database2_Connect::execute($request);
			$dbo	= $request->getAttribute( 'dbo' );
		}
		$sql	= 'SELECT * FROM '.TABLE_NAME_MEMBER.' WHERE ( pc_mail='.$dbo->quote($email)
			.' OR mb_mail='.$dbo->quote($email).' ) AND status_flag BETWEEN 100 AND 199'
			.' AND member_class>0';
		$result	= $dbo->queryAll( $sql, 'hash' );
		$returnVal	= false;
		if( false === $result ) {
			$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
		} else if( count( $result ) == 0 ) {
		} else if( count( $result ) > 1 ) {
		} else {
			$dbo->setRowToFields( $result[0], $this );
			$returnVal	= true;
		}
		if( !$isConnected ) {
			database2_Connect::post_process($request);
		}
		return $returnVal;
	}
	/**
	 * ログイン履歴を記録する抽象メソッド
	 */
	function registLoginHistory( & $request, $loginResult ) {
		$isConnected	= true;
		$dbo			= $request->getAttribute( 'dbo' );
		if( !is_object($dbo) ) {
			$isConnected	= false;
			require_once(DIR_PATH_LIB.DIRECTORY_SEPARATOR.'database2'.DIRECTORY_SEPARATOR.'Connect.class.php');
			database2_Connect::execute($request);
			$dbo	= $request->getAttribute( 'dbo' );
		}
		$sql	= 'INSERT INTO '.$this->getTableName().'_login_history'
			.' ( member_id, login_date, remote_address, remote_host, user_agent, login_result )'
			.' VALUES ('
			.$dbo->quote($this->member_id)
			.','.$dbo->quote(date('Y-m-d H:i:s'))
			.','.$dbo->quote($_SERVER['REMOTE_ADDR'])
			.','.$dbo->quote($_SERVER['REMOTE_HOST'])
			.','.$dbo->quote($_SERVER['HTTP_USER_AGENT'])
			.','.$loginResult
			.')';
		if( false === $dbo->query( $sql ) ) {
			if( !$isConnected ) {
				database2_Connect::post_process($request);
			}
			return false;
		} else {
			$isSimSet	= ( preg_match('/^([oO][nN]|[tT][rR][uU][eE]|[yY][eE][sS])$/',trim(stripslashes($_POST['simset']))) > 0 );
			if( $isSimSet && ($this->sim_id != $this->sim_id_org) ) {
				// 他の紐づいているアカウントがあったら解除
				$sql	= 'UPDATE '.TABLE_NAME_MEMBER.' SET sim_id=\'\''
					.' WHERE member_id<>'.$dbo->quote($this->member_id)
					.' AND sim_id='.$dbo->quote($this->sim_id)
				;
				$dbo->query($sql);
				// sim番号が変わっているならアップデートする
				$this->login_password	= $this->login_password_org;
				$this->updated_date		= date('Y-m-d H:i:s');
				$dbo->update( $this, true );
			}
			if( !$isConnected ) {
				database2_Connect::post_process($request);
			}
			return true;
		}
	}
	/**
	 * ユニークIDを取得します
	 */
	function getUniqueId() {
		return $this->member_id;
	}
	/**
	 * ログインIDを取得します
	 * @return string $loginId システム全体で一意のログイン識別記号
	 */
	function getLoginId(){
		return $this->login_id;
	}
	/**
	 * ログインパスワードを取得します
	 * @return string $loginPassword ログインパスワード
	 */
	function getLoginPassword(){
		return $this->login_password;
	}
	/**
	 * ログインパスワードを照合します
	 * @param spider_HttpRequest &$request spider_HttpRequestクラスオブジェクトの参照
	 * @param string $inputPassword 入力されたパスワード
	 * @return boolean パスワードが一致したらtrue
	 */
	function confirmPassword( & $request, $inputPassword ) {
		if( $this->login_password == $this->encodePassword($request,$inputPassword) ) {
			return true;
		} else if( $inputPassword == $this->decodePassword( $request, $this->login_password ) ){
			return true;
		}
		return false;
	}
	/**
	 * ログインパスワードをランダムに再発行します
	 * @param spider_HttpRequest &$request spider_HttpRequestクラスオブジェクトの参照
	 * @return mixed 新しく発行したパスワード文字列。再発行に失敗したらfalse。
	 */
	function renewPassword( & $request ) {
		// データベース接続を確認
		$isConnected	= true;
		$dbo			= $request->getAttribute( 'dbo' );
		if( !is_object($dbo) ) {
			$isConnected	= false;
			require_once(DIR_PATH_LIB.DIRECTORY_SEPARATOR.'database2'.DIRECTORY_SEPARATOR.'Connect.class.php');
			database2_Connect::execute($request);
			$dbo	= $request->getAttribute( 'dbo' );
		}
		// パスワードをランダムに新規発行する
		$newPassword			= parent::renewPassword( $request );
		$this->login_password	= $this->encodePassword($request,$newPassword);
		$sql	= 'UPDATE '.TABLE_NAME_MEMBER.' SET login_password='.$dbo->quote($this->login_password)
		.' WHERE member_id='.$dbo->quote($this->member_id);
		if( $dbo->query($sql) ) {
		} else {
			$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_FATAL,array($sql));
		}
		// 元々接続されていないなら切断
		if( !$isConnected ) {
			database2_Connect::post_process($request);
		}
		if( $request->isError() ) {
			return false;
		} else {
			return $newPassword;
		}
	}
	/**
	 * ログイン者の表示名称を取得します
	 * @return string $viewName ログイン者の表示名
	 */
	function getUserViewName() {
		return $this->view_name;
	}
	/**
	 * システムグループレベルを取得します
	 * SYSTEM_LOGIN_USER_ADMINISTRATORS 0 管理者グループ
	 * SYSTEM_LOGIN_USER_POWERS パワーユーザーグループ
	 * SYSTEM_LOGIN_USER_USERS 一般ユーザーグループ
	 * SYSTEM_LOGIN_USER_GUEST ゲストユーザー グループ
	 */
	function getLoginGroupLevel(){
		return SYSTEM_LOGIN_USER_USERS;
	}
	/**
	 * オプションテーブルを読み込む
	 */
	function loadRelation( $dbo ) {
		$this->optimize();
		// メールマガジン種別設定の読み込み
		$this->rejectListIdArray	= array();
		$this->rejectListIdArray_org	= array();
		$sql	= 'SELECT list_id FROM '.TABLE_NAME_MEMBER_MAIL_REJECT_MEMBER
			.' WHERE member_id='.$dbo->quote( $this->member_id )
		;
		$result	= $dbo->queryAll( $sql, 'hash' );
		if( $result === false ) {
			return false;
		} else {
			foreach( $result as $row ) {
				if( strlen(trim($row['list_id'])) > 0 ) {
					array_push( $this->rejectListIdArray, trim($row['list_id']) );
					array_push( $this->rejectListIdArray_org, trim($row['list_id']) );
				}
			}
		}
		list($this->zip_code_pre,$this->zip_code_pst)	= explode('-',$this->zip_code);

		// オプション値の読み込み
		$this->optionHash		= array();
		$this->optionHash_org	= array();
		$sql	= 'SELECT * FROM '.TABLE_NAME_MEMBER_OPTION
			.' WHERE member_id='.$dbo->quote( $this->member_id )
			.' ORDER BY order_number ASC'
		;
		$result	= $dbo->queryAll( $sql, 'hash' );
		if( $result === false ) {
			return false;
		} else {
			foreach( $result as $row ) {
				if( strlen(trim($row['option_name'])) > 0 ) {
					$this->optionHash[$row['option_name']]	= $row['option_value'];
					$this->optionHash_org[$row['option_name']]	= $row['option_value'];
				}
			}
		}
		
		// エラー回数の読み込み
		$sql	= 'SELECT * FROM '.TABLE_NAME_MEMBER_ERROR_COUNT.' WHERE member_id='.$dbo->quote( $this->member_id );
		$result	= $dbo->queryAll( $sql, 'hash' );
		if( $result === false ) {
		} else if( count($result) > 0 ) {
			$this->login_error_count	= $result[0]['login_error_count'];
			$this->login_error_date		= $result[0]['login_error_date'];
			$this->pc_mail_error_count	= $result[0]['pc_mail_error_count'];
			$this->pc_mail_error_date	= $result[0]['pc_mail_error_date'];
			$this->mb_mail_error_count	= $result[0]['mb_mail_error_count'];
			$this->mb_mail_error_date	= $result[0]['mb_mail_error_date'];
		} else {
			$this->login_error_count	= 0;
			$this->login_error_date		= null;
			$this->pc_mail_error_count	= 0;
			$this->pc_mail_error_date	= null;
			$this->mb_mail_error_count	= 0;
			$this->mb_mail_error_date	= null;
		}
		return true;
	}
	/**
	 * インサート後に行いたい処理を記述する抽象メソッドです。
	 * @param spider_HttpRequest $request spider_HttpRequestオブジェクト参照
	 * @return boolean 成功したらtrue
	 */
	function postInsert( & $request ) {
		$dbo	= $request->getAttribute('dbo');
		if( $request->isError() ) {
		} else {
			// エラー記録レコードの挿入
			$sql	= 'INSERT INTO '.TABLE_NAME_MEMBER_ERROR_COUNT
				.'(member_id) VALUES('.$dbo->quote($this->member_id).')';
			if( false === $dbo->query($sql) ) {
				$request->addLocaledError('database2.error.insert',SPIDER_LOG_LEVEL_FATAL,array($sql));
				return false;
			}
			// シリアルを取得
			$sql	= 'SELECT member_number FROM '.TABLE_NAME_MEMBER
				.' WHERE member_id='.$dbo->quote($this->member_id);
			$result	= $dbo->queryOne($sql);
			if( false === $result ) {
				$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
				return false;
			} else {
				$this->member_number	= $dbo->queryOne($sql);
			}
			// メールマガジン種別の挿入
			foreach( $this->rejectListIdArray as $listId ) {
				if( strlen(trim($listId)) > 0 ) {
					$sql	= 'INSERT INTO '.TABLE_NAME_MEMBER_MAIL_REJECT_MEMBER.'(list_id,member_id) VALUES('
						.$dbo->quote(trim($listId)).','.$dbo->quote(trim($this->member_id)).')';
					if( $dbo->query( $sql ) === false ) {
						$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
						return false;
					}
				}
			}
			// オプションの挿入
			$orderNumber	= 0;
			foreach( $this->optionHash as $optionName => $optionValue ) {
				if( strlen(trim($optionName)) > 0 ) {
					$sql	= 'INSERT INTO '.TABLE_NAME_MEMBER_OPTION.'(member_id,option_name,option_value,order_number) VALUES('
					.$dbo->quote(trim($this->member_id)).','.$dbo->quote(trim($optionName)).','.$dbo->quote(trim($optionValue)).','.$orderNumber
					.')';
					if( $dbo->query( $sql ) === false ) {
						$request->addLocaledError('database2.error.insert',SPIDER_LOG_LEVEL_FATAL,array($sql));
						return false;
					}
					$orderNumber++;
				}
			}
			
			// ログイン状態に応じて初期ポイントの操作を変更
			$loginUserObject	= $request->getAttribute('system.login.logininformation');
			if( is_object($loginUserObject)
				&& method_exists($loginUserObject,'getLoginGroupLevel')
				&& SYSTEM_LOGIN_USER_ADMINISTRATORS == $loginUserObject->getLoginGroupLevel()
			) {
				// 管理者登録の場合は入力したポイントをそのまま付与した履歴のみ残す
				if( $this->point != 0 ) {
					$pointHistory	= spider_Controller::createObject('member_DaoMemberPointHistory');
					$pointHistory->member_id		= $this->member_id;
					$pointHistory->action_point		= $this->point;
					$pointHistory->action_label		= $this->action_label;
					$pointHistory->action_detail	= '';
					$pointHistory->modifier_id		= $loginUserObject->getUniqueId();
					$pointHistory->owner_id			= $loginUserObject->getUniqueId();
					if( $dbo->insert($pointHistory) ){
					} else {
						$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_FATAL,array(''));
					}
				}
			} else {
				// 管理者登録でない場合
				if( $this->member_class > 0 && defined('MEMBER_INITIAL_POINT') && MEMBER_INITIAL_POINT > 0 ) {
					// 会員登録するなら初期ポイントインサート
					if( $this->pointChange($request, MEMBER_INITIAL_POINT, '初期ポイント付与' ) ) {
					} else {
						$request->addLocaledError('member.error.common.savepoint',SPIDER_LOG_LEVEL_FATAL,array(''));
						return false;
					}
				}
			}
			// 記録に失敗したら新規会員レコードは削除する
			if( $request->isError() && strlen($this->member_id) > 0 ) {
				$sql	= 'DELETE FROM '.TABLE_NAME_MEMBER.' WHERE member_id='.$dbo->quote($this->member_id);
				$result	= $dbo->query($sql);
				return false;
			}
		}
		return true;
	}
	/**
	 * インサート後に行いたい処理を記述する抽象メソッドです。
	 * @param MDBObject $dbo MDB2オブジェクトかその互換オブジェクト
	 * @param $result true/false
	 * @return boolean 成功したらtrue
	 */
	function post_insert( $dbo, $result ) {
		if( $result ) {
			// メールマガジン種別の挿入
			foreach( $this->rejectListIdArray as $listId ) {
				if( strlen(trim($listId)) > 0 ) {
					$sql	= 'INSERT INTO '.TABLE_NAME_MEMBER_MAIL_REJECT_MEMBER.'(list_id,member_id) VALUES('
						.$dbo->quote(trim($listId)).','.$dbo->quote(trim($this->member_id)).')';
					if( $dbo->query( $sql ) === false ) {
						return false;
					}
				}
			}
		}
		return true;
	}
	/**
	 * アップデート後に行いたい処理を記述する抽象メソッドです。
	 * @param MDBObject $dbo MDB2オブジェクトかその互換オブジェクト
	 * @param $result true/false
	 * @return boolean 成功したらtrue
	 */
	function post_update( $dbo, $result ) {
		if( $result ) {
			if( strlen(trim($this->history_id)) > 0 ) {
				// メールマガジン種別の履歴は本体の履歴をとったときだけとする
				// メールマガジン種別の履歴確認
				$isRejectChange	= false;
				foreach( $this->rejectListIdArray as $listId ) {
					if( !in_array( $listId, $this->rejectListIdArray_org ) ){
						$isRejectChange	= true;
						break;
					}
				}
				if( !$isRejectChange ) {
					foreach( $this->rejectListIdArray_org as $listId ) {
						if( !in_array( $listId, $this->rejectListIdArray ) ){
							$isRejectChange	= true;
							break;
						}
					}
				}
				// 履歴テーブルに古い配列を保存
				foreach( $this->rejectListIdArray_org as $listId ) {
					$sql	= 'INSERT INTO '.TABLE_NAME_MEMBER_MAIL_REJECT_MEMBER_HISTORY.'(history_id,list_id,member_id) VALUES( '
						.$dbo->quote($this->history_id).','.$dbo->quote($listId).','.$dbo->quote($this->member_id).')'
					;
					if( $dbo->query( $sql ) === false ) {
						return false;
					}
				}
				if( $isRejectChange ) {
					// メールマガジン種別に変更があるなら変更
					$sql	= 'DELETE FROM '.TABLE_NAME_MEMBER_MAIL_REJECT_MEMBER.' WHERE member_id='.$dbo->quote($this->member_id);
					if( $dbo->query( $sql ) ) {
						// 新しい配列を全てインサートする
						foreach( $this->rejectListIdArray as $listId ) {
							if( strlen(trim($listId)) > 0 ) {
								$sql	= 'INSERT INTO '.TABLE_NAME_MEMBER_MAIL_REJECT_MEMBER.'(list_id,member_id) VALUES('
									.$dbo->quote(trim($listId)).','.$dbo->quote(trim($this->member_id)).')'
								;
								if( $dbo->query( $sql ) === false ) {
									return false;
								}
							}
						}
					}
				}
				// オプションの履歴は本体の履歴をとったときだけとする
				$isOptionChange	= false;
				foreach( $this->optionHash as $optionName => $optionValue ) {
					if( !array_key_exists( $optionName, $this->optionHash_org ) ){
						$isOptionChange	= true;
						break;
					} else if( $this->optionHash_org[$optionName] != $optionValue ) {
						$isOptionChange	= true;
						break;
					}
				}
				if( !$isOptionChange ) {
					foreach( $this->optionHash_org as $optionName => $optionValue ) {
						if( !array_key_exists( $optionName, $this->optionHash ) ){
							$isOptionChange	= true;
							break;
						}
					}
				}
				// 履歴テーブルに古い配列を保存
				$orderNumber	= 0;
				foreach( $this->optionHash_org as $optionName => $optionValue ) {
					$sql	= 'INSERT INTO '.TABLE_NAME_MEMBER_OPTION_HISTORY.'(history_id,member_id,option_name,option_value,order_number) VALUES( '
						.$dbo->quote($this->history_id).','.$dbo->quote($this->member_id).','.$dbo->quote($this->$optionName).','.$dbo->quote($this->$optionValue).','.$orderNumber.')'
					;
					if( $dbo->query( $sql ) === false ) {
						return false;
					}
					$orderNumber++;
				}
				if( $isOptionChange ) {
					// メールマガジン種別に変更があるなら変更
					$sql	= 'DELETE FROM '.TABLE_NAME_MEMBER_OPTION.' WHERE member_id='.$dbo->quote($this->member_id);
					if( $dbo->query( $sql ) ) {
						// 新しい配列を全てインサートする
						$orderNumber	= 0;
						foreach( $this->optionHash as $optionName => $optionValue ) {
							if( strlen(trim($listId)) > 0 ) {
								$sql	= 'INSERT INTO '.TABLE_NAME_MEMBER_OPTION.'(member_id,option_name,option_value,order_number) VALUES('
									.$dbo->quote(trim($this->member_id)).','.$dbo->quote($optionName).','.$dbo->quote($optionValue).','.$orderNumber.')'
								;
								if( $dbo->query( $sql ) === false ) {
									return false;
								}
							}
							$orderNumber++;
						}
					}
				}
			}
		}
		return true;
	}
	/**
	 * 本オブジェクトのデータを渡されたAbstractUserが閲覧できるか確認します
	 * @param &$request spider_HttpRequestオブジェクト
	 * @param $abstractUser system_login_AbstractUser実装クラスインスタンス
	 */
	function canViewData( & $request, $abstractUser ) {
		if( is_a($abstractUser,'system_login_UserAdministrator') ) {
			// システム管理者ならtrue
			return true;
		} else if( is_a($abstractUser,'admin_DaoAdminMember') ) {
			// adminパッケージのログインユーザなら閲覧可能
			return true;
		} else if( is_a($abstractUser,'member_DaoMember') ) {
//			// memberパッケージのログインユーザなら自分自身はtrue
//			if( $this->member_id == $abstractUser->member_id ) {
//				return true;
//			} else {
//				return false;
//			}
			return true;
		} else {
//			// システム管理者とadminパッケージユーザ以外は閲覧も不可
//			return false;
			return true;
		}
	}
	/**
	 * 渡されたAbstractDataオブジェクトに対する編集権限があるか確認します
	 * @param &$request spider_HttpRequestオブジェクト
	 * @param $abstractUser system_login_AbstractUser実装クラスインスタンス
	 */
	function canEditData( & $request, $abstractUser ) {
		if( is_a($abstractUser,'system_login_UserAdministrator') ) {
			// システム管理者ならtrue
			return true;
		} else if( is_a($abstractUser,'admin_DaoAdminMember') ) {
			// adminパッケージのログインユーザの場合
			return true;
		} else if( is_a($abstractUser,'member_DaoMember') ) {
			// memberパッケージのログインユーザなら自分自身はtrue
			if( $this->member_id == $abstractUser->member_id ) {
				return true;
			} else {
				return false;
			}
		} else {
			// パッケージユーザ以外は編集不可
			return false;
		}
	}
	/**
	 * 指定のURIを表示する権限があるか確認します
	 */
	function hasUriPermittion( $uri ) {
		// 管理パネルにアクセスできないよう制御追加
		$adminPanelUri	= '/'.SYSTEM_DIR_NAME_ADMIN_PANEL;
		if( preg_match('/^'.util_CharUtility::escapeRegxStr($adminPanelUri).'/',$uri) > 0 ) {
			return false;
		}
		// URI拒否設定があるなら
		if( strlen($this->deny_uris) > 0 ) {
			$this->deny_uris	= trim($this->deny_uris);
			$this->deny_uris	= str_replace("\r\n","\n",$this->deny_uris);
			$this->deny_uris	= str_replace("\r","\n",$this->deny_uris);
			$denyUriArray			= explode("\n",$this->deny_uris);
			foreach( $denyUriArray as $denyUri ) {
				if( preg_match('/^'.util_CharUtility::escapeRegxStr($denyUri).'/',$uri) > 0 ) {
					return false;
				}
			}
		} else if( isset($GLOBALS['MEMBER_CLASS_DENY_URIS'])
		&& is_array($GLOBALS['MEMBER_CLASS_DENY_URIS'])
		&& isset($GLOBALS['MEMBER_CLASS_DENY_URIS'][$this->member_class])
		&& is_array($GLOBALS['MEMBER_CLASS_DENY_URIS'][$this->member_class])
		) {
			foreach( $GLOBALS['MEMBER_CLASS_DENY_URIS'][$this->member_class] as $denyUri ) {
				if( preg_match('/^'.util_CharUtility::escapeRegxStr($denyUri).'/',$uri) > 0 ) {
					return false;
				}
			}
		}
		return true;
	}
	/*
	 * 携帯電話情報関連
	 */
	/**
	 * 携帯電話アクセスの場合の端末番号とSIMを設定する
	 */
	function setMobileInformation( & $request ) {
		$agentClass	= $request->getAttribute('spider.access_agent_class');
		if( 'docomo' == $agentClass || 'docomo2' == $agentClass ) {
			$this->setTerminalInformationDoCoMo();
		} else if( 'au' == $agentClass ) {
			$this->setTerminalInformationAu();
		} else if( 'softbank' == $agentClass ) {
			$this->setTerminalInformationSoftBank();
		}
	}
	/**
	 * DoCoMo携帯電話アクセスの場合の端末番号とSIMを設定する
	 */
	function setTerminalInformationDoCoMo() {
		$userAgent	= $_SERVER['HTTP_USER_AGENT'];
		if ( ereg( 'DoCoMo\\/1.0', $userAgent ) ) {
			$str = substr( $userAgent, strpos( $userAgent, '/ser' ) );
			$this->terminal_id = str_replace( '/ser', '', $str );
		} else {
			$str = substr( $userAgent, strpos( $userAgent, '(' ) );
			$str = substr( $userAgent, 0, strpos( $userAgent, ')' ) );
			$val_array = explode( ';', $str );
			foreach ( $val_array as $val ) {
				if ( ereg( 'ser', $val ) ) {
					// ser
					$this->terminal_id = str_replace( 'ser', '', $val );
				} else if ( ereg( 'icc', $val ) ) {
					// icc
					$this->sim_id = str_replace( 'icc', '', $val );
				}
			}
		}
		// DoCoMoはiモードIDがあるならiモードIDをsim_idに入れる
		$iModeId	= trim($_SERVER['HTTP_X_DCMGUID']);
		if( strlen($iModeId) > 0 ) {
			$this->sim_id = $iModeId;
		}
	}
	/**
	 * au携帯電話アクセスの場合の端末番号とSIM番号を設定する
	 */
	function setTerminalInformationAu() {
		if( strlen(trim($_SERVER['HTTP_X_UP_SUBNO'])) > 0 ) {
			$this->terminal_id	= $_SERVER['HTTP_X_UP_SUBNO'];
			$this->sim_id		= $_SERVER['HTTP_X_UP_SUBNO'];
		}
	}
	/**
	 * SoftBank携帯電話アクセスの場合の端末番号とSIM番号を設定する
	 */
	function setTerminalInformationSoftBank() {
		$agentValArray	= explode('/', $_SERVER['HTTP_USER_AGENT']);
		foreach ( $agentValArray as $val ) {
			if ( ereg( '^SN', $val ) ) {
				$terminalId = $val;
				list( $sn, $browser ) = explode( ' ', $terminalId );
				$this->terminal_id = str_replace( 'SN', '', $sn );
				break;
			}
		}
		$this->sim_id	= $_SERVER['HTTP_X_JPHONE_UID'];
	}
	/**
	 * データベースの現在のメンバー保有ポイントを取得します
	 * @param $request spider_HttpRequestクラスオブジェクトの参照
	 * @return 現在の保有ポイント数値
	 */
	function pointCurrent( & $request ) {
		$dbo	= $request->getAttribute('dbo');
		if( strlen($this->member_number) == 0 || strlen($this->member_id) == 0 ) {
			$this->point	= 0;
		} else if( $this->member_class == 0 ) {
			$this->point	= 0;
		} else {
			$sql	= 'SELECT point FROM '.TABLE_NAME_MEMBER
				.' WHERE member_id='.$dbo->quote(trim($this->member_id));
			$currentPoint	= $dbo->queryOne($sql);
			if( false === $currentPoint ) {
				$this->point	= 0;
				$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
			} else {
				$this->point	= $currentPoint;
			}
		}
		return $this->point;
	}
	/**
	 * 本メンバーオブジェクトのメンバーに対してポイント操作を実行します
	 * @param $request spider_HttpRequestクラスオブジェクトの参照
	 * @param $changePoint 変更ポイント
	 * @param $actionLabel 履歴ラベル
	 * @param $actionDetail 履歴詳細コメント
	 * @param $execUserObject 実行ユーザーオブジェクト system_login_AbstractUserの実装
	 * @return boolean 成功したらtrue
	 */
	function pointChange( & $request, $changePoint=0, $actionLabel=null, $actionDetail=null, $execUserObject=null ) {
		$pointStr	= $changePoint;
		if( strlen($this->member_number) == 0 || strlen($this->member_id) == 0 ) {
			$request->addLocaledError('system.error.common.invalidusage',SPIDER_LOG_LEVEL_FATAL,array(''));
			return false;
		} else if( preg_match('/^(|\\+|\\-)[0-9]{1,6}$/',$changePoint) == 0 ) {
			$request->addLocaledError('system.error.common.invalidusage',SPIDER_LOG_LEVEL_FATAL,array(''));
			return false;
		} else if( strpos($changePoint,'-') === 0 ) {
			$pointStr	= $changePoint;
		} else if( strpos($changePoint,'+') === 0 ) {
			$pointStr	= $changePoint;
		} else {
			$pointStr	= '+'.$changePoint;
		}
		$dbo	= $request->getAttribute('dbo');
		$sql	= 'UPDATE '.TABLE_NAME_MEMBER.' SET point=point'.$pointStr
			.' WHERE member_id='.$dbo->quote($this->member_id);
		$rst	= $dbo->query($sql);
		if( $rst !== false ) {
			$execUserId		= $this->member_id;
			if( !is_null($execUserObject) && method_exists($execUserObject,'getUniqueId') ) {
				$execUserId	= $execUserObject->getUniqueId();
			}
			$pointHistory	= spider_Controller::createObject('member_DaoMemberPointHistory');
			$pointHistory->member_id		= $this->member_id;
			$pointHistory->action_point		= $pointStr;
			$pointHistory->action_label		= $actionLabel;
			$pointHistory->action_detail	= $actionDetail;
			$pointHistory->modifier_id		= $execUserId;
			$pointHistory->owner_id			= $execUserId;
			if( $dbo->insert($pointHistory) ){
				// 変更に成功したらメンバのポイントも変更
				$this->point	= $this->point + $changePoint;
				return true;
			} else {
				return false;
			}
		} else {
			$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_FATAL,array($sql));
			return false;
		}
	}
	/**
	 * フィールドに設定された値の妥当性検査を行います
	 */
	function validate( & $request, $requrireMailAddress = true ) {
		if( $this->validateFields( $request, $requrireMailAddress ) ) {
			return true;
		} else {
			return false;
		}
	}
	/**
	 * 入力値を自動調整
	 */
	function optimize() {
		// 携帯電話番号の調整
		$this->mobile_number		= mb_convert_kana($this->mobile_number,'a');
		$this->mobile_number_area	= mb_convert_kana($this->mobile_number_area,'a');
		$this->mobile_number_city	= mb_convert_kana($this->mobile_number_city,'a');
		$this->mobile_number_local	= mb_convert_kana($this->mobile_number_local,'a');
		if( strlen($this->mobile_number_area) > 0 || strlen($this->mobile_number_city) > 0
			|| strlen($this->mobile_number_local) > 0 ) {
			$this->mobile_number	= $this->mobile_number_area
				.'-'.$this->mobile_number_city.'-'.$this->mobile_number_local;
		} else {
			$elmArray	= explode('-',$this->mobile_number);
			$this->mobile_number_area	= isset($elmArray[0]) ? $elmArray[0] : '';
			$this->mobile_number_city	= isset($elmArray[1]) ? $elmArray[1] : '';
			$this->mobile_number_local	= isset($elmArray[2]) ? $elmArray[2] : '';
		}

		// 郵便番号の調整
		$this->zip_code		= mb_convert_kana($this->zip_code,'a');
		$this->zip_code_pre	= mb_convert_kana($this->zip_code_pre,'a');
		$this->zip_code_pst	= mb_convert_kana($this->zip_code_pst,'a');
		if( strlen($this->zip_code_pre) > 0 || strlen($this->zip_code_pst) > 0 ) {
			$this->zip_code	= $this->zip_code_pre.'-'.$this->zip_code_pst;
		} else {
			$elmArray	= explode('-',$this->zip_code);
			$this->zip_code_pre	= isset($elmArray[0]) ? $elmArray[0] : '';
			$this->zip_code_pst	= isset($elmArray[1]) ? $elmArray[1] : '';
		}
		// 電話番号の調整
		$this->telephone_number			= mb_convert_kana($this->telephone_number,'a');
		$this->telephone_number_area	= mb_convert_kana($this->telephone_number_area,'a');
		$this->telephone_number_city	= mb_convert_kana($this->telephone_number_city,'a');
		$this->telephone_number_local	= mb_convert_kana($this->telephone_number_local,'a');
		if( strlen($this->telephone_number_area) > 0 || strlen($this->telephone_number_city) > 0
			|| strlen($this->telephone_number_local) > 0 ) {
			$this->telephone_number	= $this->telephone_number_area
				.'-'.$this->telephone_number_city.'-'.$this->telephone_number_local;
		} else {
			$elmArray	= explode('-',$this->telephone_number);
			$this->telephone_number_area	= isset($elmArray[0]) ? $elmArray[0] : '';
			$this->telephone_number_city	= isset($elmArray[1]) ? $elmArray[1] : '';
			$this->telephone_number_local	= isset($elmArray[2]) ? $elmArray[2] : '';
		}
		// FAX番号の調整
		$this->faximili_number			= mb_convert_kana($this->faximili_number,'a');
		$this->faximili_number_area		= mb_convert_kana($this->faximili_number_area,'a');
		$this->faximili_number_city		= mb_convert_kana($this->faximili_number_city,'a');
		$this->faximili_number_local	= mb_convert_kana($this->faximili_number_local,'a');
		if( strlen($this->faximili_number_area) > 0 || strlen($this->faximili_number_city) > 0
			|| strlen($this->faximili_number_local) > 0 ) {
			$this->faximili_number	= $this->faximili_number_area
				.'-'.$this->faximili_number_city.'-'.$this->faximili_number_local;
		} else {
			$elmArray	= explode('-',$this->faximili_number);
			$this->faximili_number_area		= isset($elmArray[0]) ? $elmArray[0] : '';
			$this->faximili_number_city		= isset($elmArray[1]) ? $elmArray[1] : '';
			$this->faximili_number_local	= isset($elmArray[2]) ? $elmArray[2] : '';
		}

		// 郵便番号2の調整
		$this->zip_code2		= mb_convert_kana($this->zip_code2,'a');
		$this->zip_code2_pre	= mb_convert_kana($this->zip_code2_pre,'a');
		$this->zip_code2_pst	= mb_convert_kana($this->zip_code2_pst,'a');
		if( strlen($this->zip_code2_pre) > 0 || strlen($this->zip_code2_pst) > 0 ) {
			$this->zip_code2	= $this->zip_code2_pre.'-'.$this->zip_code2_pst;
		} else {
			$elmArray	= explode('-',$this->zip_code2);
			$this->zip_code2_pre	= isset($elmArray[0]) ? $elmArray[0] : '';
			$this->zip_code2_pst	= isset($elmArray[1]) ? $elmArray[1] : '';
		}
		// 電話番号2の調整
		$this->telephone_number2		= mb_convert_kana($this->telephone_number2,'a');
		$this->telephone_number2_area	= mb_convert_kana($this->telephone_number2_area,'a');
		$this->telephone_number2_city	= mb_convert_kana($this->telephone_number2_city,'a');
		$this->telephone_number2_local	= mb_convert_kana($this->telephone_number2_local,'a');
		if( strlen($this->telephone_number2_area) > 0 || strlen($this->telephone_number2_city) > 0
			|| strlen($this->telephone_number2_local) > 0 ) {
			$this->telephone_number2	= $this->telephone_number2_area
				.'-'.$this->telephone_number2_city.'-'.$this->telephone_number2_local;
		} else {
			$elmArray	= explode('-',$this->telephone_number2);
			$this->telephone_number2_area	= isset($elmArray[0]) ? $elmArray[0] : '';
			$this->telephone_number2_city	= isset($elmArray[1]) ? $elmArray[1] : '';
			$this->telephone_number2_local	= isset($elmArray[2]) ? $elmArray[2] : '';
		}
		// FAX番号2の調整
		$this->faximili_number2			= mb_convert_kana($this->faximili_number2,'a');
		$this->faximili_number2_area	= mb_convert_kana($this->faximili_number2_area,'a');
		$this->faximili_number2_city	= mb_convert_kana($this->faximili_number2_city,'a');
		$this->faximili_number2_local	= mb_convert_kana($this->faximili_number2_local,'a');
		if( strlen($this->faximili_number2_area) > 0 || strlen($this->faximili_number2_city) > 0
			|| strlen($this->faximili_number2_local) > 0 ) {
			$this->faximili_number2	= $this->faximili_number2_area
				.'-'.$this->faximili_number2_city.'-'.$this->faximili_number2_local;
		} else {
			$elmArray	= explode('-',$this->faximili_number2);
			$this->faximili_number2_area	= isset($elmArray[0]) ? $elmArray[0] : '';
			$this->faximili_number2_city	= isset($elmArray[1]) ? $elmArray[1] : '';
			$this->faximili_number2_local	= isset($elmArray[2]) ? $elmArray[2] : '';
		}
		// メールアドレスの整理
		$pcIsMobile		= false;
		$mobileIsValid	= false;
		foreach( $GLOBALS['MEMBER_MOBILE_MAIL_DOMAIN_ARRAY'] as $domain ) {
			$regDomain	= util_CharUtility::escape_regx_str('@'.$domain);
			if( preg_match('/'.$regDomain.'$/',$this->pc_mail) > 0 ) {
				$pcIsMobile		= true;
			}
			if( preg_match('/'.$regDomain.'$/',$this->mb_mail) > 0 ) {
				$mobileIsValid	= true;
			}
		}
		if( $pcIsMobile && ( $mobileIsValid === false || strlen(trim($this->mb_mail)) == 0 ) ) {
			$this->mb_mail	= $this->pc_mail;
			$this->pc_mail	= '';
		}
		// メールアドレスに変更があった場合にログインIDの整合性を整える
		if( strlen(trim($this->member_number)) > 0 ) {
			// 更新の場合
			if( $this->login_id == $this->login_id_org ) {
				// ログインIDに変更がない場合
				if( $this->login_id == $this->pc_mail_org ) {
					// 元がPCアドレスの場合
					if( $this->pc_mail_org != $this->pc_mail ) {
						// PCメールが変更されていたらログインIDも併せて変更
						if( strlen(trim($this->pc_mail)) > 0 ) {
							$this->login_id	= $this->pc_mail;
						} else if( strlen(trim($this->mb_mail)) > 0 ){
							$this->login_id	= $this->mb_mail;
						}
					}
				} else if( $this->login_id == $this->mb_mail_org ) {
					// 元が携帯メールの場合
					if( $this->mb_mail_org != $this->mb_mail ) {
						// 携帯メールが変更されていたらログインIDも併せて変更
						if( strlen(trim($this->mb_mail)) > 0 ) {
							$this->login_id	= $this->mb_mail;
						} else if( strlen(trim($this->pc_mail)) > 0 ){
							$this->login_id	= $this->pc_mail;
						}
					}
				} else {
					// 元のログインIDがメールアドレスでない場合は何もしない
				}
			} else {
				// ログインIDが入力で変更されている場合何もしない
			}
		} else {
			// 新規の場合ログインIDが設定されていないなら入力されている方のメールアドレスに設定
			if( strlen(trim($this->login_id)) == 0 ) {
				if( strlen(trim($this->mb_mail)) > 0 ) {
					$this->login_id	= trim($this->mb_mail);
				} else {
					$this->login_id	= trim($this->pc_mail);
				}
			}
		}
	}
	/**
	 * フィールドデータの妥当性検査を実行します
	 */
	function validateFields( & $request, $requrireMailAddress = true ) {
		// エラーを一度クリア
		$this->clearColumnErrors();
		// データベース接続を取得
		$dbo		= $request->getAttribute( 'dbo' );
		// 会員IDのデータの更新か否かのチェック
		$isUpdate	= false;
		$confirmMemberObject	= spider_Controller::createObject('member_DaoMember');
		if( $dbo->loadById($confirmMemberObject,array('member_id'=>$this->member_id)) ) {
			$isUpdate	= false;
		}
		$this->optimize();
		
		// 会員ID
		if( strlen(trim($this->member_id)) > 0 ) {
			// 全てのユーザー定義クラスの取得
			spider_Controller::loadClassDefinition('system_login_Exists');
			$userClassNameArray = system_login_Exists::getUserClassName( $request );
			// 全ての定義クラスで優先順に指定ログインIDの情報を読み込めるか確認
			$keyId		= $this->member_id;
			$uniqueId	= $this->member_id_org;
			$command	= 'unique';
			$isExists		= false;
			$isRegistable	= true;
			system_login_Exists::existsLoginUser( $request, $userClassNameArray, $keyId, $uniqueId, $command, $isExists, $isRegistable );
			if( $isExists === true && $isRegistable === false ) {
				$this->addColumnError($request,'member_id','member.error.dao.member.duplicatedid');
			}
		}
		// 会員種別
		if( strlen(trim($this->member_class)) == 0 ) {
			$this->member_class	= 0;
		} else if( $this->member_class == $this->member_class_org ) {
			// 変更がない場合はチェックしない
		} else if( !array_key_exists($this->member_class,$GLOBALS['MEMBER_MEMBER_CLASS_HASH']) ) {
			foreach( $GLOBALS['MEMBER_MEMBER_CLASS_HASH'] as $key => $name ) {
				if( $name == $this->member_class ) {
					$this->member_class	= $key;
					break;
				}
			}
			if( !array_key_exists($this->member_class,$GLOBALS['MEMBER_MEMBER_CLASS_HASH']) ) {
				$this->addColumnError($request,'member_class','member.error.dao.member.invalidclass');
			}
		}
		// ニックネーム
		if( strlen(trim($this->view_name)) == 0 ) {
			$this->addColumnError($request,'view_name','member.error.dao.member.requireviewname');
		} else if( strlen(trim($this->view_name)) > 255 ) {
			$this->addColumnError($request,'view_name','member.error.dao.member.invalidviewname');
		}
		// ログインIDの検査
		$isLoginIdEqPcMail	= false;
		$isLoginIdEqMbMail	= false;
		if( $this->login_id == $this->pc_mail ) { 
			$isLoginIdEqPcMail	= true;
		} else if( $this->login_id == $this->mb_mail ) {
			$isLoginIdEqMbMail	= true;
		}
		if( strlen(trim($this->login_id)) == 0 ) {
			if( $isLoginIdEqPcMail || $isLoginIdEqMbMail ) {
				$this->addColumnError($request,'email','member.error.dao.member.requireemail');
			} else {
				$this->addColumnError($request,'login_id','member.error.dao.member.requireloginid');
			}
		} else if( strlen(trim($this->login_id)) > 80 ) {
			if( $isLoginIdEqPcMail || $isLoginIdEqMbMail ) {
				$this->addColumnError($request,'email','member.error.dao.member.invalidviewname');
			} else {
				$this->addColumnError($request,'login_id','member.error.dao.member.invalidloginid');
			}
		} else {
			// 同一ログインIDで状態が登録完了になっていないまたは削除済みのレコードのlogin_idを重複回避にmember_idに変更
			$sql	= 'UPDATE '.TABLE_NAME_MEMBER.' SET login_id=member_id'
				.' WHERE login_id='.$dbo->quote($this->login_id).' AND ( ( status_flag<100 OR status_flag>=200 ) OR member_class=0 )'
			;
			$dbo->query($sql);
			if( $this->member_class > 0 ) {
				// 有効な会員でこのログインIDが使われていないかチェック
				$sql	= 'SELECT COUNT(*) FROM '.TABLE_NAME_MEMBER
					.' WHERE login_id='.$dbo->quote($this->login_id).' AND (status_flag>=100 AND status_flag<200 ) AND member_class>0'
				;
				if( strlen($this->member_id) > 0 ) {
					$sql	.= ' AND member_id<>'.$dbo->quote($this->member_id);
				}
				$existCount	= $dbo->queryOne($sql);
				if( $existCount === false ) {
					if( $isLoginIdEqPcMail || $isLoginIdEqMbMail ) {
						$this->addColumnError($request,'email','member.error.dao.member.queryduplicate');
					} else {
						$this->addColumnError($request,'login_id','member.error.dao.member.queryduplicatel');
					}
				} else if( $existCount > 0 ) {
					// 既に会員として存在する場合の処理
					if( $isLoginIdEqPcMail || $isLoginIdEqMbMail ) {
						$this->addColumnError($request,'email','member.error.dao.member.alreadyregisted');
					} else {
						$this->addColumnError($request,'login_id','member.error.dao.member.duplicatedloginid');
					}
				}
			}
		}
		if( strlen(trim($this->login_password)) == 0 ) {
			$this->addColumnError($request,'login_password','member.error.dao.member.requirepasswd');
		} else if( strlen(trim($this->login_password)) > 255 ) {
			$this->addColumnError($request,'login_password','member.error.dao.member.invalidpasswd');
		}
		// メールアドレスの確認
		if( $requrireMailAddress && strlen(trim($this->pc_mail)) == 0 && strlen(trim($this->mb_mail)) == 0 ) {
			$this->addColumnError($request,'email','member.error.dao.member.requiremail');
		} else {
			if( strlen(trim($this->pc_mail)) == 0 ) {
			} else if( strlen(trim($this->pc_mail)) > 80 ) {
				$this->addColumnError($request,'email','member.error.dao.member.invalidmail');
			} else {
				$isMobile	= false;
				foreach( $GLOBALS['MEMBER_MOBILE_MAIL_DOMAIN_ARRAY'] as $domain ) {
					$regDomain	= util_CharUtility::escape_regx_str('@'.$domain);
					if( preg_match('/'.$regDomain.'$/',$this->pc_mail) > 0 ) {
						$isMobile	= true;
					}
				}
				if( $isMobile ) {
					$this->addColumnError($request,'email','member.error.dao.member.moboleinputfail');
				}
				if( !$isLoginIdEqPcMail && $this->member_class > 0 ) {
					// メールアドレスの重複チェック
					$sql	= 'SELECT COUNT(*) FROM '.$this->getTableName()
						. ' WHERE pc_mail='.$dbo->quote($this->pc_mail)
						. ' AND status_flag<200 '
						. ' AND member_class>0';
					if( strlen($this->member_id) > 0 ) {
						$sql	.= ' AND member_id<>'.$dbo->quote($this->member_id);
					}
					$uCount	= $dbo->queryOne($sql);
					if( false === $uCount ) {
						$this->addColumnError($request,'email','member.error.dao.member.queryduplicate');
					} else if( $uCount > 0 ) {
						$this->addColumnError($request,'email','member.error.dao.member.duplicatedemail');
					}
				}
			}
			if( strlen(trim($this->mb_mail)) == 0 ) {
			} else if( strlen(trim($this->mb_mail)) > 80 ) {
				$this->addColumnError($request,'email','member.error.dao.member.invalidmbmail');
			} else {
				$isMobile	= false;
				foreach( $GLOBALS['MEMBER_MOBILE_MAIL_DOMAIN_ARRAY'] as $domain ) {
					$regDomain	= util_CharUtility::escape_regx_str('@'.$domain);
					if( preg_match('/'.$regDomain.'$/',$this->mb_mail) > 0 ) {
						$isMobile	= true;
					}
				}
				if( !$isMobile ) {
					$this->addColumnError($request,'email','member.error.dao.member.unknownmbmail');
				}
				if( !$isLoginIdEqMbMail && $this->member_class > 0 ) {
					// 携帯メールアドレスの重複チェック
					$sql	= 'SELECT COUNT(*) FROM '.$this->getTableName()
						.' WHERE mb_mail='.$dbo->quote($this->mb_mail)
						. ' AND status_flag>=100 '
						. ' AND status_flag<200 '
						. ' AND member_class>0'
					;
					if( strlen($this->member_id) > 0 ) {
						$sql	.= ' AND member_id<>'.$dbo->quote($this->member_id);
					}
					$uCount	= $dbo->queryOne($sql);
					if( false === $uCount ) {
						$this->addColumnError($request,'email','member.error.dao.member.queryduplicate');
					} else if( $uCount > 0 ) {
						$this->addColumnError($request,'email','member.error.dao.member.alreadyregisted');
					}
				}
			}
		}
		
		// 追加項目の入力チェック
		if( !is_array($GLOBALS['MEMBER_REQUIRE_ITEM']) ) {
			$GLOBALS['MEMBER_REQUIRE_ITEM']	= array();
		}
		// 名前
		if( strlen(trim($this->family_name)) == 0 && in_array('name',$GLOBALS['MEMBER_REQUIRE_ITEM']) ) {
			$this->addColumnError($request,'family_name','member.error.dao.member.requirefamilyname');
		} else if( strlen(trim($this->family_name)) > 30 ) {
			$this->addColumnError($request,'family_name','member.error.dao.member.invalidfamilyname');
		}
		if( strlen(trim($this->first_name)) == 0 && in_array('name',$GLOBALS['MEMBER_REQUIRE_ITEM']) ) {
			$this->addColumnError($request,'first_name','member.error.dao.member.requirefirstname');
		} else if( strlen(trim($this->first_name)) > 30 ) {
			$this->addColumnError($request,'first_name','member.error.dao.member.invalidfirstname');
		}
		// 名前フリガナ
		if( strlen(trim($this->family_kana)) == 0 && in_array('name_kana',$GLOBALS['MEMBER_REQUIRE_ITEM']) ) {
			$this->addColumnError($request,'family_kana','member.error.dao.member.requirefamilykana');
		} else if( strlen(trim($this->family_kana)) > 48 ) {
			$this->addColumnError($request,'family_kana','member.error.dao.member.invalidfamilykana');
		}
		if( strlen(trim($this->first_kana)) == 0 && in_array('name_kana',$GLOBALS['MEMBER_REQUIRE_ITEM']) ) {
			$this->addColumnError($request,'first_kana','member.error.dao.member.requirefirstkana');
		} else if( strlen(trim($this->first_kana)) > 48 ) {
			$this->addColumnError($request,'first_kana','member.error.dao.member.invalidfirstkana');
		}
		// 国名
		if( strlen(trim($this->country_name)) == 0 && in_array('country_name',$GLOBALS['MEMBER_REQUIRE_ITEM']) ) {
			$this->addColumnError($request,'country_name','member.error.dao.member.requirecountoryname');
		} else if( strlen($this->country_name) > 255 ) {
			$this->addColumnError($request,'country_name','member.error.dao.member.invalidcountoryname');
		}
		// 郵便番号
		if( strlen(trim($this->zip_code)) == 0 && in_array('zip_code',$GLOBALS['MEMBER_REQUIRE_ITEM']) ) {
			$this->addColumnError($request,'zip_code','member.error.dao.member.requirezipcode');
		} else if( strlen(trim($this->zip_code))>0 && preg_match('/^[0-9]{3}\\-[0-9]{4}$/',$this->zip_code) == 0 ) {
			$this->addColumnError($request,'zip_code','member.error.dao.member.invalidzipcode');
		} else if( strlen($this->zip_code) > 8 ) {
			$this->addColumnError($request,'zip_code','member.error.dao.member.invalidzipcode');
		}
		// 都道府県
		if( strlen(trim($this->prefecture_number)) == 0 && in_array('prefecture',$GLOBALS['MEMBER_REQUIRE_ITEM']) ) {
			$this->addColumnError($request,'prefecture_number','member.error.dao.member.requirepref');
		} else if( strlen(trim($this->prefecture_number))>0 && preg_match('/^[0-9]{1,2}$/',$this->prefecture_number) == 0 ) {
			$isExist = false;
			foreach ( $GLOBALS['PREFECTURE_HASH'] as $pnum=>$pval ) {
				if ( $pval==$this->prefecture_number ) {
					$this->prefecture_number = $pnum;
					$isExist = true;
					break;
				}
			}
			if ( !$isExist ) {
				$this->addColumnError($request,'prefecture_number','member.error.dao.member.invalidpref');
			}
		}
		// 住所・番地
		if( strlen(trim($this->address)) == 0 && in_array('address',$GLOBALS['MEMBER_REQUIRE_ITEM']) ) {
			$this->addColumnError($request,'address','member.error.dao.member.requireaddress');
		} else if( strlen(trim($this->address)) > 240 ) {
			$this->addColumnError($request,'address','member.error.dao.member.invalidaddress');
		}
		// 建物・部屋番号
		if( strlen(trim($this->building)) > 240 ) {
			$this->addColumnError($request,'building','member.error.dao.member.invalidbuilding');
		}
		// 電話番号
		if( strlen(trim($this->telephone_number)) == 0 && in_array('telephone',$GLOBALS['MEMBER_REQUIRE_ITEM']) ) {
			$this->addColumnError($request,'telephone_number','member.error.dao.member.requiretelephone');
		} else if( strlen($this->telephone_number) > 0 && preg_match('/^[0-9]{1,5}\\-[0-9]{1,5}\\-[0-9]{1,5}$/',$this->telephone_number) == 0 ) {
			$this->addColumnError($request,'telephone_number','member.error.dao.member.invalidtelephone');
		} else if( strlen($this->telephone_number) > 16 ) {
			$this->addColumnError($request,'telephone_number','member.error.dao.member.invalidtelephone');
		}
		// Fax番号
		if( strlen(trim($this->faximili_number)) == 0 && in_array('faximili',$GLOBALS['MEMBER_REQUIRE_ITEM']) ) {
			$this->addColumnError($request,'faximili_number','member.error.dao.member.requirefaximili');
		} else if( strlen($this->faximili_number) > 0 && preg_match('/^[0-9]{1,5}\\-[0-9]{1,5}\\-[0-9]{1,5}$/',$this->faximili_number) == 0 ) {
			$this->addColumnError($request,'faximili_number','member.error.dao.member.invalidfaximili');
		} else if( strlen($this->faximili_number) > 16 ) {
			$this->addColumnError($request,'faximili_number','member.error.dao.member.invalidfaximili');
		}
		// 携帯電話番号
		if( strlen(trim($this->mobile_number)) == 0 && in_array('mobile',$GLOBALS['MEMBER_REQUIRE_ITEM']) ) {
			$this->addColumnError($request,'mobile_number','member.error.dao.member.requiremobile');
		} else if( strlen($this->mobile_number) > 0 && preg_match('/^[0-9]{1,5}\\-[0-9]{1,5}\\-[0-9]{1,5}$/',$this->mobile_number) == 0 ) {
			$this->addColumnError($request,'mobile_number','member.error.dao.member.invalidmobile');
		} else if( strlen($this->mobile_number) > 16 ) {
			$this->addColumnError($request,'mobile_number','member.error.dao.member.invalidmobile');
		}

		// 郵便番号2
		if( strlen(trim($this->zip_code2)) == 0 && in_array('zip_code2',$GLOBALS['MEMBER_REQUIRE_ITEM']) ) {
			$this->addColumnError($request,'zip_code2','member.error.dao.member.requirea2zipcode');
		} else if( strlen(trim($this->zip_code2))>0 && preg_match('/^[0-9]{3}\\-[0-9]{4}$/',$this->zip_code2) == 0 ) {
			$this->addColumnError($request,'zip_code2','member.error.dao.member.invalida2zipcode');
		} else if( strlen($this->zip_code) > 8 ) {
			$this->addColumnError($request,'zip_code2','member.error.dao.member.invalida2zipcode');
		}
		// 都道府県2
		if( strlen(trim($this->prefecture_number2)) == 0 && in_array('prefecture2',$GLOBALS['MEMBER_REQUIRE_ITEM']) ) {
			$this->addColumnError($request,'prefecture_number2','member.error.dao.member.requirea2pref');
		} else if( strlen(trim($this->prefecture_number2))>0 && preg_match('/^[0-9]{1,2}$/',$this->prefecture_number2) == 0 ) {
			$isExist = false;
			foreach ( $GLOBALS['PREFECTURE_HASH'] as $pnum=>$pval ) {
				if ( $pval==$this->prefecture_number2 ) {
					$this->prefecture_number2 = $pnum;
					$isExist = true;
					break;
				}
			}
			if ( !$isExist ) {
				$this->addColumnError($request,'prefecture_number2','member.error.dao.member.invalida2pref');
			}
		}
		// 住所・番地2
		if( strlen(trim($this->address2)) == 0 && in_array('address2',$GLOBALS['MEMBER_REQUIRE_ITEM']) ) {
			$this->addColumnError($request,'address2','member.error.dao.member.requirea2address');
		} else if( strlen(trim($this->address2)) > 240 ) {
			$this->addColumnError($request,'address2','member.error.dao.member.invalida2address');
		}
		// 建物・部屋番号2
		if( strlen(trim($this->building2)) > 240 ) {
			$this->addColumnError($request,'building2','member.error.dao.member.invalida2building');
		}
		// 電話番号2
		if( strlen(trim($this->telephone_number2)) == 0 && in_array('telephone2',$GLOBALS['MEMBER_REQUIRE_ITEM']) ) {
			$this->addColumnError($request,'telephone_number2','member.error.dao.member.requirea2telephone');
		} else if( strlen($this->telephone_number2) > 0 && preg_match('/^[0-9]{1,5}\\-[0-9]{1,5}\\-[0-9]{1,5}$/',$this->telephone_number2) == 0 ) {
			$this->addColumnError($request,'telephone_number2','member.error.dao.member.invalida2telephone');
		} else if( strlen($this->telephone_number2) > 16 ) {
			$this->addColumnError($request,'telephone_number2','member.error.dao.member.invalida2telephone');
		}
		// Fax番号2
		if( strlen(trim($this->faximili_number2)) == 0 && in_array('faximili2',$GLOBALS['MEMBER_REQUIRE_ITEM']) ) {
			$this->addColumnError($request,'faximili_number2','member.error.dao.member.requirea2faximili');
		} else if( strlen($this->faximili_number2) > 0 && preg_match('/^[0-9]{1,5}\\-[0-9]{1,5}\\-[0-9]{1,5}$/',$this->faximili_number2) == 0 ) {
			$this->addColumnError($request,'faximili_number2','member.error.dao.member.invalida2faximili');
		} else if( strlen($this->faximili_number2) > 16 ) {
			$this->addColumnError($request,'faximili_number2','member.error.dao.member.invalida2faximili');
		}
		
		// 会社名
		if( strlen(trim($this->company_name)) == 0 && in_array('company_name',$GLOBALS['MEMBER_REQUIRE_ITEM']) ) {
			$this->addColumnError($request,'company_name','member.error.dao.member.requirecompany');
		} else if( strlen($this->company_name) > 240 ) {
			$this->addColumnError($request,'company_name','member.error.dao.member.invalidcompany');
		}
		// 部署名
		if( strlen(trim($this->section_name)) == 0 && in_array('section_name',$GLOBALS['MEMBER_REQUIRE_ITEM']) ) {
			$this->addColumnError($request,'section_name','member.error.dao.member.requiresection');
		} else if( strlen($this->section_name) > 240 ) {
			$this->addColumnError($request,'section_name','member.error.dao.member.invalidsection');
		}
		
		// ホームページURL
		if( strlen(trim($this->url)) == 0 && in_array('url',$GLOBALS['MEMBER_REQUIRE_ITEM']) ) {
			$this->addColumnError($request,'url','member.error.dao.member.requireurl');
		} else if( strlen($this->url) > 240 ) {
			$this->addColumnError($request,'url','member.error.dao.member.invalidurl');
		}

		// 生年
		if( strlen(trim($this->birth_year)) == 0 && in_array('birth_year',$GLOBALS['MEMBER_REQUIRE_ITEM']) ) {
			$this->addColumnError($request,'birth_year','member.error.dao.member.requirebyear');
		} else if( strlen(trim($this->birth_year))>0 ) {
			if( preg_match('/^[0-9]{4}$/',$this->birth_year) == 0 ) {
				$this->addColumnError($request,'birth_year','member.error.dao.member.invalidbyear');
			} else if( $this->birth_year < 1900 || $this->birth_year > date('Y') ) {
				$this->addColumnError($request,'birth_year','member.error.dao.member.invalidbyear');
			}
		}
		// 生月
		if( strlen(trim($this->birth_month)) == 0 && in_array('birth_month',$GLOBALS['MEMBER_REQUIRE_ITEM']) ) {
			$this->addColumnError($request,'birth_month','member.error.dao.member.requirebmonth');
		} else if( strlen(trim($this->birth_month))>0 ) {
			if( preg_match('/^[0-9]{1,2}$/',$this->birth_month) == 0 ) {
				$this->addColumnError($request,'birth_month','member.error.dao.member.invalidbmonth');
			} else if( $this->birth_month < 1 || $this->birth_month > 12 ) {
				$this->addColumnError($request,'birth_month','member.error.dao.member.invalidbmonth');
			}
		}
		// 生日
		if( strlen(trim($this->birth_day)) == 0 && in_array('birth_day',$GLOBALS['MEMBER_REQUIRE_ITEM']) ) {
			$this->addColumnError($request,'birth_day','member.error.dao.member.requirebday');
		} else if(  strlen(trim($this->birth_day))>0 ) {
			if( preg_match('/^[0-9]{1,2}$/',$this->birth_day) == 0 ) {
				$this->addColumnError($request,'birth_day','member.error.dao.member.invalidbday');
			} else if( $this->birth_day < 1 || $this->birth_day > 31 ) {
				$this->addColumnError($request,'birth_day','member.error.dao.member.invalidbday');
			}
		}
		
		// 性別
		if( strlen(trim($this->sex)) == 0 && in_array('sex',$GLOBALS['MEMBER_REQUIRE_ITEM']) ) {
			$this->addColumnError($request,'sex','member.error.dao.member.requiresex');
		} else if( strlen(trim($this->sex))>0 && preg_match('/^[0-9]{1}$/',$this->sex) == 0 ) {
			foreach( $GLOBALS['MEMBER_MEMBER_SEX_HASH'] as $key => $name ) {
				if( $name == $this->sex ) {
					$this->sex	= $key;
					break;
				}
			}
			if( preg_match('/^[0-9]{1}$/',$this->sex) == 0 ) {
				$this->addColumnError($request,'sex','member.error.dao.member.invalidsex');
			}
		}
		if( strlen(trim($this->blood_type)) == 0 && in_array('blood_type',$GLOBALS['MEMBER_REQUIRE_ITEM']) ) {
			$this->addColumnError($request,'blood_type','member.error.dao.member.requireblood');
		} else if( strlen(trim($this->blood_type))>0 && preg_match('/^[0-9]{1}$/',$this->blood_type) == 0 ) {
			foreach( $GLOBALS['MEMBER_MEMBER_BLOOD_TYPE_HASH'] as $key => $name ) {
				if( $name == $this->blood_type ) {
					$this->blood_type	= $key;
					break;
				}
			}
			if( preg_match('/^[0-9]{1}$/',$this->blood_type) == 0 ) {
				$this->addColumnError($request,'blood_type','member.error.dao.member.invalidblood');
			}
		}
		if( strlen(trim($this->height)) == 0 && in_array('height',$GLOBALS['MEMBER_REQUIRE_ITEM']) ) {
			$this->addColumnError($request,'height','member.error.dao.member.requireheight');
		} else if( strlen(trim($this->height)) > 0 ) {
			if( preg_match('/^[0-9]+(|\\.[0-9]+)$/', $this->height ) == 0 ) {
				$this->addColumnError($request,'height','member.error.dao.member.invalidheight');
			} else if( $this->height >= 3000 ) {
				$this->addColumnError($request,'height','member.error.dao.member.invalidheight');
			} else if( $this->height == 0 ) {
				$this->height = null;
			}
		}
		if( strlen(trim($this->weight)) == 0 && in_array('weight',$GLOBALS['MEMBER_REQUIRE_ITEM']) ) {
			$this->addColumnError($request,'weight','member.error.dao.member.requireweight');
		} else if( strlen(trim($this->weight)) > 0 ) {
			if( preg_match('/^[0-9]+(|\\.[0-9]+)$/', $this->weight ) == 0 ) {
				$this->addColumnError($request,'weight','member.error.dao.member.invalidweight');
			} else if( $this->weight >= 10000 ) {
				$this->addColumnError($request,'weight','member.error.dao.member.invalidweight');
			} else if( $this->weight == 0 ) {
				$this->weight = null;
			}
		}
		if( ( strlen(trim($this->bust)) == 0 || strlen(trim($this->waist)) == 0 || strlen(trim($this->hip)) == 0 ) && in_array('bwh',$GLOBALS['MEMBER_REQUIRE_ITEM']) ) {
			$this->addColumnError($request,'bwh','member.error.dao.member.requiresize');
		} else {
			if( strlen(trim($this->bust))>0 && preg_match('/^[0-9]{1,3}$/',$this->bust) == 0 ) {
				$this->addColumnError($request,'bwh','member.error.dao.member.invalidbust');
			} else if( $this->bust >= 500 ) {
				$this->addColumnError($request,'bwh','member.error.dao.member.invalidwaist');
			}
			if( strlen(trim($this->waist))>0 && preg_match('/^[0-9]{1,3}$/',$this->waist) == 0 ) {
				$this->addColumnError($request,'bwh','member.error.dao.member.invalidhip');
			} else if( $this->waist >= 500 ) {
				$this->addColumnError($request,'bwh','member.error.dao.member.invalidhip');
			}
			if( strlen(trim($this->hip))>0 && preg_match('/^[0-9]{1,3}$/',$this->hip) == 0 ) {
				$this->addColumnError($request,'bwh','member.error.dao.member.invalidhip');
			} else if( $this->hip >= 500 ) {
				$this->addColumnError($request,'bwh','member.error.dao.member.invalidhip');
			}
		}
		if( strlen(trim($this->introduction)) == 0 && in_array('introduction',$GLOBALS['MEMBER_REQUIRE_ITEM']) ) {
			$this->addColumnError($request,'introduction','member.error.dao.member.requireintroduction');
		} else if( strlen($this->introduction) > 3000 ) {
			$this->addColumnError($request,'introduction','member.error.dao.member.invalidintroduction');
		}

		// 状態
		if( strlen(trim($this->status_flag)) == 0 ) {
			$this->status_flag	= 0;
		} else if( preg_match('/^[0-9]{1,3}$/',$this->status_flag) > 0 ) {
			if( !array_key_exists($this->status_flag,$GLOBALS['MEMBER_STATUS_HASH']) ) {
				$this->addColumnError($request,'status_flag','member.error.common.invalidstatus');
			}
		} else {
			if( in_array($this->status_flag,$GLOBALS['MEMBER_STATUS_HASH']) ) {
				foreach ( $GLOBALS['MEMBER_STATUS_HASH'] as $snum=>$sval ) {
					if ( $sval==$this->status_flag ) {
						$this->status_flag = $snum;
						break;
					}
				}
			} else {
				$this->addColumnError($request,'status_flag','member.error.common.invalidstatus');
			}
		}

		// 結果をリターン
		if( $this->hasColumnError() ) {
			return false;
		} else {
			return true;
		}
	}
	//
	// 汎用メソッド
	//
	/**
	 * カラム表示用フィールドの設定
	 */
	function setFieldViewValues( & $request ) {
		if( preg_match('/^[0-9]{1,2}$/',$this->prefecture_number) > 0
			&& isset($GLOBALS['PREFECTURE_HASH'][$this->prefecture_number]) ) {
			$this->prefecture_name	= $GLOBALS['PREFECTURE_HASH'][$this->prefecture_number];
		} else {
			$this->prefecture_name	= '';
		}
		if( preg_match('/^[0-9]{1,2}$/',$this->prefecture_number2) > 0
			&& isset($GLOBALS['PREFECTURE_HASH'][$this->prefecture_number2]) ) {
			$this->prefecture_name2	= $GLOBALS['PREFECTURE_HASH'][$this->prefecture_number2];
		} else {
			$this->prefecture_name2	= '';
		}
		// テンプレートで置換する文言を作成(性別と血液型)
		if( strlen($this->sex) > 0 ) {
			$this->sex_string	= $GLOBALS['MEMBER_MEMBER_SEX_HASH'][$this->sex];
		} else {
			$this->sex_string	= '';
		}
		if( strlen($this->blood_type) > 0 ) {
			$this->blood_type_string	= $GLOBALS['MEMBER_MEMBER_BLOOD_TYPE_HASH'][$this->blood_type];
		} else {
			$this->blood_type_string	= '';
		}
	}
	//
	// オーバーライドメソッド
	//
	/**
	 * CSVダウンロードの為のカラム取得メソッド
	 * 項目キーから値を取得します
	 */
	function getColumnString( $key, $quote=true, $filter=null ) {
		$returnValue	= $this->$key;
		if( 'prefecture_number' == $key || 'prefecture_number2' == $key ) {
			// 都道府県カラムは名前で返す
			return isset($GLOBALS['PREFECTURE_HASH'][$returnValue]) ? $GLOBALS['PREFECTURE_HASH'][$returnValue] : '';
		} else if( 'sex' == $key ) {
			// 性別カラム
			return isset($GLOBALS['MEMBER_MEMBER_SEX_HASH'][$returnValue]) ? $GLOBALS['MEMBER_MEMBER_SEX_HASH'][$returnValue] : '';
		} else if( 'blood_type' == $key ) {
			// 血液型カラム
			return isset($GLOBALS['MEMBER_MEMBER_BLOOD_TYPE_HASH'][$returnValue]) ? $GLOBALS['MEMBER_MEMBER_BLOOD_TYPE_HASH'][$returnValue] : '';
		} else if( 'member_class' == $key ) {
			// 種別カラム
			return isset($GLOBALS['MEMBER_MEMBER_CLASS_HASH'][$returnValue]) ? $GLOBALS['MEMBER_MEMBER_CLASS_HASH'][$returnValue] : '';
		} else if( 'status_flag' == $key ) {
			// 状態カラム
			return isset($GLOBALS['MEMBER_STATUS_HASH'][$returnValue]) ? $GLOBALS['MEMBER_STATUS_HASH'][$returnValue] : '';
		} else {
			return parent::getColumnString( $key, $quote, $filter );
		}
	}
	/**
	 * このユーザー宛てにメールを送信
	 * @param $request spider_HttpRequestオブジェクト参照
	 * @param $targetAddress 送信ターゲットメールアドレス指定
	 * @param $templateName メールテンプレート名
	 * @param $replaceHash 置き換えワード
	 * @param $bcc ブラインドカーボンコピーアドレス
	 * @return 成功したらtrue、失敗したらfalse
	 */
	function sendInformationMail( & $request, $targetAddress, $templateName, $replaceHash=array(), $bcc=null, $loginPassword='' ) {
		if( !is_array($replaceHash) ) {
			$replaceHash	= array();
		}
		$replaceHash['member']	= $this;
		parent::sendInformationMail( $request, $targetAddress, $templateName, $replaceHash, $bcc, $loginPassword );
	}
	/**
	 * 送信メールテンプレート情報を名称から取得
	 * @param $request spider_HttpRequestオブジェクト参照
	 * @param $templateName メールテンプレート名
	 * @return array array('subject'=>[], 'text_body'=>[], 'html_body'=>[], 'from'=>[], 'from_name'=>[], 'reply'=>[], 'return'=>[] )
	 */
	function getMailInformation( & $request, $templateName, $targetAddress ) {
		$infoHash	= array();
		// 定義済みの携帯宛か確認
		$isMobile	= false;
		if( isset($GLOBALS['MOBILE_MAIL_DOMAIN_ARRAY'])
		&& is_array($GLOBALS['MOBILE_MAIL_DOMAIN_ARRAY']) ) {
			foreach( $GLOBALS['MOBILE_MAIL_DOMAIN_ARRAY'] as $fqdn ) {
				$fqdn_regx	= str_replace('.','\\.',$fqdn );
				if( preg_match('/\\@'.$fqdn_regx.'$/',$targetAddress) > 0 ) {
					$isMobile	= true;
					break;
				}
			}
		}
		// パスワード再通知テンプレート名はIDに書き換え
		if( 'mail.password' == $templateName ) {
			// パスワード再通知メールの場合は
			$templateName	= 'MEMBERPASSWD';
		}
		// データベースからメールテンプレートを読み込み
		$mailTemplateObject	= spider_Controller::createObject('member_DaoMemberMailTemplate');
		$isConnected		= true;
		$dbo				= $request->getAttribute( 'dbo' );
		if( !is_object($dbo) ) {
			$isConnected	= false;
			require_once(DIR_PATH_LIB.DIRECTORY_SEPARATOR.'database2'.DIRECTORY_SEPARATOR.'Connect.class.php');
			database2_Connect::execute($request);
			$dbo	= $request->getAttribute( 'dbo' );
		}
		if( $dbo->loadById( $mailTemplateObject, $templateName ) ) {
			$infoHash['subject']	= $mailTemplateObject->subject;
			if( $isMobile && strlen(trim($mailTemplateObject->subject_mobile))>0 ) {
				$infoHash['subject']	= $mailTemplateObject->subject_mobile;
			}
			$infoHash['text_body']	= $mailTemplateObject->text_body_default;
			if( $isMobile && strlen(trim($mailTemplateObject->text_body_mobile))>0 ) {
				$infoHash['text_body']	= $mailTemplateObject->text_body_mobile;
			}
			$infoHash['html_body']	= $mailTemplateObject->html_body_default;
			if( $isMobile && strlen(trim($mailTemplateObject->html_body_mobile))>0 ) {
				$infoHash['html_body']	= $mailTemplateObject->html_body_mobile;
			}
			$infoHash['from_name']	= $mailTemplateObject->mail_from_name;
			$infoHash['from']		= $mailTemplateObject->mail_from_address;
			$infoHash['reply']		= $mailTemplateObject->mail_reply_address;
			$infoHash['return']		= $mailTemplateObject->mail_return_path;
			return $infoHash;
		} else {
			$request->addLocaledError('member.error.mail.template.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		if( !$isConnected ) {
			database2_Connect::post_process($request);
		}
		return false;
	}
	/**
	 * オブジェクト比較して要素の違いを抽出します
	 * @param spider_HttpRequest &$request spider_HttpRequestインスタンス参照
	 * @param object $compareObject 比較対象オブジェクト
	 * @return array 違いのキーと値ハッシュ
	 */
	function getDifference( & $request, $compareObject ) {
		$defferenceHash	= parent::getDifference( $request, $compareObject );
		$newDefferenceHash	= array();
		$GLOBALS['MEMBER_DEFFERENCE_MEMBER_HASH']	= array(
			'member_class'	=>'個人情報種別',
			'login_id'	=>'ログインID',
			'login_password'	=>'ログインパスワード',
			'view_name'	=>'表示名',
			'pc_mail'	=>'PCメールアドレス',
			'mb_mail'	=>'モバイルメールアドレス',
			'status_flag'	=>'状態',
			'first_name'	=>'名',
			'family_name'	=>'姓',
			'first_kana'	=>'名カナ',
			'family_kana'	=>'姓カナ',
			'zip_code'	=>'郵便番号',
			'prefecture_number'	=>'都道府県番号',
			'address'	=>'住所・番地',
			'building'	=>'建物・部屋番号',
			'telephone_number'	=>'電話番号',
			'faximili_number'	=>'FAX番号',
			'mobile_number'	=>'携帯番号',
			'zip_code2'	=>'郵便番号2',
			'prefecture_number2'	=>'都道府県番号2',
			'address2'	=>'住所・番地2',
			'building2'	=>'建物・部屋番号2',
			'telephone_number2'	=>'電話番号2',
			'faximili_number2'	=>'FAX番号2',
			'url'	=>'ホームページ',
			'birth_year'	=>'生年',
			'birth_month'	=>'生月',
			'birth_day'	=>'生日',
			'sex'	=>'性別',
			'blood_type'	=>'血液型',
			'height'	=>'身長',
			'weight'	=>'体重',
			'bust'	=>'バスト',
			'waist'	=>'ウエスト',
			'hip'	=>'ヒップ',
			'company_name'	=>'組織名',
			'section_name'	=>'部署名',
		);
		foreach( $defferenceHash as $key => $val ){
			if( array_key_exists($key,$GLOBALS['MEMBER_DEFFERENCE_MEMBER_HASH']) ){
				$newKey	= $GLOBALS['MEMBER_DEFFERENCE_MEMBER_HASH'][$key];
				$newDefferenceHash[$newKey]	= $val;
			}
		}
		return $newDefferenceHash;
	}
}
?>