<?php
/*
 * file/Download.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'system'
.DIRECTORY_SEPARATOR.'login'
.DIRECTORY_SEPARATOR.'ModuleBase.class.php');
require_once(dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'system'
.DIRECTORY_SEPARATOR.'DataFileWriter.class.php');
require_once( dirname(__FILE__)
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
require_once( dirname(__FILE__)
.DIRECTORY_SEPARATOR.'DaoFileBin.class.php');
/**
 * spider : ファイル登録 画像出力用アクションモジュールクラス
 * 
 * spiderから呼び出すモジュールクラスです。
 * データベースに登録済みの画像ファイルのファイルIDを指定し
 * HTTPレスポンスに画像を出力します。
 * 
 * @package file ファイル登録パッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class file_Download extends system_login_ModuleBase {
	
	function file_Download() {
	}
	function execute( & $request ) {
		spider_Controller::loadClassDefinition('system_DataFileWriter');
		$dbo			= $request->getAttribute( 'dbo' );
		$fileId			= stripslashes( $_GET['fi'] );
		$downloadType	= stripslashes( $_GET['dt'] );
		$target			= stripslashes( $_GET['t'] );
		$loginUserObject		= $this->getLoginUserObject( $request );
		// 画像の場合のみのパラメータ
		$maxWidth		= $_GET['w'];
		$maxHeight		= $_GET['h'];
		$fillColor		= $_GET['fill'];
		$quality		= $_GET['qlt'];
		
		if ( strlen( trim ( $fileId ) ) == 0 ) {
			$request->addError('ファイルが指定されていません。');
			return false;
		}
		// 幅と高さ指定の調整
		if( preg_match('/^[0-9]{1,4}$/',$maxWidth) > 0 ) {
			if( $maxWidth > 3000 ) {
				$maxWidth	= 3000;
			} else if( $maxWidth < 10 ) {
				$maxWidth	= 10;
			}
//			$maxWidth	= floor($maxWidth/10) * 10;
			$maxWidth	= floor($maxWidth);
		} else {
			$maxWidth	= null;
		}
		if( preg_match('/^[0-9]{1,4}$/',$maxHeight) ) {
			if( $maxHeight > 3000 ) {
				$maxHeight	= 3000;
			} else if( $maxHeight < 10 ) {
				$maxHeight	= 10;
			}
//			$maxHeight	= floor($maxHeight/10) * 10;
			$maxHeight	= floor($maxHeight);
		} else {
			$maxHeight	= null;
		}
		// 公開キャッシュがあるか確認
		$openUri	= FILE_PUBLIC_CACHE_FILE_URI;
		if( strlen($fileId) > 2 && strlen($fileId) % 2 == 0 ) {
			for( $i=0; $i<strlen($fileId); $i=$i+2 ) {
				$dirName	= substr($fileId,$i,2);
				$openUri	.= $dirName.'/';
			}
			$openUri	.= $maxWidth.'x'.$maxHeight.'.';
		} else {
			$openUri	.= $fileId.'x'.$maxWidth.'x'.$maxHeight.'.';
		}
		if( system_DataFileWriter::isExists($request, $openUri.'jpg', 'public') ) {
			$request->redirectTo($openUri.'jpg');
			return true;
		} else if( system_DataFileWriter::isExists($request, $openUri.'gif', 'public') ) {
			$request->redirectTo($openUri.'gif');
			return true;
		} else if( system_DataFileWriter::isExists($request, $openUri.'png', 'public') ) {
			$request->redirectTo($openUri.'png');
			return true;
		} else if( system_DataFileWriter::isExists($request, $openUri.'swf', 'public') ) {
			$request->redirectTo($openUri.'swf');
			return true;
		}
		
		// ファイルオブジェクトの読み込み
		$fileBinObject	= null;
		if( preg_match('/^[tT][mM][pP]$/',$target) > 0 ) {
			// 一時ファイルの取得の場合
			// アップロード一時フォルダのルートパス
			$globalTmpUri		= '/file/global/'.$fileId;
			$globalTmpRealPath	= system_DataFileWriter::getRealAbsolutePath( $request, $globalTmpUri, DIR_NAME_TMP );
			$globalTmpInfoPath	= $globalTmpRealPath.'.info';
			// 指定されたIDと同じテンポラリ情報があるか確認
			if( file_exists($globalTmpRealPath) && file_exists($globalTmpInfoPath) ) {
				// 一時ファイルがあるなら出力処理
				$str			= file_get_contents($globalTmpInfoPath);
				$fileBinObject	= unserialize($str);
				if( 'file_daofilebin' != strtolower(get_class($fileBinObject)) ){
					$request->addError('指定されたファイルは存在しません。');
					$fileBinObject	= null;
				}
			} else {
				$request->addError('指定されたファイルは存在しません。');
				$fileBinObject	= null;
			}
		} else {
			$fileBinObject	= new file_DaoFileBin();
			if( $dbo->loadById( $fileBinObject, $fileId ) ) {
				// 公開チェック
				if( strlen($fileBinObject->open_flag) > 0 && $fileBinObject->open_flag != '0') {
					if( $this->isLogin( $request )
						&& SYSTEM_LOGIN_USER_ADMINISTRATORS == $loginUserObject->getLoginGroupLevel()
						|| $fileBinObject->owner_id == $loginUserObject->getUniqueId() ) {
					} else {
						$request->addError('ダウンロード権限がありません。');
						$fileBinObject	= null;
					}
				}
			} else {
				$request->addError('指定されたファイルは存在しません。');
				$fileBinObject	= null;
			}
		}
		// ダウンロードファイル決定
		$downloadFilePath	= null;
		if( !$request->isError() ) {
			if( $fileBinObject->isImage() && ( !is_null($maxWidth) || !is_null($maxHeight) ) ) {
				// 画像の場合で最大サイズの縦横どちらかが指定されているならリサイズ出力
				$downloadFilePath = $fileBinObject->getOutputFilePath( $request, $maxWidth, $maxHeight, $fillColor, $quality );
			} else {
				// 画像でないもしくは縦横が指定されていないならオリジナルファイル
				$downloadFilePath = $fileBinObject->getOutputFilePath( $request );
			}
		}
		// 出力実行
		if( !$request->isError() && strlen($downloadFilePath) > 0 && file_exists($downloadFilePath) ) {
			if( 'download' == $downloadType ) {
				$request->setResponseHeader( 'Content-Disposition', 'attachment; filename="'.$fileBinObject->file_name.'"' );
			} else {
				$request->setResponseHeader( 'Content-Disposition', 'inline; filename="'.$fileBinObject->file_name.'"' );
			}
			$request->setResponseHeader( 'Content-Type', $fileBinObject->mime_type );
			if( strlen(trim($fileBinObject->response_headers)) > 0 ) {
				$headerArray	= explode("\n",trim($fileBinObject->response_headers));
				foreach( $headerArray as $headerStr ) {
					$headerStr	= trim($headerStr);
					if( strlen($headerStr) > 0 && strpos($headerStr,':') !== false ) {
						$elmArray	= explode(':',$headerStr);
						if( count($elmArray) > 1 ) {
							$request->setResponseHeader(array_shift($elmArray), implode(':',$elmArray));
						}
					}
				}
			}
			if( ( preg_match('/^[iI][mM][aA][gG][eE]/',$fileBinObject->mime_type) > 0
			|| 'application/x-shockwave-flash' == strtolower($fileBinObject->mime_type) )
			&& $fileBinObject->open_flag == '0' || strlen($fileBinObject->open_flag) == 0 ) {
				// 画像で公開なら公開キャッシュを作成
				$openUri	.= strtolower($fileBinObject->extension);
				if( !system_DataFileWriter::isExists($request, $openUri, 'public') ) {
					system_DataFileWriter::import( $request, $openUri, $downloadFilePath, 'public' );
				}
				$request->redirectTo($openUri);
			} else {
				$request->setResponseFile( $downloadFilePath );
			}
		} else {
			$request->addError('ファイルが存在しないか変換に失敗しました。'.$downloadFilePath);
		}
	}
}
?>