<?php
/*
 * design/template/LoadRelatedFiles.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(dirname(__FILE__)))
	.DIRECTORY_SEPARATOR.'system'
	.DIRECTORY_SEPARATOR.'login'
	.DIRECTORY_SEPARATOR.'ModuleBase.class.php');
require_once( dirname(dirname(dirname(__FILE__)))
	.DIRECTORY_SEPARATOR.'system'
	.DIRECTORY_SEPARATOR.'DataFileWriter.class.php');
require_once( dirname(dirname(__FILE__))
	.DIRECTORY_SEPARATOR.'DaoTemplate.class.php');
class design_template_LoadRelatedFiles extends system_login_ModuleBase {
	
	function design_template_LoadRelatedFiles() {
	}
	function execute( & $request ) {

		$loginUserObject	= $this->getLoginUserObject( $request );
		$fileName			= strtolower(trim(stripslashes($_GET['fmt'])));
		if( strlen(trim($fileName)) == 0 ) {
			$request->addError('テンプレートファイル名を指定してください');
		}
		
		if( !$request->isError() ) {
			$fileUriArray		= array();
			$templateObject		= new design_DaoTemplate($fileName);
			$fileUriArray		= $templateObject->getRelatedFileUriArray( $request );
			if( false !== $fileUriArray ) {
				$fileInfoHash	= array();
				$nonExistsArray	= array();
				foreach( $fileUriArray as $key => $uri ) {
					$fileName			= basename($uri);
					$fileInformation	= array('uri'=>$uri);
					$absolutePath	= system_DataFileWriter::getRealAbsolutePath( $request, $uri, 'public' );
					if( file_exists($absolutePath) ) {
						if( preg_match('/\\.[cC][sS][sS]/',$fileName) > 0
							|| preg_match('/\\.[jJ][sS]/',$fileName) > 0
							) {
							$fileInformation['type']		= 'text';
							$fileInformation['size']		= filesize($absolutePath);
							$fileInfoHash[$fileName]		= $fileInformation;
						} else if( preg_match('/\\.[pP][dD][fF]$/',$fileName) > 0 ) {
							$fileInformation['type']		= 'pdf';
							$fileInformation['size']		= filesize($absolutePath);
							$fileInfoHash[$fileName]	= $fileInformation;
						} else if( preg_match('/\\.[sS][wW][fF]$/',$fileName) > 0 ) {
							$fileInformation['type']		= 'swf';
							$fileInformation['size']		= filesize($absolutePath);
							$fileInfoHash[$fileName]	= $fileInformation;
						} else if( preg_match('/\\.[jJ][pP][gG]$/',$fileName) > 0
							|| preg_match('/\\.[pP][nN][gG]$/',$fileName) > 0
							|| preg_match('/\\.[gG][iI][fF]$/',$fileName) > 0) {
							$fileInformation['type']	= 'image';
							$fileInformation['size']	= filesize($absolutePath);
							list($fileInformation['width'],$fileInformation['height'],$fileInformation['itype'],$fileInformation['range']) = getimagesize($absolutePath);
							// サムネイル画像があるか確認する
							$fileElements	= explode('.',$fileName);
							array_pop($fileElements);
							$fileBaseName	= implode('.',$fileElements);
							$thumbFileName	= 'sthumb_'.$fileBaseName.'.jpg';
							$thumbAbsolute	= dirname($absolutePath).DIRECTORY_SEPARATOR.$thumbFileName;
							if( file_exists($thumbAbsolute) ) {
								$fileInformation['thumb']		= $thumbFileName;
								$fileInformation['thumb_uri']	= dirname($uri).'/'.$thumbFileName;
							} else {
								$fileInformation['thumb']		= '';
								$fileInformation['thumb_uri']	= '';
							}
							if( preg_match('/\\.[jJ][pP][gG]$/',$fileName) > 0 ) {
								$fileInformation['thumb']	= preg_replace('/\\.[jJ][pP][gG]$/','.jpg',$fileInformation['thumb']);
							} else if( preg_match('/\\.[pP][nN][gG]$/',$fileName) > 0 ) {
								$fileInformation['thumb']	= preg_replace('/\\.[pP][nN][gG]$/','.jpg',$fileInformation['thumb']);
							} else if( preg_match('/\\.[gG][iI][fF]$/',$fileName) > 0 ) {
								$fileInformation['thumb']	= preg_replace('/\\.[gG][iI][fF]$/','.jpg',$fileInformation['thumb']);
							}
							$fileInfoHash[$fileName]	= $fileInformation;
						}
					} else {
						array_push( $nonExistsArray, $uri );
					}
				}
				$request->setAttribute('design.template.relatedFileInfoHash',$fileInfoHash );
				$request->setAttribute('design.template.relatedNoneExistFileArray',$nonExistsArray );
			}
		}

	}
}
?>