<?php
/*
 * content/Valiable.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(__FILE__))
	.DIRECTORY_SEPARATOR.'system'
	.DIRECTORY_SEPARATOR.'AbstractData.class.php');
require_once(dirname(dirname(__FILE__))
	.DIRECTORY_SEPARATOR.'system'
	.DIRECTORY_SEPARATOR.'DataFileWriter.class.php');
require_once( dirname(__FILE__)
	. DIRECTORY_SEPARATOR . 'package_define.inc.php' );
class content_Variable extends system_AbstractData {
	/** 変数値ハッシュ	*/
	var $variableHash	= array();
	/**
	 * コンストラクタ
	 */
	function content_Variable( & $request ) {
		$this->_load( $request );
	}
	/**
	 * 現在存在するキー文字列の配列を取得します
	 */
	function getKeyArray( & $request ) {
		if( !is_array($this->variableHash) || count($this->variableHash) == 0 ) {
			$this->_load( $request );
		}
		return array_keys($this->variableHash);
	}
	/**
	 * 指定のキーが存在するか確認します
	 */
	function existsKey( $key ) {
		if( isset($this->variableHash[$key]) ) {
			return true;
		}
		return false;
	}
	/**
	 * 固有変数値を取得します
	 */
	function getValue( & $request, $key ) {
		if( !is_array($this->variableHash) || count($this->variableHash) == 0 ) {
			$this->_load( $request );
		}
		if( isset($this->variableHash[$key]) ){
			if( isset($this->variableHash[$key]['value']) ) {
				return $this->variableHash[$key]['value'];
			} else {
				return '';
			}
		} else {
			return '';
		}
	}
	/**
	 * 固有変数値を設定します
	 */
	function setValue( & $request, $key, $value ) {
		if( !is_array($this->variableHash) || count($this->variableHash) == 0 ) {
			$this->_load( $request );
		}
		if( !isset($this->variableHash[$key]) || !is_array($this->variableHash[$key]) ){
			$this->variableHash[$key]	= array('key'=>$key,'label'=>null,'value'=>null);
		}
		$this->variableHash[$key]['value']	= $value;
	}
	/**
	 * 固有変数ラベルを取得します
	 */
	function getLabel( & $request, $key ) {
		if( !is_array($this->variableHash) || count($this->variableHash) == 0 ) {
			$this->_load( $request );
		}
		if( isset($this->variableHash[$key]) ){
			if( isset($this->variableHash[$key]['label']) ) {
				return $this->variableHash[$key]['label'];
			} else {
				return '';
			}
		} else {
			return '';
		}
	}
	/**
	 * 固有変数ラベルを設定します
	 */
	function setLabel( & $request, $key, $label ) {
		if( !is_array($this->variableHash) || count($this->variableHash) == 0 ) {
			$this->_load( $request );
		}
		if( !isset($this->variableHash[$key]) || !is_array($this->variableHash[$key]) ){
			$this->variableHash[$key]	= array('key'=>$key,'label'=>null,'value'=>null);
		}
		$this->variableHash[$key]['label']	= $label;
	}
	/**
	 * 指定キーのサイト変数を削除します
	 */
	function delete( & $request, $key ) {
		if( !is_array($this->variableHash) || count($this->variableHash) == 0 ) {
			$this->_load( $request );
		}
		if( isset($this->variableHash[$key]) ){
			unset($this->variableHash[$key]);
		}
	}
	/**
	 * 設定保存ファイルを読み込みます
	 */
	function _load( & $request ) {
		$fileUri	= content_Variable::_saveUri();
		$this->variableHash	= array();
		if( system_DataFileWriter::isExists( $request, $fileUri ) ) {
			$writer	= new system_DataFileWriter();
			if( $writer->open( $request, $fileUri, 'r' ) ){
				$dataHash	= array();
				while( !$writer->eof() ) {
					$strings	= trim($writer->gets());
					if( !isset($dataHash['key']) ) {
						if( strlen($strings) == 0 ) {
							continue;
						} else {
							$dataHash['key']	= $strings;
						}
					} else {
						if( !isset($dataHash['label']) ) {
							$dataHash['label']	= base64_decode($strings);
						} else if( !isset($dataHash['value']) ) {
							$dataHash['value']	= base64_decode($strings);
						} else {
							$this->variableHash[$dataHash['key']]	= $dataHash;
							$dataHash	= array();
						}
					}
				}
				if( isset($dataHash['key']) && strlen($dataHash['key'])>0 ) {
					$this->variableHash[$dataHash['key']]	= $dataHash;
				}
				$writer->close($request);
			}
		}
		ksort($this->variableHash);
		return true;
	}
	/**
	 * 現在の設定を保存します
	 */
	function _save( & $request ) {
		$fileUri	= content_Variable::_saveUri();
		$writer	= new system_DataFileWriter();
		if( $writer->open( $request, $fileUri, 'w' ) ){
			foreach( $this->variableHash as $key => $dataHash ) {
				$writer->write($key."\r\n");
				$writer->write(base64_encode($dataHash['label'])."\r\n");
				$writer->write(base64_encode($dataHash['value'])."\r\n");
				$writer->write("\r\n");
			}
			$writer->close($request);
		}
	}
	/**
	 * 変数設定保存ファイルURIを取得します
	 */
	function _saveUri(){
		return '/content/variables.txt';
	}
}
?>