<?php
/*
 * content/LoadList.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(__FILE__))
	.DIRECTORY_SEPARATOR.'system'
	.DIRECTORY_SEPARATOR.'login'
	.DIRECTORY_SEPARATOR.'ModuleBase.class.php');
require_once( dirname(dirname(__FILE__))
	.DIRECTORY_SEPARATOR.'system'
	.DIRECTORY_SEPARATOR.'DataFileWriter.class.php');
require_once( dirname(dirname(__FILE__))
	.DIRECTORY_SEPARATOR.'util'
	.DIRECTORY_SEPARATOR.'File.class.php');
require_once( dirname(__FILE__)
	. DIRECTORY_SEPARATOR.'package_define.inc.php' );
class content_LoadList extends system_login_ModuleBase {
	
	function content_LoadList() {
	}
	function execute( & $request ) {
		$currentFolder		= $request->getParam('ccurf','get');
		$loginUserObject	= $this->getLoginUserObject( $request );
		if( strlen($currentFolder) == 0 ) {
			$currentFolder		= '/';
		}
		
		$targetAbsolutePath	= util_File::suri2path( $currentFolder );
		$fileInfoHash		= array();
		if (is_dir($targetAbsolutePath)) {
			if ($dh = opendir($targetAbsolutePath)) {
				while (($fileName	= readdir($dh)) !== false) {
					if( preg_match('/^\\./',$fileName) == 0 ) {
						$absolutePath	= $targetAbsolutePath.DIRECTORY_SEPARATOR.$fileName;
						$uri			= util_File::path2suri($absolutePath);
						if( file_exists( $absolutePath ) ) {
							if( is_dir($absolutePath) ) {
								// ディレクトリの場合何もしない
							} else if(  preg_match('/^sthumb\\_((.)+)\\.[jJ][pP][gG]$/',$fileName) > 0  ) {
							
							} else if( preg_match('/inc\\.php$/',$fileName) == 0 ){
								// 基本情報
								$fileInformation			= array();
								$fileInformation['uri']		= $currentFolder.'/'.$fileName;
								$fileInformation['name']	= $fileName;
								$fileInformation['size']	= filesize($absolutePath);
								// 拡張子ごとのファイル情報
								if( preg_match('/\\.[cC][sS][sS]/',$fileName) > 0
									|| preg_match('/\\.[jJ][sS]/',$fileName) > 0
									|| preg_match('/\\.[hH][tT][mM](|[lL])/',$fileName) > 0
									|| preg_match('/\\.[xX]([mM]|[sS])[lL]/',$fileName) > 0
									|| preg_match('/\\.[tT][xX][tT]/',$fileName) > 0
									) {
									$fileInformation['type']		= 'text';
								} else if( preg_match('/\\.[pP][dD][fF]$/',$fileName) > 0 ) {
									$fileInformation['type']		= 'pdf';
									$fileInfoHash[$fileName]	= $fileInformation;
								} else if( preg_match('/\\.[jJ][pP][gG]$/',$fileName) > 0
									|| preg_match('/\\.[pP][nN][gG]$/',$fileName) > 0
									|| preg_match('/\\.[gG][iI][fF]$/',$fileName) > 0) {
									$fileInformation['type']	= 'image';
									list($fileInformation['width'],$fileInformation['height'],$fileInformation['itype'],$fileInformation['range']) = getimagesize($absolutePath);
									// サムネイル画像があるか確認する
									$fileElements	= explode('.',$fileName);
									array_pop($fileElements);
									$fileBaseName	= implode('.',$fileElements);
									$thumbFileName	= 'sthumb_'.$fileBaseName.'.jpg';
									$thumbAbsolute	= $targetAbsolutePath.DIRECTORY_SEPARATOR.$thumbFileName;
									if( file_exists($thumbAbsolute) ) {
										$fileInformation['thumb']		= $thumbFileName;
										$fileInformation['thumb_uri']	= $currentFolder.'/'.$thumbFileName;
									} else {
										$fileInformation['thumb']		= '';
										$fileInformation['thumb_uri']	= '';
									}
									$fileInfoHash[$fileName]	= $fileInformation;
								} else if( preg_match('/\\.[pP][hH][pP]$/',$fileName) > 0 ) {
									// phpファイルの場合
									$strings	= file_get_contents($absolutePath);
									$pageTitle	= '無題';
									if( preg_match('/require_once(.+)spider\\.inc\\.php/',$strings) > 0
									|| preg_match('/include_once(.+)spider\\.inc\\.php/',$strings) > 0 ) {
										// spider使用ファイル
										if( preg_match('/'.util_CharUtility::escapeRegxStr('{dynamic-page}').'/',$strings, $matches) > 0 ) {
											// dynamic-pageタグがあるなら
											$fileInformation['type']		= 'spider-dynamic';
										} else {
											// dynami-pageがないなら
											$fileInformation['type']		= 'spider';
										}
										if( preg_match('/'.util_CharUtility::escapeRegxStr('{template:').'([^\\}]+)\\}/',$strings, $matches) > 0 ) {
											// テンプレート指定がある場合
											$fileInformation['template_file_name']	= $matches[1];
											// テンプレートの文字列
											$templateString	= system_DataFileWriter::getContents($request,'/'.$fileInformation['template_file_name'],DIR_NAME_TEMPLATES);
											// ページファイルにpage-titleタグがあるなら置換
											if( preg_match('/'.util_CharUtility::escapeRegxStr('{preset:page_title ').'([^\\}]+)\\}/',$strings, $matches) > 0 ) {
												// ページタイトルタグがあるなら取り出し
												$pageTitle	= $matches[1];
												if( substr_count($pageTitle,'\'') == 2 && preg_match('/^\\\'([^\\\']*)\\\'$/',$pageTitle) > 0 ){
													$pageTitle	= preg_replace('/^\\\'/','',$pageTitle);
													$pageTitle	= preg_replace('/\\\'$/','',$pageTitle);
												}
											} else if( preg_match('/'.util_CharUtility::escapeRegxStr('{page-title:').'([^\\}]+)\\}/',$strings, $matches) > 0 ) {
												// ページタイトルタグがあるなら取り出し
												$pageTitle	= $matches[1];
											} else if( preg_match('/<[tT][iI][tT][lL][eE]>([^<]*)<\\/[tT][iI][tT][lL][eE]>/',$templateString, $matches) > 0 ) {
												// ページタイトル指定がないならテンプレートのtitleタグ
												$pageTitle	= $matches[1];
												$pageTitle	= str_replace('{write:page_title}','', $pageTitle);
											}
										} else {
											// テンプレート指定がない場合titleタグ内を取り出す
											if( preg_match('/<[tT][iI][tT][lL][eE]>([^<]*)<\\/[tT][iI][tT][lL][eE]>/',$strings, $matches) > 0 ) {
												$pageTitle	= $matches[1];
											}
										}
									} else {
										// spider未使用ファイル
										$fileInformation['type']		= 'php';
										if( preg_match('/<[tT][iI][tT][lL][eE]>([^<]*)<\\/[tT][iI][tT][lL][eE]>/',$strings, $matches) > 0 ) {
											$pageTitle	= $matches[1];
										}
									}
									$fileInformation['page_title']			= $pageTitle;
								}
								// ハッシュにファイル名をキーとして格納
								$fileInfoHash[$fileName]	= $fileInformation;
							}
						}
					}
				}
				closedir($dh);
			}
		}
		ksort($fileInfoHash);
		$request->setAttribute('content.currentFoloder',$currentFolder);
		$request->setAttribute('content.fileInformationHash',$fileInfoHash);
	}
}
?>