<?php
/*
 * content/LoadFolders.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(__FILE__))
	.DIRECTORY_SEPARATOR.'system'
	.DIRECTORY_SEPARATOR.'login'
	.DIRECTORY_SEPARATOR.'ModuleBase.class.php');
require_once( dirname(dirname(__FILE__))
	.DIRECTORY_SEPARATOR.'util'
	.DIRECTORY_SEPARATOR.'File.class.php');
require_once( dirname(__FILE__)
	. DIRECTORY_SEPARATOR . 'package_define.inc.php' );
class content_LoadFolders extends system_login_ModuleBase {
	
	function content_LoadFolders() {
	}
	function execute( & $request ) {
		$currentFolder		= $request->getParam('ccurf','get');
		$loginUserObject	= $this->getLoginUserObject( $request );
		if( strlen($currentFolder) == 0 ) {
			$currentFolder		= '/';
		}
		// ディレクトリ一覧の作成
		$targetRoot			= SPIDER_BASE_PATH;
		$folderUriArray		= $this->digFolderChilds( $targetRoot );
		$request->setAttribute('content.currentFoloder',$currentFolder);
		$request->setAttribute('content.folderArray',$folderUriArray);
	}
	/**
	 * 指定フォルダ以下の子階層フォルダを配列で取得します
	 */
	function digFolderChilds( $targetPath ) {
		$exceptUriArray	= array();
		if( defined('CONTENT_EXPECT_FOLDERS') && strlen(trim(CONTENT_EXPECT_FOLDERS)) > 0 ) {
			$exceptUris			= str_replace("\r","\n",str_replace("\r\n","\n",trim(CONTENT_EXPECT_FOLDERS)));
			$exceptUriArray	= explode("\n",trim(CONTENT_EXPECT_FOLDERS));
		}
		array_push($exceptUriArray,'/spider');
		array_push($exceptUriArray,'/'.SYSTEM_DIR_NAME_ADMIN_PANEL);
		$returnArray	= array();
		$targetUri		= util_File::path2suri( $targetPath );
		spider_Controller::loadClassDefinition('util_CharUtility');
		foreach( $exceptUriArray as $exeptUri ) {
			if( preg_match('/'.util_CharUtility::escapeRegxStr($exeptUri).'/',$targetUri) > 0 ){
				return $returnArray;
			}
		}
		if ( false !== $targetUri && is_dir($targetPath)) {
			array_push($returnArray,$targetUri);
			if ($dh = opendir($targetPath)) {
				while (($fileName	= readdir($dh)) !== false) {
					if( preg_match('/^\\./',$fileName) == 0
						&& 'tmp' != $fileName
					) {
						$absolutePath	= $targetPath.DIRECTORY_SEPARATOR.$fileName;
						if( is_dir($absolutePath) ) {
							$array			= content_LoadFolders::digFolderChilds( $absolutePath );
							$returnArray	= array_merge($returnArray,$array);
						}
					}
				}
				closedir($dh);
			}
		}
		asort($returnArray);
		return $returnArray;
	}
}
?>