<?php
/*
 * framework-spider: 基本設定記述ファイル
 * @version 1.1.04
 * 
 * CopyRight(C)Framework-Spider Developer Team. 2010. All Right Reserved. 
 * URL         : http://sourceforge.jp/projects/frameworkspider/
 * Mail        : frameworkspider-dev@lists.sourceforge.jp
 * Auther      : Masanori Nakashima
 * Modifier    : Masanori Nakashima
 * Last Updated: 2010.06.30
 * 
 */
// セッション機能 ( false=PHP標準に任せる, それ以外の文字列=セッションIDのパラメータ名を指定 )
// ※PHPのセッションID発行機能はIDが重複するバグ、IDさえ指定すれば他人になり済ますことができる問題があります。
//   spiderの独自セッションはリモートホスト照合やID発行時の重複チェック機能を追加しています。
//   spiderの発行機能は環境によっては利用できません。
define('SPIDER_USE_SPIDER_SESSION_ID',	'spisessid');
// セッション情報保存フォルダ指定
// true=spiderの一時フォルダ内に保存します, true以外の場合はパス指定文字列を記述してください,
// 空文字列またはtrue以外の場合はphp.ini設定またはOSの一時フォルダに設定を試みます。
define('SPIDER_SESSION_SAVE_PATH', true);
// 実行ファイル作成のURIを絶対パスから始める場合
define( 'SPIDER_USE_ABSOLUTE_BIN_PATH',	false );

/*
 * ユーザーエージェント分岐定義
 */
// 分岐タイプ定義 分類ID=>分類名称
$GLOBALS['SPIDER_USER_AGENT_CLASS_HASH']	= array(
	'au'			=> 'au携帯',
	'softbank'		=> 'SoftBank携帯',
	'docomo2'		=> 'DoCoMo携帯',
	'iphone'		=> 'iPhone',
	'mandroid'		=> 'Android携帯',
	'default'		=> 'パソコン',
);
// 分岐タイプにファイルが存在しなかった場合の代替タイプ定義
$GLOBALS['SPIDER_USER_AGENT_CLASS_ALT_HASH']	= array(
	'au'			=> 'docomo2',
	'softbank'		=> 'docomo2',
	'mandroid'		=> 'iphone',
	'iphone'		=> 'default',
);
// ユーザーエージェント正規表現による分岐タイプ 正規表現=>分類ID
$GLOBALS['SPIDER_USER_AGENT_CLASS_REGX_HASH']	= array(
	'/^KDDI\\-/'							=> 'au',
	'/^UP\\.Browser\\/[0-9\\.]+\\-/'		=> 'au',
	'/^J\\-PHONE/'							=> 'softbank',
	'/^Vodafone/'							=> 'softbank',
	'/^SoftBank/'							=> 'softbank',
	'/CPU\\siPhone\\sOS/'					=> 'iphone',
	'/Android\\s1\\.[0-9]\\;\\sja\\-jp\\;\\sDocomo\\sHT\\-03A/'		=> 'mandroid',
	'/Android\\s1\\.[0-9]\\;\\sja\\-jp\\;\\sSonyEricssonSO\\-01B/'	=> 'mandroid',
	'/^DoCoMo\\//'							=> 'docomo2',
);
// 携帯メールアドレスドメイン名の正規表現による分岐タイプ 正規表現=>分類ID
$GLOBALS['MOBILE_MAIL_DOMAIN_CLASS_REGX_HASH'] = array(
	'/\\@docomo\\.ne\\.jp$/'	=> 'docomo2'
	,'/\\@ezweb\\.ne\\.jp$/'	=> 'au'
	,'/\\@yy.ezweb\\.ne\\.jp$/'	=> 'au'
	,'/\\@[a-z].vodafone\\.ne\\.jp$/'	=> 'softbank'
	,'/\\@softbank\\.ne\\.jp$/'	=> 'softbank'
	,'/\\@disney\\.ne\\.jp$/'	=> 'softbank'
	,'/\\@i\\.softbank\\.jp$/'	=> 'iphone'
);
// ユーザーエージェントごとに出力文字セットを指定する場合
$GLOBALS['SPIDER_USER_AGENT_CLASS_OUTPUT_CHARSET']	= array(
	'docomo2'	=> 'SJIS-win',
	'au'		=> 'SJIS-win',
	'softbank'	=> 'SJIS-win',
	'iphone'	=> 'UTF-8',
	'mandroid'	=> 'UTF-8',
	'default'	=> 'UTF-8',
);
// ユーザーエージェントごとのセッション維持条件リモートホスト
$GLOBALS['SPIDER_USER_AGENT_REMOTE_SESSION_PERMIT_HOSTS']	= array(
	'docomo2'	=> array('/\\.docomo\\.ne\\.jp$/'),
	'au'		=> array('/\\.ezweb\\.ne\\.jp$/'),
	'softbank'	=> array('/\\.jp\\-[a-z]\\.ne\\.jp$/'),
	'iphone'	=> array('/.+$/'),
	'mandroid'	=> array('/.+$/'),
	'default'	=> array(),
);
// ユーザーエージェントごとのセッション保存エージェント名削除正規表現
$GLOBALS['SPIDER_USER_AGENT_SESSION_SAVE_DELETE_REGX']	= array(
	'docomo2'	=> '/;ser[^;]+;icc[^;\\)]+/',
);

/*
 * 拡張設定
 */
// ライブラリディレクトリ名
define ( 'DIR_NAME_LIB',				'lib' );
// テンプレート配置ディレクトリ名
define ( 'DIR_NAME_TEMPLATES',		'templates' );
// ウィジェットディレクトリ名
define ( 'DIR_NAME_WIDGETS',			'widgets' );
// データ保存ディレクトリ名
define ( 'DIR_NAME_DATA',				'data' );
// ワークディレクトリ名
define ( 'DIR_NAME_WORK',				'work' );
// アプリケーションログ保存ディレクトリ
define ( 'DIR_NAME_LOG',				'logs' );

// ビルドファイル配置ディレクトリ名
define ( 'DIR_NAME_BIN',				'bin' );
// ロックディレクトリ名
define ( 'DIR_NAME_LOCK',				'lock' );
// キャッシュディレクトリ名
define ( 'DIR_NAME_CACHE',			'cache' );
// テンポラリディレクトリ名
define ( 'DIR_NAME_TMP',				'tmp' );

/*
 * 基本定義 
 */
/** セッションスコープ：グローバル */
define( 'SPIDER_SESSION_SCOPE_GLOBAL', 'GLOBAL' );
/** セッションスコープ:自動	*/
define( 'SPIDER_SESSION_SCOPE_AUTO', 'AUTO' );
// ライブラリフォルダの絶対パス
define( 'DIR_PATH_LIB', DIR_PATH_SPIDER.'/'.DIR_NAME_LIB );
// テンプレートディレクトリパス
define( 'DIR_PATH_TEMPLATES', DIR_PATH_SPIDER.'/'.DIR_NAME_TEMPLATES );
// ウィジェットディレクトリパス
define( 'DIR_PATH_WIDGETS',DIR_PATH_SPIDER.'/'.DIR_NAME_WIDGETS);
// データ保存ディレクトリ
define( 'DIR_PATH_DATA', DIR_PATH_SPIDER.'/'.DIR_NAME_DATA );
// ワークディレクトリパス
define( 'DIR_PATH_WORK', DIR_PATH_SPIDER.'/'.DIR_NAME_WORK );

// アプリケーションログ保存ディレクトリパス
define( 'DIR_PATH_LOG',	DIR_PATH_DATA.'/'.DIR_NAME_LOG );
// バイナリディレクトリパス
define( 'DIR_PATH_BIN',	DIR_PATH_WORK.'/'.DIR_NAME_BIN );
// プロセスロックの一時フォルダ
define ( 'DIR_PATH_LOCK', DIR_PATH_WORK.'/'.DIR_NAME_LOCK );
// キャッシュディレクトリパス
define( 'DIR_PATH_CACHE',	DIR_PATH_WORK.'/'.DIR_NAME_CACHE );
// 全体で利用する一時フォルダ
define ( 'DIR_PATH_TMP', DIR_PATH_WORK.'/'.DIR_NAME_TMP );

// ページ振り分けファイル配置ディレクトリ
if( defined('DIR_NAME_PAGES') && strlen(DIR_NAME_PAGES) > 0 ) {
	define( 'DIR_PATH_PAGES', DIR_PATH_SPIDER.'/'.DIR_NAME_PAGES );
}

/*
 * システムレポートとメール通知設定
 */
// ログ出力レベルの定義
define('SPIDER_LOG_LEVEL_FATAL',	0);
define('SPIDER_LOG_LEVEL_ERROR',	10);
define('SPIDER_LOG_LEVEL_WARNING',	20);
define('SPIDER_LOG_LEVEL_NOTICE',	30);
define('SPIDER_LOG_LEVEL_INFO',		40);
define('SPIDER_LOG_LEVEL_DEBUG',	50);
// ログ出力先の定義
define('SPIDER_LOG_TYPE_FILE',		0);
define('SPIDER_LOG_TYPE_SYSLOG',	10);
// 動作モード
define('SPIDER_ACTION_MODE', SPIDER_LOG_LEVEL_FATAL);

// システムメール定義ファイル名
define ( 'FILE_NAME_SYSTEM_DEFINITION',	'system.inc.php' );
// システムメール定義ファイルパス
define ( 'FILE_PATH_SYSTEM_DEFINITION',	DIR_PATH_DATA.'/'.FILE_NAME_SYSTEM_DEFINITION );

/*
 * 前処理スクリプトファイルパス配列
 * 
 * ビルドファイルを作成する前に処理したいプログラムを記述したスクリプトファイルを用意して
 * 実行させることができます。このスクリプト読み込み実行はコマンドラインからの実行でない
 * 限りビルドファイルのあるなしに関わらず事前に必ず実行されます。
 * スクリプトファイルの中で標準出力を行ってはいけません。
 * ページ表示というイベントに対するフックスクリプトのようなイメージで利用してください。
 */
$GLOBALS['SPIDER_PREVIOUS_SCRIPT_FILE_PATH_ARRAY']	= array();

// 他の定義ファイルを読み込み
require_once( dirname(__FILE__).DIRECTORY_SEPARATOR.'messages.inc.php' );
if ( file_exists( DIR_PATH_DATA.DIRECTORY_SEPARATOR.'unique_setting.inc.php' ) ) {
	include_once( DIR_PATH_DATA.DIRECTORY_SEPARATOR.'unique_setting.inc.php' );
} else if ( file_exists( dirname( __FILE__ ).DIRECTORY_SEPARATOR.'unique_setting.inc.php' ) ) {
	include_once( dirname( __FILE__ ).DIRECTORY_SEPARATOR.'unique_setting.inc.php' );
}
if ( file_exists( dirname( __FILE__ ).DIRECTORY_SEPARATOR.'application.inc.php' ) ) {
	include_once( dirname( __FILE__ ).DIRECTORY_SEPARATOR.'application.inc.php' );
}
?>