<?php include_once( "../../spider.inc.php" ); ?>
{charset:UTF-8}
{template:admin_default.tpl}
{module:topic.LoadList}
{preset:page_title '記事管理 > 記事一覧'}

	<div class="panc">
		<a href="../" title="管理パネルのトップページを表示します">管理パネルトップ</a>
		&gt; 記事管理
	</div>
	<h1>記事管理</h1>
	{if:IS_ERROR}
	<ul class="error">
	{foreach:errors error}
		<li>{write:error}</li>
	{/foreach}
	</ul>
	<br />
	{/if}

	<div style="width:95%;margin:0 auto;text-align:right;">
		<a href="./form.php" title="新しい記事を追加作成します">新しい記事を作成</a>
	</div>
	
	{if:count(topic.topicObjectHash)>0}
	<div style="width:95%;margin:0 auto;text-align:left;">
		{write:topic.totalCount}件の記事
		{write:topic.totalPage}ページ中
		{write:topic.pageNumber}ページ目
	</div>
	<table class="list" style="width:96%;margin:0 auto;">
	<thead>
	<tr>
		<th style="width:15%;white-space:nowrap;">記事日時</th>
		<th>タイトル</th>
		<th style="width:10%;white-space:nowrap;">操作</th>
	</tr>
	</thead>
	<tbody>
	{foreach:topic.topicObjectHash topicObject}
	<tr>
		<td style="width:15%;white-space:nowrap;">{write:topicObject->'topicDate'}</td>
		<td>
			<a href="./detail.php?tid={write:topicObject->'topicId'}">{write:topicObject->'subject'}</a>
		</td>
		<td style="width:10%;white-space:nowrap;text-align:center;">
			<a href="./form.php?tid={write:topicObject->'topicId'}">編集</a>
			・
			<a href="javascript:topicDelete('{write:topicObject->'topicId'}')">削除</a>
		</td>
	</tr>
	{/foreach}
	</tbody>
	</table>
	<div style="width:95%;margin:0 auto;text-align:right;">
		{if:topic.pageNumber>1}
			<a href="./index.php?pn={write:topic.pageNumber-1}">&lt;&lt;&nbsp;前のページ</a>
		{/if}
		{if:topic.pageNumber>1 && topic.totalPage>topic.pageNumber}
			&nbsp;・&nbsp;
		{/if}
		{if:topic.totalPage>topic.pageNumber}
			<a href="./index.php?pn={write:topic.pageNumber+1}">次のページ&nbsp;&gt;&gt;</a>
		{/if}
	</div>
	
	{else}
	<p>
		まだ記事がありません。
	</p>
	{/if}
	<div style="width:96%;margin:0 auto;text-align:right;margin-top:1em;">
		<hr style="" />
	</div>
	<div style="width:96%;margin:0 auto;text-align:right;">
		<a href="../">&gt;&gt; 管理パネルトップ</a>
	</div>
	
	<form name="deleteForm" action="./delete.php" method="post">
	<input type="hidden" name="topicId" value="" />
	</form>
  
<script language="JavaScript" type="text/javascript"><!--
function topicDelete( topicId ) {
	if( confirm('この記事を削除します!\nこの操作は取り消せません!\n\n本当に削除してよろしいですか?') ) {
		document.deleteForm.topicId.value	= topicId;
		document.deleteForm.submit();
	}
}
--></script>
