<?php include_once( "../../../spider.inc.php" ); ?>
{charset:UTF-8}
{template:admin_default.tpl}
{module:shopping.category.LoadList}
{module:shopping.promotion.Confirm}
{preset:page_title 'ショップ管理 > プロモーション管理 > 追加・編集'}

	<div class="panc">
		<a href="../../">管理パネルトップ</a>
		&gt; <a href="../">ショップ管理</a>
		&gt; <a href="./">プロモーション管理</a>
		{if:strlen(shopping.promotion.promotion_object->'promotion_number')==0}
		&gt; プロモーションの新規追加
		{else}
		&gt; <a href="./detail.php?shppn={write:shopping.promotion.promotion_object->'promotion_number'}">{write:shopping.promotion.promotion_object->'promotion_name'}</a>
		&gt; 編集
		{/if}
	</div>

	<h1>
		プロモーション管理
		{if:strlen(shopping.promotion.promotion_object->'promotion_number')==0}
		&gt; プロモーションの新規追加
		{else}
		&gt; {write:shopping.promotion.promotion_object->'promotion_name'}
		&gt; 編集
		{/if}
	</h1>

{if:IS_ERROR}
	<ul class="error">
	{foreach:errors error}
		<li>{write:error}</li>
	{/foreach}
	</ul>
	<p style="text-align:center;">
		<input type="button" value="戻る"
			onclick="window.history.back();"
		/><br />
	</p>
{else}
	
	<form name="cform" action="./execute.php?shppn={write:shopping.promotion.promotion_object->'promotion_number'}" method="post">
	<p style="text-align:center;">
		入力内容に間違いなければ「実行」ボタンをクリックしてください。
	</p>
	<h2>基本情報</h2>
	<table style="width:95%;margin:0 auto;" class="detail">
	<tbody>
	<tr>
		<th style="width:12em;">プロモーションID</th>
		<td>{write:shopping.promotion.promotion_object->'promotion_id'}</td>
	</tr>
	<tr>
		<th style="width:12em;">プロモーション種別</th>
		<td>
			{write:SHOPPING_PROMOTION_RANK_HASH[shopping.promotion.promotion_object->'promotion_rank']}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">プロモーション名</th>
		<td>{write:shopping.promotion.promotion_object->'promotion_name'}</td>
	</tr>
	<tr>
		<th style="width:12em;">プロモーション名<br />フリガナ</th>
		<td>{write:shopping.promotion.promotion_object->'promotion_kana'}</td>
	</tr>
	<tr>
		<th style="width:12em;">紹介コード</th>
		<td>{write:shopping.promotion.promotion_object->'promotion_code'}</td>
	</tr>
	<tr>
		<th style="width:12em;">管理メモ</th>
		<td>{write:shopping.promotion.promotion_object->'description' nl2br}</td>
	</tr>
	</tbody>
	</table>
	
	<h2>プロモーション優待設定</h2>
	<table style="width:95%;margin:0 auto;" class="detail">
	<tbody>
	<tr>
		<th style="width:12em;">紹介割引</th>
		<td>
			{if:shopping.promotion.promotion_object->'discount_type'=='money'}
				定額割引<br />
				&yen;{write:number_format(shopping.promotion.promotion_object->'discount_value')}/件
			{else-if:shopping.promotion.promotion_object->'discount_type'=='rate'}
				定率割引
				{write:shopping.promotion.promotion_object->'discount_value'}%
			{else}
				割引なし
			{/if}
		</td>
	</tr>
	</tbody>
	</table>
	<br />
	
	<h2>アフィリエイト成果報告設定</h2>
	<table style="width:95%;margin:0 auto;" class="detail">
	<tbody>
	<tr>
		<th style="width:12em;">成果報告金額</th>
		<td>
			{if:shopping.promotion.promotion_object->'exec_tax'=='0'}税込{/if}
			{if:shopping.promotion.promotion_object->'exec_tax'=='1'}税抜き(少数切り捨て){/if}
			{if:shopping.promotion.promotion_object->'exec_tax'=='2'}税抜き(少数切り上げ){/if}
			{if:shopping.promotion.promotion_object->'exec_tax'=='3'}税抜き(少数四捨五入){/if}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">成果報告HTMLタグ</th>
		<td>{write:nl2br(shopping.promotion.promotion_object->'exec_tag')}</td>
	</tr>
	<tr>
		<th style="width:12em;">成果報告URL</th>
		<td>{write:shopping.promotion.promotion_object->'exec_url'}</td>
	</tr>
	<tr>
		<th style="width:12em;">成果報告<br />{write:SHOPPING_LABEL_ORDER}{write:SHOPPING_LABEL_PRODUCT}フォーマット</th>
		<td>{write:nl2br(shopping.promotion.promotion_object->'tag_item_format')}</td>
	</tr>
	<tr>
		<th style="width:12em;">成果報告<br />{write:SHOPPING_LABEL_ORDER}{write:SHOPPING_LABEL_PRODUCT}結合文字</th>
		<td>{write:nl2br(shopping.promotion.promotion_object->'tag_item_implode')}</td>
	</tr>
	</tbody>
	</table>
	<br />

	{if:strlen(shopping.promotion.promotion_object->'member_id')==0}
	<h2>プロモーション成果報酬設定</h2>
	<table style="width:95%;margin:0 auto;" class="detail">
	<tbody>
	<tr>
		<th style="width:12em;">成果報酬</th>
		<td>
			{if:shopping.promotion.promotion_object->'pay_type'=='money'}
				定額報酬<br />
				&yen;{write:number_format(shopping.promotion.promotion_object->'pay_value')}/件
			{else-if:shopping.promotion.promotion_object->'pay_type'=='rate'}
				定率報酬
				{write:shopping.promotion.promotion_object->'pay_value'}%
			{else}
				報酬なし
			{/if}
		</td>
	</tr>
	</tbody>
	</table>
	<br />
	{else}
	{set:memberObject shopping.promotion.promotion_object->'memberObject'}
	{set:memberBankAccountObject shopping.promotion.promotion_object->'memberBankAccountObject'}
	<h2>関連個人情報</h2>
	<table style="width:95%;margin:0 auto;" class="detail">
	<tbody>
	<tr>
		<th style="width:12em;">関連個人情報ID</th>
		<td>{write:shopping.promotion.promotion_object->'member_id'}</td>
	</tr>
	<tr>
		<th style="width:12em;">姓名</th>
		<td>
			{write:memberObject->'family_name'} {write:memberObject->'first_name'}
			({write:memberObject->'family_kana'} {write:memberObject->'first_kana'})
		</td>
	</tr>
	<tr>
		<th style="width:12em;">連絡先</th>
		<td>
			〒{write:memberObject->'zip_code'}
			{if:strlen(memberObject->'prefecture_number')>0}{write:PREFECTURE_HASH[memberObject->'prefecture_number']}{/if} {write:memberObject->'address'} {write:memberObject->'building'}
			<br />
			TEL: {write:memberObject->'telephone_number'}<br />
			{if:strlen(memberObject->'pc_mail')>0}
			E-Mail: <a href="javascript:memberMemberMailForm('{write:memberObject->'member_id'}')">{write:memberObject->'pc_mail'}</a><br />
			{/if}
			{if:strlen(memberObject->'mb_mail')>0}
			M-Mail: <a href="javascript:memberMemberMailForm('{write:memberObject->'member_id'}')">{write:memberObject->'mb_mail'}</a><br />
			{/if}
		</td>
	</tr>
	{if:is_object(memberBankAccountObject)}
	<tr>
		<th style="width:12em;">報酬振込先</th>
		<td>
			{write:memberBankAccountObject->'bank_name'} ({write:memberBankAccountObject->'bank_code'})<br />
			{write:memberBankAccountObject->'bank_branch_name'} ({write:memberBankAccountObject->'bank_branch_code'})<br />
			{if:0!=memberBankAccountObject->'bank_account_type'}当座預金{else}普通預金{/if} {write:memberBankAccountObject->'bank_account_code'}<br />
			{write:memberBankAccountObject->'bank_account_kana'}
		</td>
	</tr>	
	{/if}
	<tr>
		<th style="width:12em;">紹介報酬</th>
		<td>
			{if:shopping.promotion.promotion_object->'pay_type'=='money'}
				定額報酬<br />
				&yen;{write:number_format(shopping.promotion.promotion_object->'pay_value')}/件
			{else-if:shopping.promotion.promotion_object->'pay_type'=='rate'}
				定率報酬
				{write:shopping.promotion.promotion_object->'pay_value'}%
			{else}
				報酬なし
			{/if}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">セルフ{write:SHOPPING_LABEL_ORDER}(卸販売)割引</th>
		<td>
			{if:shopping.promotion.promotion_object->'buying_flag'=='0'}
				なし
			{else}
				{if:shopping.promotion.promotion_object->'buying_flag'=='1'}先払いのみ許可{/if}
				{if:shopping.promotion.promotion_object->'buying_flag'=='2'}許可{/if}
				{write:shopping.promotion.promotion_object->'buying_rate'}%引
			{/if}
		</td>
	</tr>
	</tbody>
	</table>
	<br />
	{/if}

	<p style="text-align:center;">
		<input type="submit" value="実行する"
		/><input type="button" value="戻る"
			onclick="window.history.back();"
		/><br />
	</p>
	</form>
	<br />

{/if}
	<hr style="width:95%;margin:0 auto;margin-top:1em;text-align:center;" />
	<div style="width:95%;margin:0 auto;text-align:right;">
		{if:strlen(shopping.promotion.promotion_object->'promotion_number')==0}
		{else}
		&gt; <a href="./detail.php?shppn={write:shopping.promotion.promotion_object->'promotion_number'}">{write:shopping.promotion.promotion_object->'promotion_name'}の詳細へ戻る</a>
		&nbsp;&nbsp;
		{/if}
		<a href="./">&gt;&gt; プロモーション一覧へ戻る</a>
	</div>