<?php include_once( "../../../../spider.inc.php" ); ?>
{charset:UTF-8}
{template:admin_default.tpl}
{module:shopping.product.upload.Form}
{preset:page_title 'ショップ管理 > ' . SHOPPING_LABEL_PRODUCT . '管理 > CSVデータ登録'}

	<div class="panc">
		<a href="../../../">管理パネルトップ</a>
		&gt; <a href="../../">ショップ管理</a>
		&gt; <a href="../">{write:SHOPPING_LABEL_PRODUCT}管理</a>
		&gt; CSVデータ登録
	</div>

	<h1>
		ショップ管理 &gt; {write:SHOPPING_LABEL_PRODUCT}管理 &gt; CSVデータ登録
	</h1>
	
	{if:IS_ERROR}
	<ul class="error">
		{foreach:errors as error}
		<li>{write:error}</li>
		{/foreach}
	</ul>
	<p style="text-align:center;">
		<input type="button" value="{write:SHOPPING_LABEL_PRODUCT}管理に戻る" onclick="window.location.href='../'" />
	</p>
	{else}
	<p style="text-align:center;">
		取り込むCSVファイルを選択して[アップロード]をクリックしてください。
	</p>
	<br />
	<form name="mform" id="mform" action="./confirm.php" method="post" enctype="multipart/form-data">
	<table style="margin:0 auto;width:40em;">
	<tr>
		<th style="vertical-align:top;">CSVファイル</th>
		<td>
			<input type="file" name="csvfile" size="40" />
			<br />
			<input type="checkbox" name="ignore_first_line" value="true"
				{if:shopping.product.upload.registInformationHash['ignoreFirstLine']} checked{/if} />一行目はカラム名なので取り込まない
				<span style="font-size:x-small;">[<a href="javascript:" title="一行目がデータ行ではなくカラム名の行の場合はチェックを入れてください。">?</a>]</span>
			<br />
			<input type="checkbox" name="import_images" value="true"
				{if:shopping.product.upload.registInformationHash['importImages']} checked{/if} />画像を上書き登録する
				<span style="font-size:x-small;">[<a href="javascript:" onclick="shoppingProductUploadViewImageHelp()" title="/upload/shopping/product/フォルダにjpgファイルを予めアップロードして一括登録する場合にチェックをいれてください。">?</a>]</span>
			<div id="shopping-product-upload-help-images" style="width:400px;border:solid 1px #FFFF00;background-color:#ffffee;padding:3px;display:none;position:absolute;visibility:hidden;cursor:pointer;" onclick="shoppingProductUploadViewImageHelp()">
				<h5>画像同時取り込みについて</h5>
				<div style="line-height:1.1em;font-size:small;">
					<span style="color:#008000;">[設置フォルダ]/upload/shopping/product/</span>フォルダにjpgファイルをFTPであらかじめアップロードしておくことでCSV{write:SHOPPING_LABEL_PRODUCT}登録時に{write:SHOPPING_LABEL_PRODUCT}画像の登録・更新をおこなうことができます。
					<br />
					<br />
					{write:SHOPPING_LABEL_PRODUCT}の画像を登録する場合はファイル名を「<span style="color:#008000;">[{write:SHOPPING_LABEL_PRODUCT}ID]_[01～03].jpg</span>」としてFTPでサーバーに転送してください。<br />
					例){write:SHOPPING_LABEL_PRODUCT}IDがEPL001の画像ファイル1、2を登録<br />
					EPL001_01.jpg<br />
					EPL001_02.jpg<br />
					<br />
					{write:SHOPPING_LABEL_PRODUCT}販売単位の画像を登録する場合はファイル名を「<span style="color:#008000;">[{write:SHOPPING_LABEL_PRODUCT}ID]_[販売単位ID]_[01～03].jpg</span>」としてFTPでサーバーに転送してください。<br />
					例){write:SHOPPING_LABEL_PRODUCT}IDがEPL001で販売単位IDがE001の画像ファイル1、2を登録<br />
					EPL001_E001_01.jpg<br />
					EPL001_E001_02.jpg<br />
					<br />
				</div>
			</div>
			<br />
			<input type="checkbox" name="import_files" value="true"
				{if:shopping.product.upload.registInformationHash['importDownloadFiles']} checked{/if} />ダウンロード{write:SHOPPING_LABEL_PRODUCT}ファイルを上書き登録する
				<span style="font-size:x-small;">[<a href="javascript:" onclick="shoppingProductUploadViewFilesHelp()" title="/upload/shopping/product/filesフォルダに登録定義ファイルと実際にダウンロードさせるファイルを予めアップロードして一括登録する場合にチェックをいれてください。">?</a>]</span>
			<div id="shopping-product-upload-help-files" style="width:400px;border:solid 1px #FFFF00;background-color:#ffffee;padding:3px;display:none;position:absolute;visibility:hidden;cursor:pointer;" onclick="shoppingProductUploadViewFilesHelp()">
				<h5>ダウンロード{write:SHOPPING_LABEL_PRODUCT}ファイル同時取り込みについて</h5>
				<div style="line-height:1.1em;font-size:small;">
					<span style="color:#008000;">[設置フォルダ]/upload/shopping/product/files</span>フォルダに登録定義ファイルと実際にダウンロードさせるファイルをFTPであらかじめアップロードしておくことでCSV{write:SHOPPING_LABEL_PRODUCT}登録時にダウンロード{write:SHOPPING_LABEL_PRODUCT}ファイルの登録・更新をおこなうことができます。
					<br />
					登録定義ファイルの記述方法とファイル配置方法に関する説明は公式サイトのマニュアルをご覧ください。
				</div>
			</div>
		</td>
	</tr>
	</table>
	
	<p style="text-align:center;">
		CSVデータのカラム順序どおりにを右側のボックスに並べてください。
	</p>
	<table style="width:40em;margin:0 auto;">
	<thead>
	<tr>
		<th style="text-align:center;padding:3px;">選択項目</th>
		<th style="text-align:center;padding:3px;"></th>
		<th style="text-align:center;padding:3px;">登録カラム順序</th>
	</tr>
	</thead>
	<tbody>
	<tr>
		<td style="width:15em;">
			<select name="items[]" id="selectableItemBox" style="width:15em;height:20em;" multiple></select>
		</td>
		<td style="width:8em;text-align:center;">
			<input type="button" value="追加&gt;&gt;" onclick="shoppingProductDownloadAdd()" /><br />
			<input type="button" value="&lt;&lt;削除" onclick="shoppingProductDownloadDel()" />
		</td>
		<td style="width:15em;">
			<select name="selected_items[]" id="selectedItemBox" style="width:15em;height:20em;" multiple></select>
		</td>
	</tr>
	</tbody>
	</table>
	
	<p style="text-align:center;">
		<input type="button" value="アップロード" onclick="shoppingProductDownloadSubmit()"
		/><br />
	</p>
	</form>


<script language="JavaScript" type="text/javascript"><!--
// 選択可能リスト
var selectableItems	= new Array();
// 選択リスト
var selectedItems	= new Array();
// 選択可能セレクトボックス
var selectableBox	= null;
// 選択セレクトボックス
var selectedBox		= null;
/*
 * 初期化
 */
function shoppingProductDownloadInitialize() {
	// グローバルの選択可能リストと選択リストを初期化
	selectableItems	= new Array();
	selectedItems	= new Array();
	// 表示に利用するセレクトボックスを設定
	selectableBox	= document.getElementById('selectableItemBox');
	selectedBox		= document.getElementById('selectedItemBox');
	//
	var optionElm	= null;
	{foreach:SHOPPING_PRODUCT_CSV_DEFINITION itemKey itemName}
	optionElm				= new Option('{write:itemName}','{write:itemKey}');
	optionElm.innerHTML		= optionElm.text;
	{if:itemKey=='product_id'}
	optionElm.style.color	= '#ff0000';
	{/if}
	{if:in_array(itemKey,shopping.product.upload.columnSelectedArray)}
	selectedItems.push(optionElm);
	{else}
	selectableItems.push(optionElm);
	{/if}
	{/foreach}
	{foreach:SHOPPING_PRODUCT_UNIT_CSV_DEFINITION itemKey itemName}
	optionElm				= new Option('{write:itemName}','{write:itemKey}');
	optionElm.innerHTML		= optionElm.text;
	{if:in_array(itemKey,shopping.product.upload.columnSelectedArray)}
	selectedItems.push(optionElm);
	{else}
	selectableItems.push(optionElm);
	{/if}
	{/foreach}
	shoppingProductDownloadReview();
}
/**
 * 選択に追加
 */
function shoppingProductDownloadAdd() {
	var delPos	= 0;
	for( var num=0; num<selectableBox.length; num++ ) {
		if( selectableBox.options[num].selected ) {
			selectableBox.options[num].selected	= false;
			selectedItems.push(selectableBox.options[num]);
			selectableItems.splice(delPos,1);
			delPos--;
		}
		delPos++;
	}
	shoppingProductDownloadReview();
}
/**
 * 選択から削除
 */
function shoppingProductDownloadDel() {
	var delPos	= 0;
	for( var num=0; num<selectedBox.length; num++ ) {
		if( selectedBox.options[num].selected ) {
			selectedBox.options[num].selected	= false;
			selectableItems.push(selectedBox.options[num]);
			selectedItems.splice(delPos,1);
			delPos--;
		}
		delPos++;
	}
	shoppingProductDownloadReview();
}
/**
 * 再表示
 */
function shoppingProductDownloadReview() {
	selectableBox.length	= 0;
	for( var num=0; num<selectableItems.length; num++ ) {
		var optionElm			= selectableItems[num];
		optionElm.innerHTML		= optionElm.text;
		selectableBox.appendChild(optionElm);
	}
	selectedBox.length	= 0;
	for( var num=0; num<selectedItems.length; num++ ) {
		var optionElm			= selectedItems[num];
		optionElm.innerHTML		= optionElm.text;
		selectedBox.appendChild(optionElm);
	}
}
/**
 * submit機能
 */
function shoppingProductDownloadSubmit() {
	for( var num=0; num<selectedBox.length; num++ ) {
		selectedBox.options[num].selected	= true;
	}
	document.mform.submit();
}
if(window.attachEvent){
	window.attachEvent('onload',shoppingProductDownloadInitialize);
}else{
	window.addEventListener('DOMContentLoaded',shoppingProductDownloadInitialize,false);
}
/**
 * 画像ヘルプ表示
 */
function shoppingProductUploadViewImageHelp() {
	var helpPanel	= document.getElementById('shopping-product-upload-help-images');
	if( helpPanel ) {
		if( helpPanel.style.visibility == 'hidden' ) {
			helpPanel.style.display = 'block';
			helpPanel.style.visibility = 'visible';
		} else {
			helpPanel.style.display	= 'none';
			helpPanel.style.visibility	= 'hidden';
		}
	}
}
/**
 * ファイル登録ヘルプ表示
 */
function shoppingProductUploadViewFilesHelp() {
	var helpPanel	= document.getElementById('shopping-product-upload-help-files');
	if( helpPanel ) {
		if( helpPanel.style.visibility == 'hidden' ) {
			helpPanel.style.display = 'block';
			helpPanel.style.visibility = 'visible';
		} else {
			helpPanel.style.display	= 'none';
			helpPanel.style.visibility	= 'hidden';
		}
	}
}
//--></script>
	{/if}

	<hr style="width:96%;margin:0 auto;margin-top:1em;" />
	<div style="width:96%;margin:0 auto;text-align:right;">
		<a href="../">&gt;&gt; {write:SHOPPING_LABEL_PRODUCT}一覧へ戻る</a>
	</div>