<?php include_once( "../../../spider.inc.php" ); ?>
{charset:UTF-8}
{template:admin_default.tpl}
{module:member.history.Point}
{preset:page_title MEMBER_PERSONAL_LABEL . '管理 > ポイント履歴'}

	<div class="panc">
		<a href="../../">管理パネルトップ</a>
		&gt; <a href="../">{write:MEMBER_PERSONAL_LABEL}情報一覧</a>
		{if:!is_null(member.history.point.memberObject)}
		&gt; <a href="./point.php">ポイント履歴検索</a>
		&gt; {write:member.history.point.memberObject->'view_name'}さんのポイント履歴
		{else}
		&gt; ポイント履歴検索
		{/if}
	</div>

	<h1>
		{write:MEMBER_PERSONAL_LABEL}管理 &gt; ポイント履歴検索
		{if:!is_null(member.history.point.memberObject)}
		&gt; {write:member.history.point.memberObject->'view_name'}さんのポイント履歴
		{/if}
	</h1>
	
	<form name="sform" action="./point.php" method="get">
	<input type="hidden" name="pn" value="{write:member.history.point.page_number}" />
	<table style="width:96%;margin:0 auto;border-style:none;">
	<tbody>
	<tr>
		<td style="border-style:none;">
			{write:MEMBER_PERSONAL_LABEL}ID <input type="text" name="mi" size="15" value="{write:member.history.point.member_id}" />
			西暦 <select name="mpty" onchange="document.sform.submit()">
				<option value="">選択</option>
				<?php for( $i=date('Y'); $i>1970; $i-- ) { $request->setAttribute('page.year',$i); ?>
				<option value="{write:page.year}"
					{if:page.year==member.history.point.targetYear} selected{/if}
				>{write:page.year}</option>
				<?php } ?>
			</select>年
			<select name="mptm" onchange="document.sform.submit()">
				<option value="">選択</option>
				<?php for( $i=1; $i<=12; $i++ ) { $request->setAttribute('page.month',sprintf('%02d',$i)); ?>
				<option value="{write:page.month}"
					{if:page.month==member.history.point.targetMonth} selected{/if}
				>{write:page.month}</option>
				<?php } ?>
			</select>月
		</td>
		<td style="border-style:none;text-align:right;">
			{if:!is_null(member.history.point.memberObject)}
			<input type="button" value="ポイント付与・減算" onclick="window.location.href='../member/point/form.php?mi={write:member.history.point.member_id}'" />
			{/if}
		</td>
	</tr>
	</tbody>
	</table>
	</form>

	{if:!is_null(member.history.point.memberObject)}
	<p>
		現在の{write:member.history.point.memberObject->'view_name'}さんのポイント={write:member.history.point.memberObject->'point'}Pt.
	</p>
	{/if}

	{if:IS_ERROR}
	<ul class="error">
	{foreach:errors error}
		<li>{write:error}</li>
	{/foreach}
	</ul>
	{else}
	<table class="list" style="width:96%;margin:0 auto;">
	<tbody>
	<tr style="background-color:#606060;">
		<td nowrap style="color:#F0F0F0;text-align:center;border-right-style:dotted;border-width:1px;">日</td>
		<td nowrap style="color:#F0F0F0;text-align:center;border-right-style:dotted;border-width:1px;">時間</td>
		<td nowrap style="color:#F0F0F0;text-align:center;border-right-style:dotted;border-width:1px;">増減値</td>
		<td nowrap style="color:#F0F0F0;text-align:center;">ポイント時の情報</td>
	</tr>
	{foreach:member.history.point.data_array history_data}
	<tr>
		<td style="border-right-style:dotted;border-width:1px;">{write:history_data::action_date_day}</td>
		<td style="border-right-style:dotted;border-width:1px;">{write:history_data::action_date_hour}:{write:history_data::action_date_min}:{write:history_data::action_date_sec}</td>
		<td style="border-right-style:dotted;border-width:1px;text-align:right;">{write:number_format(history_data::action_point)}Pt.</td>
		<td style="padding:0px;">
			<table style="margin:0px;border-collapse:collapse;">
			<tbody>
			<tr>
				<td style="font-size:x-small;">Label</td>
				<td style="font-size:x-small;">:</td>
				<td style="font-size:x-small;">{write:history_data::action_label nl2br}</td>
			</tr>
			<tr>
				<td style="font-size:x-small;">Detail</td>
				<td style="font-size:x-small;">:</td>
				<td style="font-size:x-small;">{write:history_data::action_detail nl2br}</td>
			</tr>
			<tr>
				<td style="font-size:x-small;">Operation</td>
				<td style="font-size:x-small;">:</td>
				<td style="font-size:x-small;">
					{if:history_data->'owner_id'==member.history.point.member_id}
						本人操作
					{else}
						管理者ID: {write:history_data->'owner_id'}
					{/if}
				</td>
			</tr>
			<tr>
				<td style="font-size:x-small;">IP</td>
				<td style="font-size:x-small;">:</td>
				<td style="font-size:x-small;">{write:history_data::remote_address}</td>
			</tr>
			<tr>
				<td style="font-size:x-small;">Host</td>
				<td style="font-size:x-small;">:</td>
				<td style="font-size:x-small;">{write:history_data::remote_host}</td>
			</tr>
			<tr>
				<td style="font-size:x-small;">UA</td>
				<td style="font-size:x-small;">:</td>
				<td style="font-size:x-small;">{write:history_data::user_agent}</td>
			</tr>
			</tbody>
			</table>
		</td>
	</tr>
	{/foreach}
	<tr>
		<td colspan="2" nowrap>合計ポイント増減</td>
		<td nowrap>
			{write:number_format(member.history.point.totalPointChange)}Pt.
		</td>
		<td></td>
	</tr>
	</tbody>
	</table>
	{/if}

	<hr style="width:96%;margin:0 auto;margin-top:1em;" />
	<div style="width:96%;margin:0 auto;text-align:right;">
		{if:!is_null(member.history.point.memberObject)}
		&gt;&gt; <a href="../member/detail.php?mi={write:member.history.point.memberObject->'member_id'}"
			>{write:member.history.point.memberObject->'view_name'}さんの詳細情報へ</a>
		{/if}
		&nbsp;
		&gt;&gt; <a href="../">{write:MEMBER_PERSONAL_LABEL}一覧へ戻る</a>
		&nbsp;
		&gt;&gt; <a href="../../">管理パネルトップへ戻る</a>
	</div>