<?php include_once( "../../../../spider.inc.php" ); ?>
{charset:UTF-8}
{template:admin_default.tpl}
{module:system.login.Require}
{module:design.template.setting.Load}
{module:design.template.LoadRelatedFiles}
{preset:page_title 'デザイン管理 > デザインテンプレート設定'}

	<div class="panc">
		<a href="../../../" title="管理パネルのトップページを表示します">管理パネルトップ</a>
		&gt; <a href="../../" title="デザイン管理トップページを表示します">デザイン管理</a>
		&gt; <a href="../" title="デザインテンプレートの一覧を表示します">デザインテンプレート一覧</a>
		&gt; デザインテンプレート設定
	</div>
	<h1>デザイン管理 &gt; デザインテンプレート設定 &gt; {write:design.template.setting.templateObject->'view_name'}</h1>
	
	{if:IS_ERROR}
	<ul class="error">
	{foreach:errors error}
		<li>{write:error}</li>
	{/foreach}
	</ul>
	<p style="width:95%;margin-top:2em;text-align:right;">
		<a href="../">&gt;&gt; デザインテンプレート一覧ページに戻る</a>
	</p>
	{else}
	
	{if:count(design.template.relatedNoneExistFileArray)>0}
	<h2>サーバー上に見つからないファイル</h2>
	<p style="color:#ff0000;">
		※これらのファイルはデザインテンプレート内に記述されていますがサーバー上に見つかりませんでした。
		これらのファイルをアップロードして問題を解決してください。
	</p>
	<div style="width:93%;margin:0 auto;padding:5px;border:solid 1px #ff0000;background-color:#ffe0e0;font-weight:bold;color:#ff0000;">
		{foreach:design.template.relatedNoneExistFileArray fileUri}
			{write:fileUri} <span style="font-size:x-small;">[<a href="javascript:designTemplateContentFileUpload('{write:dirname(fileUri)}','{write:basename(fileUri)}');">アップロード</a>]</span>
			<br />
		{/foreach}
	</div>
	<br />
	{/if}
	
	<form name="settingform" action="./confirm.php" method="post">
	<h2 class="global">基本情報</h2>
	<p>
		基本情報はデザインテンプレートの表示名のみ変更できます。変更したらページ下部の「変更を保存」ボタンをクリックしてください。
	</p>
	<table class="list" style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:20%;">ファイル名</th>
		<td>{write:design.template.setting.templateObject->'file_name'}</td>
	</tr>
	<tr>
		<th>表示名</th>
		<td>
			<input type="text" name="view_name" size="50" value="{write:design.template.setting.templateObject->'view_name'}" />
		</td>
	</tr>
	<tr>
		<th>配布名</th>
		<td>{write:design.template.setting.templateObject->'name'}</td>
	</tr>
	<tr>
		<th>制作・著作</th>
		<td>{write:design.template.setting.templateObject->'copyright'}</td>
	</tr>
	<tr>
		<th>再配布の許可</th>
		<td>
			{if:strlen(design.template.setting.templateObject->'publish_key')>0}
				再配布用のデザインテンプレート作成はパスワードでロックされています
			{else}
				カスタマイズの再配布が許可されています
			{/if}
		</td>
	</tr>
	<tr>
		<th>HTML編集</th>
		<td>{if:design.template.setting.templateObject->'html_edit'}許可{else}不可{/if}</td>
	</tr>
	<tr>
		<th>配布URL</th>
		<td>{write:design.template.setting.templateObject->'url'}</td>
	</tr>
	<tbody>
	</table>
	<p style="text-align:center;">
		<img alt="変更を保存する" onclick="designTemplateSettingSave()" onkeydown="designTemplateSettingSave()" src="/<?php echo SYSTEM_DIR_NAME_ADMIN_PANEL; ?>/images/button/save_01.jpg" onmouseover="this.src='/<?php echo SYSTEM_DIR_NAME_ADMIN_PANEL; ?>/images/button/save_01_on.jpg'" onmouseout="this.src='/<?php echo SYSTEM_DIR_NAME_ADMIN_PANEL; ?>/images/button/save_01.jpg'" style="cursor:pointer;" />
	</p>
	<br />
	
	
	<h2 class="global">このテンプレートで利用されているサイト固有値</h2>
	<p>
		デザインテンプレート内で利用されている値を設定してページ下部の「変更を保存」ボタンをクリックしてください。
	</p>
	<table class="list" style="width:95%;margin:0 auto;">
	<thead>
	<tr>
		<th>変数名</th>
		<th>説明</th>
		<th>値</th>
	</tr>
	</thead>
	<tbody>
	{set:variableHash design.template.setting.templateObject->'variableHash'}
	{foreach:variableHash variableKey variableHash}
	<tr>
		<td style="vertical-align:top;background-color:{if:variableHash['setup']!==true}#fff0f0{else}#ffffff;{/if};">
			<input type="hidden" name="variable_key[]" value="{write:variableKey}" />
			{write:variableKey}
		</td>
		<td style="vertical-align:top;font-size:x-small;background-color:{if:variableHash['setup']!==true}#fff0f0{else}#ffffff;{/if};">
			<input type="hidden" name="variable_note[]" value="{write:variableHash['note']}" />
			{write:variableHash['note']}
		</td>
		<td style="vertical-align:top;width:200px;padding:0px;background-color:{if:variableHash['setup']!==true}#fff0f0{else}#ffffff;{/if};">
			<textarea name="variable_value[]" cols="30" rows="2" style="width:99%;background-color:{if:variableHash['setup']!==true}#fff0f0{else}#ffffff;{/if};">{write:variableHash['value']}</textarea>
		</td>
	</tr>
	{/foreach}
	</tbody>
	</table>
	<div style="width:95%;margin:0 auto;text-align:right;">
		<a href="../../../content/variable/form.php"
			title="全てのサイト固有値設定へ"
			>&gt;&gt;全てのサイト固有値設定へ</a>
	</div>
	<p style="text-align:center;">
		<img alt="変更を保存する" onclick="designTemplateSettingSave()" onkeydown="designTemplateSettingSave()" src="/<?php echo SYSTEM_DIR_NAME_ADMIN_PANEL; ?>/images/button/save_01.jpg" onmouseover="this.src='/<?php echo SYSTEM_DIR_NAME_ADMIN_PANEL; ?>/images/button/save_01_on.jpg'" onmouseout="this.src='/<?php echo SYSTEM_DIR_NAME_ADMIN_PANEL; ?>/images/button/save_01.jpg'" style="cursor:pointer;" />
	</p>
	<br />
	
	<h2 class="global">このデザインテンプレートで利用されているアップロードファイル</h2>
	<p>
		画像を[変更]をクリックして上書きアップロード、テキスト形式のファイルは[編集]をクリックして管理パネル上で編集して貴方のサイトに併せて変更することができます。
	</p>
	<div style="width:740px;margin:0 auto;">
	{foreach:design.template.relatedFileInfoHash name fileInformation}
		<div style="width:138px;float:left;text-align:center;border:solid 1px #909090;padding:2px;font-size:10px;overflow:none;margin-left:1px;margin-top:1px;">
			<table style="width:138px;height:138px;"><tbody><tr><td>
			{if:'image'==fileInformation['type']}
				{if:strlen(fileInformation['thumb'])>0}
					<a href="{write:fileInformation['uri']}" target="_blank"
						title="{write:fileInformation['uri']}"
						><img src="{write:fileInformation['thumb_uri']}"
							alt="{write:fileInformation['uri']}"
						/></a>
				{else}
					<a href="{write:fileInformation['uri']}" target="_blank"
						title="{write:fileInformation['uri']}"
						><img src="{write:fileInformation['uri']}"
							alt="{write:fileInformation['uri']}"
							onload="contentFileImageResize(this,130,130)"
							style="width:130px;height:130px;"
						/></a>
				{/if}
			{else}
				{set:fileName basename(fileInformation['uri'])}
				{set:iconImage 'others.gif'}
				{if:'pdf'==fileInformation['type']}
					{set:iconImage 'pdf.gif'}
				{else-if:preg_match('/\.htm(|l)$/',fileName)>0}
					{set:iconImage 'html.gif'}
				{else-if:preg_match('/\.xml$/',fileName)>0 || preg_match('/\.xsl$/',fileName)>0}
					{set:iconImage 'xml.gif'}
				{else-if:preg_match('/\.txt$/',fileName)>0}
					{set:iconImage 'text.gif'}
				{else-if:preg_match('/\.js$/',fileName)>0}
					{set:iconImage 'js.gif'}
				{else-if:preg_match('/\.css$/',fileName)>0}
					{set:iconImage 'css.gif'}
				{else-if:preg_match('/\.(swf|flv)/',fileName)>0}
					{set:iconImage 'flash.gif'}
				{/if}
				{if:'text'==fileInformation['type']}
					<a href="/<?php echo SYSTEM_DIR_NAME_ADMIN_PANEL; ?>/content/file/edit/form.php?cturi={write:fileInformation['uri']}"
						title="{write:fileInformation['uri']}をテキストエディタで編集する"
						><img src="/<?php echo SYSTEM_DIR_NAME_ADMIN_PANEL; ?>/content/images/icon/{write:iconImage}"
						alt="{write:fileInformation['uri']}をテキストエディタで編集する"
						/></a>
					<br />
				{else}
					<a href="{write:fileInformation['uri']}" target="_blank"
						title="{write:fileInformation['uri']}をダウンロードする"
						><img src="/<?php echo SYSTEM_DIR_NAME_ADMIN_PANEL; ?>/content/images/icon/{write:iconImage}"
						alt="{write:fileInformation['uri']}をダウンロードする"
						/></a>
				{/if}
			
			{/if}
			</td></tr></tbody></table>
			<div style="width:90%;margin:0 auto;overflow:hidden;font-size:9px;">{write:basename(fileInformation['uri'])}</div>
			{if:'text'==fileInformation['type']}
				<a href="{write:fileInformation['uri']}" target="_blank"
					title="{write:fileInformation['uri']}をダウンロードする"
					>DL</a>
				/
				<a href="/<?php echo SYSTEM_DIR_NAME_ADMIN_PANEL; ?>/content/file/edit/form.php?cturi={write:fileInformation['uri']}"
					title="{write:fileInformation['uri']}をテキストエディタで編集する"
					>編集</a>
				/
				<a href="javascript:designFileDelete('{write:fileInformation['uri']}')"
					title="{write:fileInformation['uri']}をサーバー上から削除する"
					>削除</a>
			{else}
				<a href="{write:fileInformation['uri']}" target="_blank"
					title="{write:fileInformation['uri']}を別ウィンドウで開く"
					>確認</a>
				/
				<a href="javascript:contentFileViewUploadForm('{write:dirname(fileInformation['uri'])}','{write:basename(fileInformation['uri'])}',false,designTemplateSettingPageReload)"
					title="{write:fileInformation['uri']}をアップロードして別の画像に変更する"
					>変更</a>
				/
				<a href="javascript:designFileDelete('{write:fileInformation['uri']}')"
					title="{write:fileInformation['uri']}をサーバー上から削除する"
					>削除</a>
			{/if}
			<br />
			{if:'image'==fileInformation['type']}{if:strlen(fileInformation['width'])>0 && strlen(fileInformation['width'])>0}
				{write:fileInformation['width']}x{write:fileInformation['height']}
				/
			{/if}{/if}
			{if:fileInformation['size']>1024*1024*1024}
				{write:round(fileInformation['size']/(1024*1024*1024),1)}GB
			{else-if:fileInformation['size']>1024*1024}
				{write:round(fileInformation['size']/(1024*1024),1)}MB
			{else-if:fileInformation['size']>1024}
				{write:round(fileInformation['size']/1024,1)}KB
			{else}
				{write:fileInformation['size']}byte
			{/if}
		</div>
	{/foreach}
	<br style="clear:left;" />
	</div>
	<br />
	
	{if:is_array(design.template.setting.templateObject->'relatedPageObjectArray') && count(design.template.setting.templateObject->'relatedPageObjectArray')>1}
	<h2 class="global">このデザインテンプレートの同梱ページ</h2>
	<table class="list" style="width:95%;margin:0 auto;">
	<thead>
	<tr>
		<th style="width:40%;">URI</th>
		<th>タイトル</th>
		<th style="white-space:nowrap;">操作</th>
	</tr>
	</thead>
	<tbody>
	{foreach:design.template.setting.templateObject::relatedPageObjectArray pageObject}
	<tr style="{if:design.template.setting.templateObject->'file_name'==pageObject->'template'}background-color:#f0f0f0;{else}{/if}">
		<td style="white-space:nowrap;">{write:pageObject->'uri'}</td>
		<td>{write:pageObject->'title'}</td>
		<td style="white-space:nowrap;text-align:center;">
			<select name="page_action" id="page_action_{write:design_template_setting_templateObject_relatedPageObjectArray_loop_counter}">
				<option value="0">適用のみ</option>
				<option value="1">復元のみ</option>
				<option value="2">適用と復元</option>
				<option value="3">インポート</option>
			</select><input type="button" value="実行" onclick="designTemplatePageAction('{write:pageObject->'uri'}',document.getElementById('page_action_{write:design_template_setting_templateObject_relatedPageObjectArray_loop_counter}'));"
			/><input type="button" value="設定" onclick="window.location.href='../../../content/page/setting/form.php?uri={write:urlencode(pageObject->'uri')}';"
			/>
		</td>
	</tr>
	{/foreach}
	</tbody>
	</table>
	{/if}
	</form>

	<p style="width:95%;margin-top:2em;text-align:right;">
		{if:design.template.setting.templateObject->'html_edit'}
		<a href="../html/form.php?fmt={write:urlencode(design.template.setting.templateObject->'file_name')}"
			title="このデザインテンプレートのHTMLを編集します"
			>&gt;&gt; {write:design.template.setting.templateObject->'file_name'}のHTML編集</a>
		&nbsp;&nbsp;
		{/if}
		<a href="javascript:designTemplateRecoverView()" title="デザインテンプレートファイルをアップロードしてこのデザインテンプレートを復元します">&gt;&gt; 復元</a>
		&nbsp;&nbsp;
		<a href="javascript:designTemplatePublishView()" title="このデザインテンプレートをバックアップ・配布可能な形式のファイルにしてダウンロードします">&gt;&gt; ダウンロード</a>
		&nbsp;&nbsp;
		<a href="../" title="登録済みデザインテンプレートの一覧ページに戻ります">&gt;&gt; デザインテンプレート一覧ページに戻る</a>
	</p>

<script language="JavaScript" type="text/javascript"><!--
var designTemplateSettingHttpObject;
function designTemplateSettingSave() {
	var postContents	= 'command=0'
	postContents		+= FormerCommon.createFormContents(document.settingform);
	designTemplateSettingHttpObject	= FormerCommon.createHttpRequest(designTemplateSettingSaveResult);
	if (designTemplateSettingHttpObject) {
		FormerCommon.displayGrayOut(9999);
		designTemplateSettingHttpObject.open("POST",'./save.php?fmt='+encodeURIComponent('{write:design.template.setting.templateObject->'file_name'}'),true);
		designTemplateSettingHttpObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
		designTemplateSettingHttpObject.send(postContents);
	} else {
		alert('サーバーへの接続作成に失敗しました。');
	}
}
function designTemplateSettingSaveResult() {
	if ((designTemplateSettingHttpObject.readyState == 4) && (designTemplateSettingHttpObject.status == 200)){
	    var lines	= designTemplateSettingHttpObject.responseText.cr2lf().split(LF);
	    var isError = false;
	    var error_message	= '';
	    for( var i=0; i<lines.length; i++ ){
			if( String(lines[i]).cr2lf().trim().length>0 ){
				var result	= String(lines[i]).cr2lf().trim();
				if( result == 'OK' ) {
					break;
				} else if( isError ) {
					error_message += result + "\n";
				} else {
					isError	= true;
				}
			}
		}
		if( isError ) {
			alert('保存に失敗しました!\n'+error_message);
			setTimeout(FormerCommon.displayWhiteIn, 500);
		} else {
			alert('保存が完了しました')
			setTimeout(FormerCommon.displayWhiteIn, 500);;
		}
	} else if ((designTemplateSettingHttpObject.readyState == 4) && (designTemplateSettingHttpObject.status != 200)){
		alert('適用時にサーバー通信でエラーが発生しました。');
		setTimeout(FormerCommon.displayWhiteIn, 500);
	} else {
	}
}
var designFileDeleteHttpObject;
/**
 * 削除
 */
function designFileDelete(targetUri){
	if( confirm(targetUri +'をサーバー上から削除します\n他のテンプレートで利用されている場合もありますが\nこの操作は取り消せません!\n本当に削除してよろしいですか？') ) {
		designFileDeleteHttpObject	= FormerCommon.createHttpRequest(designFileDeleteResult);
		var contents	= "command=0";
		contents	+= "&" + encodeURIComponent('target_uri')+ "="+encodeURIComponent(targetUri);
		if (designFileDeleteHttpObject) {
			FormerCommon.displayGrayOut(9999);
			designFileDeleteHttpObject.open("POST",'<?php echo SPIDER_URI_BASE.SYSTEM_DIR_NAME_ADMIN_PANEL; ?>/content/file//delete.php',true);
			designFileDeleteHttpObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
			designFileDeleteHttpObject.send(contents);
		} else {
			alert('サーバーへの接続作成に失敗しました。');
		}
	}
}
/**
 * 保存の結果に応じて次の対象エージェントHTML取得リクエストを送信します
 */
function designFileDeleteResult() {
	if ((designFileDeleteHttpObject.readyState == 4) && (designFileDeleteHttpObject.status == 200)){
	    var lines	= designFileDeleteHttpObject.responseText.cr2lf().split(LF);
	    var isError = false;
	    var error_message	= '';
	    for( var i=0; i<lines.length; i++ ){
			if( String(lines[i]).cr2lf().trim().length>0 ){
				var result	= String(lines[i]).cr2lf().trim();
				if( result == 'OK' ) {
					break;
				} else if( isError ) {
					error_message += result + "\n";
				} else {
					isError	= true;
				}
			}
		}
		if( isError ) {
			alert('削除に失敗しました!\n'+error_message);
			setTimeout(FormerCommon.displayWhiteIn, 500);
		} else {
			window.location.reload();
		}
	} else if ((designFileDeleteHttpObject.readyState == 4) && (designFileDeleteHttpObject.status != 200)){
		setTimeout(FormerCommon.displayWhiteIn, 500);
		alert('適用時にサーバー通信でエラーが発生しました。');
	} else {
	}
}
//
// パブリッシュ
//
var designTemplatePublishViewHttpObject;
function designTemplatePublishView(){
	var url = '../publish/form.php?fmt={write:design.template.setting.templateObject->'file_name'}';
	designTemplatePublishViewHttpObject = FormerCommon.createHttpRequest(designTemplatePublishViewResult);
	if (designTemplatePublishViewHttpObject) {
		FormerCommon.displayGrayOut(9999);
		designTemplatePublishViewHttpObject.open("GET",url,true);
		designTemplatePublishViewHttpObject.send(null);
	} else {
		alert('接続の作成に失敗しました。');
		FormerCommon.displayWhiteIn();
	}
}
function designTemplatePublishViewResult(){
	if ((designTemplatePublishViewHttpObject.readyState == 4) && (designTemplatePublishViewHttpObject.status == 200)){
		var bodyElements				= document.getElementsByTagName('body');
		var element 					= document.createElement('div');
		element.id						= "design-template-publish-panel";
		element.style.zIndex			= 999999;
		element.style.position			= 'absolute';
		element.style.backgroundColor	= '#ffffff';
		element.style.border			= '#808080 1px solid';
		element.innerHTML				= designTemplatePublishViewHttpObject.responseText;
		if(window.attachEvent){
			window.attachEvent('onscroll',designTemplatePublishViewResize);
			window.attachEvent('onresize',designTemplatePublishViewResize);
		}else{
			window.addEventListener('scroll',designTemplatePublishViewResize,false);
			window.addEventListener('resize',designTemplatePublishViewResize,false);
		}
		bodyElements[0].appendChild(element);
		designTemplatePublishViewResize();
	} else if ((designTemplatePublishViewHttpObject.readyState == 4) && (designTemplatePublishViewHttpObject.status != 200)){
		alert('サーバー通信でエラーが発生しました。');
		setTimeout(FormerCommon.displayWhiteIn, 1000);
	} else {
	}
}
function designTemplatePublishViewResize( e ) {
	var element		= document.getElementById('design-template-publish-panel');
	var wall		= document.getElementById('innerblock-wall');
	if( wall ) {
		wall.style.height	= '450px';
	}
	if( element ) {
		var marginTop			= 0;
		var marginLeft			= 0;
		var cWidth				= 800;
		var cHeight				= 498;
		if ( document.documentElement ) {
			marginLeft	= document.documentElement.scrollLeft + ( ( document.documentElement.clientWidth - cWidth ) / 2 );
			marginTop	= document.documentElement.scrollTop + ( (document.documentElement.clientHeight -cHeight) / 2 );
		} else {
			marginLeft	= document.body.scrollLeft + ( ( document.body.clientWidth - cWidth ) / 2 );
			marginTop	= document.body.scrollTop + ( ( document.body.clientHeight - cHeight ) / 2 );
		}
		element.style.width		= String(cWidth) + 'px';
		element.style.height	= String(cHeight) + 'px';
		element.style.left		= String(marginLeft) + 'px';
		element.style.top		= String(marginTop) + 'px';
	}
}
function designTemplatePublishViewClose() {
	var bodyElements	= document.getElementsByTagName('body');
	var element			= document.getElementById('design-template-publish-panel');
	if( element ) {
		bodyElements[0].removeChild(element);
	}
	setTimeout(FormerCommon.displayWhiteIn, 300);
}
var designTemplatePublishExecuteHttpObject;
function designTemplatePublishExecute(downloadForm) {
	designTemplatePublishExecuteHttpObject = FormerCommon.createHttpRequest(designTemplatePublishExecuteResult);
	var contents	= FormerCommon.createFormContents(downloadForm);
	if (designTemplatePublishExecuteHttpObject) {
		var url		= '../publish/validate.php?fmt={write:design.template.setting.templateObject->'file_name'}';
		FormerCommon.displayGrayOut(9999);
		designTemplatePublishExecuteHttpObject.open("POST",url,true);
		designTemplatePublishExecuteHttpObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
		designTemplatePublishExecuteHttpObject.send(contents);
	}
}
function designTemplatePublishExecuteResult() {
	if ((designTemplatePublishExecuteHttpObject.readyState == 4) && (designTemplatePublishExecuteHttpObject.status == 200)){
		var responseText	= designTemplatePublishExecuteHttpObject.responseText;
	    var lines	= responseText.cr2lf().split(LF);
	    var isError = false;
	    var errorMessages	= '';
	    for( var i=0; i<lines.length; i++ ){
			if( String(lines[i]).cr2lf().trim().length>0 ){
				var result	= String(lines[i]).cr2lf().trim();
				if( result == 'OK' ) {
					break;
				} else if( isError ) {
					errorMessages += result + "\n";
				} else {
					isError	= true;
				}
			}
		}
		if( isError ) {
			alert(errorMessages);
		} else {
			// サブミット
			if( document.templatePublishForm ) {
				document.templatePublishForm.submit();
			}
			// パネルクローズ
			setTimeout(designTemplatePublishViewClose, 500);
			setTimeout(FormerCommon.displayWhiteIn, 1000);
		}
	} else if ((designTemplatePublishExecuteHttpObject.readyState == 4) && (designTemplatePublishExecuteHttpObject.status != 200)){
		alert('サーバー通信でエラーが発生しました。');
		setTimeout(FormerCommon.displayWhiteIn, 300);
	}
}

//
// 復元
//
var designTemplateRecoverViewHttpObject;
function designTemplateRecoverView(){
	var url = '../recover/form.php?fmt={write:design.template.setting.templateObject->'file_name'}';
	designTemplateRecoverViewHttpObject = FormerCommon.createHttpRequest(designTemplateRecoverViewResult);
	if (designTemplateRecoverViewHttpObject) {
		FormerCommon.displayGrayOut(9999);
		designTemplateRecoverViewHttpObject.open("GET",url,true);
		designTemplateRecoverViewHttpObject.send(null);
	} else {
		alert('接続の作成に失敗しました。');
		FormerCommon.displayWhiteIn();
	}
}
function designTemplateRecoverViewResult(){
	if ((designTemplateRecoverViewHttpObject.readyState == 4) && (designTemplateRecoverViewHttpObject.status == 200)){
		var bodyElements				= document.getElementsByTagName('body');
		var element 					= document.createElement('div');
		element.id						= "design-template-recover-panel";
		element.style.zIndex			= 999999;
		element.style.position			= 'absolute';
		element.style.backgroundColor	= '#ffffff';
		element.style.border			= '#808080 1px solid';
		element.innerHTML				= designTemplateRecoverViewHttpObject.responseText;
		if(window.attachEvent){
			window.attachEvent('onscroll',designTemplateRecoverViewResize);
			window.attachEvent('onresize',designTemplateRecoverViewResize);
		}else{
			window.addEventListener('scroll',designTemplateRecoverViewResize,false);
			window.addEventListener('resize',designTemplateRecoverViewResize,false);
		}
		bodyElements[0].appendChild(element);
		designTemplateRecoverViewResize();
	} else if ((designTemplateRecoverViewHttpObject.readyState == 4) && (designTemplateRecoverViewHttpObject.status != 200)){
		alert('サーバー通信でエラーが発生しました。');
		setTimeout(FormerCommon.displayWhiteIn, 1000);
	} else {
	}
}
function designTemplateRecoverViewResize( e ) {
	var element		= document.getElementById('design-template-recover-panel');
	var wall		= document.getElementById('innerblock-wall');
	if( wall ) {
		wall.style.height	= '450px';
	}
	if( element ) {
		var marginTop			= 0;
		var marginLeft			= 0;
		var cWidth				= 800;
		var cHeight				= 498;
		if ( document.documentElement ) {
			marginLeft	= document.documentElement.scrollLeft + ( ( document.documentElement.clientWidth - cWidth ) / 2 );
			marginTop	= document.documentElement.scrollTop + ( (document.documentElement.clientHeight -cHeight) / 2 );
		} else {
			marginLeft	= document.body.scrollLeft + ( ( document.body.clientWidth - cWidth ) / 2 );
			marginTop	= document.body.scrollTop + ( ( document.body.clientHeight - cHeight ) / 2 );
		}
		element.style.width		= String(cWidth) + 'px';
		element.style.height	= String(cHeight) + 'px';
		element.style.left		= String(marginLeft) + 'px';
		element.style.top		= String(marginTop) + 'px';
	}
}
function designTemplateRecoverViewClose() {
	var bodyElements	= document.getElementsByTagName('body');
	var element			= document.getElementById('design-template-recover-panel');
	if( element ) {
		bodyElements[0].removeChild(element);
	}
	setTimeout(FormerCommon.displayWhiteIn, 300);
}
// テンプレプレート新規登録の妥当性検査結果エラー表示
function designTemplateRecoverError( vFileName, vViewName, vKey, vFile, message ) {
	var isError	= false;
	if( !vFileName ) {
		document.getElementById('reg_template_file_name').style.backgroundColor='#ffe0e0';
		isError	= true;
	}
	if( !vViewName ) {
		document.getElementById('reg_template_view_name').style.backgroundColor='#ffe0e0';
		isError	= true;
	}
	if( !vKey ) {
		document.getElementById('reg_template_install_key_plain').style.backgroundColor='#ffe0e0';
		isError	= true;
	}
	if( !vFile ) {
		document.getElementById('reg_template_file').style.backgroundColor='#ffe0e0';
		isError	= true;
	}
	if( isError ) {
		alert(message);
	} else {
		// execute実行
	}
}
// デザインテンプレート新規登録実行
function designTemplateRecoverExecute(templateFileName,warningMessage) {
	if( warningMessage && warningMessage.length > 0 ) {
		if( confirm(warningMessage) ) {
		} else {
			return;
		}
	}
	window.location.href='./execute.php?'+'fmt='+escape(templateFileName);
}
/**
 * 同梱ページに対するアクション
 */
function designTemplatePageAction(pageUri,actionBox) {
	if( actionBox ) {
		if( actionBox.selectedIndex == 0 ) {
			designTemplateApplyPage( '{write:design.template.setting.templateObject->'file_name'}', pageUri, true, false, designTemplateSettingPageReload );
		} else if( actionBox.selectedIndex == 1 ) {
			designTemplateApplyPage( '{write:design.template.setting.templateObject->'file_name'}', pageUri, false, true, designTemplateSettingPageReload );
		} else if( actionBox.selectedIndex == 2 ) {
			designTemplateApplyPage( '{write:design.template.setting.templateObject->'file_name'}', pageUri, true, true, designTemplateSettingPageReload );
		} else if( actionBox.selectedIndex == 3 ) {
			designTemplateApplyPage( '{write:design.template.setting.templateObject->'file_name'}', pageUri, false, 'import', designTemplateSettingPageReload );
		} else {
			window.location.href	= '../../../content/page/setting/form.php?uri='+escape(pageUri);
		}
	} else {
		alert('操作方法が正しくありません！');
	}
}
function designTemplateSettingPageReload() {
	window.location.reload();
}
//--></script>

	{/if}