<?php require_once('../../../spider.inc.php'); ?>
{template:admin_default.tpl}
{module:design.template.LoadList}
{module:content.LoadFolders}
{preset:page_title 'デザイン管理 > デザインテンプレート一覧'}

	<div class="panc">
		<a href="../../" title="管理パネルのトップページを表示します">管理パネルトップ</a>
		&gt; <a href="../" title="デザイン管理トップページを表示します">デザイン管理</a>
		&gt; デザインテンプレート管理
	</div>
	<h1>デザイン管理 &gt; デザインテンプレート管理</h1>

	<p style="width:95%;text-align:right;">
		<a href="javascript:designTemplateRecoverView()" title="デザインテンプレートファイルをアップロードして新規デザインテンプレートを登録します">&gt;&gt; デザインテンプレートを新規登録</a>
	</p>

	<table class="list" style="width:94%;">
	<thead>
	<tr>
		<th>ファイル名</th>
		<th>名称</th>
		<th style="width:20%;text-align:center;">操作</th>
	</tr>
	</thead>
	<tbody>
	{foreach:design.template.templateInfoHash templateFileName templateInfo}
	<tr{if:templateInfo->'isSetup'==false} style="background-color:#ffe0e0;"{/if}>
		<td style="font-size:20px;color:#0080aa;">
			{write:templateFileName}
			{if:templateInfo->'isSetup'==false}
			<div style="font-size:x-small;color:#ff0000;text-align:right;">
			設定が完了していません！操作の「設定」から設定してください！
			</div>
			{/if}
		</td>
		<td style="font-size:20px;color:#0080aa;">{write:templateInfo->'view_name'}</td>
		<td style="width:20%;text-align:center;white-space:nowrap;">
			<a href="./setting/form.php?fmt={write:urlencode(templateFileName)}">設定</a>
			・
			{if:templateInfo->'html_edit'}
			<a href="./html/form.php?fmt={write:urlencode(templateFileName)}">HTML</a>
			{else}
			HTML
			{/if}
			・
			<a href="javascript:designTemplateLoadRelatedPagePanel('{write:templateFileName}',null)">適用</a>
			・
			{if:templateFileName=='default.fmt'}
			<span style="color:#a0a0a0;">削除</a>
			{else}
			<a href="javascript:designTemplateDelete('{write:templateFileName}');">削除</a>
			{/if}
		</td>
	</tr>
	{/foreach}
	</tbody>
	</table>
	
	<form name="sform" action="./index.php" method="get">
	<div id="design-tpl-apply-folder-select" style="display:none;visibility:hidden;">
	<select name="ccurf">
	{foreach:content.folderArray folderPath}{if:preg_match('/^\\/js/',folderPath)==0 && preg_match('/^\\/upload/',folderPath)==0 && preg_match('/^\\/file/',folderPath)==0}
		<option value="{write:folderPath}"
			{if:content.currentFoloder==folderPath} selected{/if}
			>{write:folderPath}</option>
	{/if}{/foreach}
	</select>
	</div>
	</form>

<script language="JavaScript" type="text/javascript"><!--
var designTemplateDeleteHttpObject;
function designTemplateDelete(fileName) {
	if( fileName == 'default.fmt' ) {
		alert('標準テンプレートは削除できません!');
		return;
	}
	if( confirm(fileName+'を削除します。\nこの操作は取り消せません！\n本当に削除してもよろしいですか？') ) {
		designTemplateDeleteHttpObject	= FormerCommon.createHttpRequest(designTemplateDeleteResult);
		var contents	= "command=0";
		contents	+= "&" + encodeURIComponent('file_name')+ "="+encodeURIComponent(fileName);
		if (designTemplateDeleteHttpObject) {
			FormerCommon.displayGrayOut(9999);
			designTemplateDeleteHttpObject.open("POST",'./delete.php',true);
			designTemplateDeleteHttpObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
			designTemplateDeleteHttpObject.send(contents);
		} else {
			alert('サーバーへの接続作成に失敗しました。');
		}
	}
}
function designTemplateDeleteResult() {
	if ((designTemplateDeleteHttpObject.readyState == 4) && (designTemplateDeleteHttpObject.status == 200)){
	    var lines	= designTemplateDeleteHttpObject.responseText.cr2lf().split(LF);
	    var isError = false;
	    var error_message	= '';
	    for( var i=0; i<lines.length; i++ ){
			if( String(lines[i]).cr2lf().trim().length>0 ){
				var result	= String(lines[i]).cr2lf().trim();
				if( result == 'OK' ) {
					break;
				} else if( isError ) {
					error_message += result + "\n";
				} else {
					isError	= true;
				}
			}
		}
		if( isError ) {
			alert('削除に失敗しました!\n'+error_message);
			setTimeout(FormerCommon.displayWhiteIn, 500);
		} else {
			window.location.reload();
		}
	} else if ((designTemplateDeleteHttpObject.readyState == 4) && (designTemplateDeleteHttpObject.status != 200)){
		setTimeout(FormerCommon.displayWhiteIn, 500);
		alert('適用時にサーバー通信でエラーが発生しました。');
	} else {
	}
}

//
// テンプレート新規登録
//
var designTemplateRecoverViewHttpObject;
function designTemplateRecoverView(){
	var url = './recover/form.php';
	designTemplateRecoverViewHttpObject = FormerCommon.createHttpRequest(designTemplateRecoverViewResult);
	if (designTemplateRecoverViewHttpObject) {
		FormerCommon.displayGrayOut(9999);
		designTemplateRecoverViewHttpObject.open("GET",url,true);
		designTemplateRecoverViewHttpObject.send(null);
	} else {
		alert('接続の作成に失敗しました。');
		FormerCommon.displayWhiteIn();
	}
}
function designTemplateRecoverViewResult(){
	if ((designTemplateRecoverViewHttpObject.readyState == 4) && (designTemplateRecoverViewHttpObject.status == 200)){
		var bodyElements				= document.getElementsByTagName('body');
		var element 					= document.createElement('div');
		element.id						= "design-template-recover-panel";
		element.style.zIndex			= 999999;
		element.style.position			= 'absolute';
		element.style.backgroundColor	= '#ffffff';
		element.style.border			= '#808080 1px solid';
		element.innerHTML				= designTemplateRecoverViewHttpObject.responseText;
		if(window.attachEvent){
			window.attachEvent('onscroll',designTemplateRecoverViewResize);
			window.attachEvent('onresize',designTemplateRecoverViewResize);
		}else{
			window.addEventListener('scroll',designTemplateRecoverViewResize,false);
			window.addEventListener('resize',designTemplateRecoverViewResize,false);
		}
		bodyElements[0].appendChild(element);
		designTemplateRecoverViewResize();
	} else if ((designTemplateRecoverViewHttpObject.readyState == 4) && (designTemplateRecoverViewHttpObject.status != 200)){
		alert('サーバー通信でエラーが発生しました。');
		setTimeout(FormerCommon.displayWhiteIn, 1000);
	} else {
	}
}
function designTemplateRecoverViewResize( e ) {
	var element		= document.getElementById('design-template-recover-panel');
	var wall		= document.getElementById('innerblock-wall');
	if( wall ) {
		wall.style.height	= '450px';
	}
	if( element ) {
		var marginTop			= 0;
		var marginLeft			= 0;
		var cWidth				= 800;
		var cHeight				= 498;
		if ( document.documentElement ) {
			marginLeft	= document.documentElement.scrollLeft + ( ( document.documentElement.clientWidth - cWidth ) / 2 );
			marginTop	= document.documentElement.scrollTop + ( (document.documentElement.clientHeight -cHeight) / 2 );
		} else {
			marginLeft	= document.body.scrollLeft + ( ( document.body.clientWidth - cWidth ) / 2 );
			marginTop	= document.body.scrollTop + ( ( document.body.clientHeight - cHeight ) / 2 );
		}
		element.style.width		= String(cWidth) + 'px';
		element.style.height	= String(cHeight) + 'px';
		element.style.left		= String(marginLeft) + 'px';
		element.style.top		= String(marginTop) + 'px';
	}
}
function designTemplateRecoverViewClose() {
	var bodyElements	= document.getElementsByTagName('body');
	var element			= document.getElementById('design-template-recover-panel');
	if( element ) {
		bodyElements[0].removeChild(element);
	}
	setTimeout(FormerCommon.displayWhiteIn, 300);
}
// テンプレプレート新規登録の妥当性検査結果エラー表示
function designTemplateRecoverError( vFileName, vViewName, vKey, vFile, reqAccount, message ) {
	var isError	= false;
	if( !vFileName ) {
		document.getElementById('reg_template_file_name').style.backgroundColor='#ffe0e0';
		isError	= true;
	}
	if( !vViewName ) {
		document.getElementById('reg_template_view_name').style.backgroundColor='#ffe0e0';
		isError	= true;
	}
	if( !vKey ) {
		document.getElementById('reg_template_install_key_plain').style.backgroundColor='#ffe0e0';
		var panel	= document.getElementById('reg_template_install_key_plain_area');
		if( panel ) {
			panel.style.display	= 'block';
			panel.style.visibility	= 'visible';
			panel.style.position	= 'static';
		}
		isError	= true;
	}
	if( !vFile ) {
		document.getElementById('reg_template_file').style.backgroundColor='#ffe0e0';
		isError	= true;
	}
	if( !reqAccount ) {
		var panel	= document.getElementById('reg_template_auth_area');
		if( panel ) {
			panel.style.display	= 'block';
			panel.style.visibility	= 'visible';
			panel.style.position	= 'static';
		}
		document.getElementById('reg_template_auth_id').style.backgroundColor='#ffe0e0';
		document.getElementById('reg_template_auth_password').style.backgroundColor='#ffe0e0';
		isError	= true;
	}
	if( isError ) {
		alert(message);
	} else {
		// execute実行
	}
}
// デザインテンプレート新規登録実行
function designTemplateRecoverExecute(templateFileName,warningMessage) {
	if( warningMessage && warningMessage.length > 0 ) {
		if( confirm(warningMessage + '\n\n正常に利用できない場合もありますがインストールを実行しますか？') ) {
		} else {
			return;
		}
	}
	window.location.href='./execute.php?'+'fmt='+escape(templateFileName);
}
/** 対象テンプレートの関連ページパネルを読み込みます	*/
var designTemplatePagesHttpObject;
function designTemplateLoadRelatedPagePanel(templateFileName,callbackFunc) {
	var uri	= '<?php echo SPIDER_URI_BASE.SYSTEM_DIR_NAME_ADMIN_PANEL; ?>/design/template/setting/ajax_related_pages.php?'
		+'fmt='+escape(templateFileName);
	var formBlock	= document.createElement('div');
	// パネルブロックの追加
	FormerCommon.displayGrayOut(999);
	formBlock.callbackFunc	= callbackFunc;
	formBlock.id	= 'design-template-related-pages-innerblock';
	formBlock.style.backgroundColor	= "#ff0000";
	formBlock.style.width			= '800px';
	formBlock.style.zIndex			= '9999';
	formBlock.style.position		= 'absolute';
	formBlock.style.left			= ( ( FormerCommon.getPageWidth()/2 ) - 400 ) + 'px';
	if(window.attachEvent){
		window.attachEvent('onscroll',designTemplateViewRelatedPagesResize);
	}else{
		window.addEventListener('scroll',designTemplateViewRelatedPagesResize,false);
	}
	var bodyTags 	= document.getElementsByTagName('body');
	bodyTags[0].appendChild(formBlock);

	designTemplatePagesHttpObject	= FormerCommon.createHttpRequest(designTemplateLoadRelatedPagePanelResult);
	designTemplatePagesHttpObject.targetBlock	= formBlock;
	if( designTemplatePagesHttpObject ) {
		designTemplatePagesHttpObject.open("GET",uri,true);
		designTemplatePagesHttpObject.send(null);
	} else {
		alert('サーバー通信作成に失敗しました!');
	}	
}
function designTemplateLoadRelatedPagePanelResult() {
	if ((designTemplatePagesHttpObject.readyState == 4) && (designTemplatePagesHttpObject.status == 200)){
		if( designTemplatePagesHttpObject.targetBlock ) {
			designTemplatePagesHttpObject.targetBlock.innerHTML	= designTemplatePagesHttpObject.responseText;
		}
	} else if ((designTemplatePagesHttpObject.readyState == 4) && (designTemplatePagesHttpObject.status != 200)){
		alert('関連ページ情報の取得に失敗しました!');
	}
}
function designTemplateViewRelatedPagesResize() {
	var formBlock	= document.getElementById('design-template-related-pages-innerblock');
	if( formBlock ) {
		if ( document.documentElement.clientHeight ) {
			formBlock.style.top	= ((document.documentElement.clientHeight-formBlock.offsetHeight)/2 + document.documentElement.scrollTop)+'px';
		} else {
			formBlock.style.top	= ((document.body.clientHeight-formBlock.offsetHeight)/2 + document.body.scrollTop) + 'px';
		}
	}
}
function designTemplateViewRelatedPagesClose() {
	var formBlock	= document.getElementById('design-template-related-pages-innerblock');
	var bodyTags 	= document.getElementsByTagName('body');
	if( formBlock ) {
		if( formBlock.callbackFunc ) {
			var funcType	= typeof(formBlock.callbackFunc);
			if( 'function' == funcType ) {
				formBlock.callbackFunc();
			} else if( 'string' == funcType ) {
				eval(formBlock.callbackFunc);
			}
		}
		bodyTags[0].removeChild(formBlock);
	}
	FormerCommon.displayWhiteIn();
}

/** 適用中の配列インデックス	*/
var designTemplateApplyArrayIndex		= 0;
/** ページオブジェクト配列	*/
var designTemplateApplyPageObjectArray	= new Array();
/** ページHTMLを適用するページURI一覧	*/
var designTemplateApplyHtmlPageUriArray	= new Array();
/** 適用対象テンプレートファイル名	*/
var designTemplateApplyCurrentFileName;
/**
 * 全ページテンプレート適用開始
 */
function designTemplateApplyAllPages(templateFileName) {
	// HTML適用ページ内容の取り出し
	designTemplateApplyHtmlPageUriArray	= new Array();
	var inputTags 	= document.getElementsByTagName('input');
	for(var i=0,n=inputTags.length;i<n;i++) {
		var tagObj		= inputTags[i];
		var itemtype	= tagObj.type;
		if( tagObj.type == 'checkbox' && tagObj.name == 'related_pages' && tagObj.checked ) {
			designTemplateApplyHtmlPageUriArray.push(tagObj.value);
		}
	}
	// 同梱ページパネルを閉じる
	var formBlock	= document.getElementById('design-template-related-pages-innerblock');
	var bodyTags 	= document.getElementsByTagName('body');
	if( formBlock ) {
		if( formBlock.callbackFunc ) {
			var funcType	= typeof(formBlock.callbackFunc);
			if( 'function' == funcType ) {
				formBlock.callbackFunc();
			} else if( 'string' == funcType ) {
				eval(formBlock.callbackFunc);
			}
		}
		bodyTags[0].removeChild(formBlock);
	}
	if( confirm('サイトの全ページのデザインテンプレートを変更します。\n'
			+ 'サイト内のページを全て読み込む為、この処理は時間がかかる場合があります。\n'
			+ '実行してよろしいですか？') ) {
		designTemplateApplyCurrentFileName	= templateFileName;
		document.sform.ccurf.selectedIndex	= 0;
		designTemplateApplyPageObjectArray	= new Array();
		FormerCommon.displayGrayOut(9999);
		designTemplateGetPageList();
	}
}
/**
 * ページ一覧を読み込み
 */
function designTemplateGetPageList() {
	contentGetContentList(
		document.sform.ccurf.options[document.sform.ccurf.selectedIndex].value,
		designTemplateGetPageListResult);
}
/**
 * 読み込んだページ一覧を配列に追加
 */
function designTemplateGetPageListResult(contentObjectArray) {
	for( var num=0; num<contentObjectArray.length; num++ ) {
		var contentObject	= contentObjectArray[num];
		if( contentObject.type == 'spider-dynamic' ) {
			designTemplateApplyPageObjectArray.push(contentObject);
		}
	}
	FormerCommon.displayGrayoutMessage(
			String(document.sform.ccurf.selectedIndex+1)+'/'+document.sform.ccurf.length + 'フォルダを読み込みました...'
		);
	if( document.sform.ccurf.length - 1 > document.sform.ccurf.selectedIndex ) {
		// 残りがあるなら再実行
		document.sform.ccurf.selectedIndex++;
		designTemplateGetPageList();
	} else {
		// 最後まで実行したら適用処理に進む
		designTemplateApplyArrayIndex	= 0;
		designTemplateApplyAllExecute();
	}
}
/**
 * 表示中の全てのページに適用実行
 */
function designTemplateApplyAllExecute() {
	FormerCommon.displayGrayoutMessage(
			designTemplateApplyArrayIndex+'/'+String(designTemplateApplyPageObjectArray.length)+'ファイルにデザインテンプレートを適用しました...'
		);
	if( designTemplateApplyArrayIndex < designTemplateApplyPageObjectArray.length ) {
		// 残りページがある
		var contentObject	= designTemplateApplyPageObjectArray[designTemplateApplyArrayIndex];
		if( contentObject ) {
			var fileUri	= contentObject.folder+'/'+contentObject.name;
			if( contentObject.folder == '/' ) {
				fileUri	= contentObject.folder+contentObject.name;
			}
			// ページHTML適用対象か確認
			var applyPageHtml	= false;
			for( var num=0; num < designTemplateApplyHtmlPageUriArray.length; num++ ) {
				if( fileUri == designTemplateApplyHtmlPageUriArray[num] ) {
					applyPageHtml	= true;
				}
			}
			// デザイン適用
			designTemplateApplyArrayIndex++;
			designTemplateApplyPage( designTemplateApplyCurrentFileName, fileUri, true, applyPageHtml, designTemplateApplyAllExecute );
		}
	} else {
		// 完了
		designTemplateApplyArrayIndex	= 0;
		setTimeout(FormerCommon.displayWhiteIn, 100);
		alert('デザインテンプレートを適用しました。');
	}
}
//--></script>