<?php
$nativeErrors	= array();
if( !is_writable('./spider/data') ) {
	array_push($nativeErrors, 'spider/dataフォルダ内にフォルダ・ファイルを作成できるようにパーミッションを設定してください。');
}
if( !is_writable('./spider/work') ) {
	array_push($nativeErrors, 'spider/workフォルダ内にフォルダ・ファイルを作成できるようにパーミッションを設定してください。');
}
if( count($nativeErrors) == 0 ) {
	require_once('./spider.inc.php');
}
?>
<?php echo '<?xml version="1.0" encoding="UTF-8"?>'; ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
        "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="ja" xml:lang="ja">
<head>
	<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
	<meta http-equiv="Content-Script-Type" content="text/javascript" />
	<meta http-equiv="Content-Style-Type" content="text/css" />
	<title><?php echo RELEASE_NAME; ?> installer</title>
<script language="JavaScript" type="text/javascript"><!--
function getEnv() {
	var realUrlElm	= document.getElementById('real-url');
	var autoUrlElm	= document.getElementById('auto-url');
	var urlMsgElm	= document.getElementById('url-message');
	if( realUrlElm && autoUrlElm ) {
		var realUrl	= window.location.href;
		realUrl		= realUrl.substring(0, realUrl.length - String('<?php echo basename($_SERVER['SCRIPT_FILENAME']); ?>').length );
		realUrlElm.innerHTML	= realUrl;
		var autoUrl	= autoUrlElm.innerHTML;
		if( realUrl != autoUrl ) {
			urlMsgElm.innerHTML = '設置URLの自動判断が正しくできませんでした。';
			urlMsgElm.style.color = '#ff0000';
		} else {
			urlMsgElm.innerHTML = '設置URLの自動取得に成功しています。<br />'
				+'アクセス可能なURLが複数ある場合(共有SSLやドメインが異なるなど)は他のURLでもアクセス可能か確認してください。';
			urlMsgElm.style.color = '#0000ff';
		}
	}
}
if(window.attachEvent){
	window.attachEvent('onload',getEnv);
}else{
	window.addEventListener('DOMContentLoaded',getEnv,false);
}
//--></script>
<style type="text/css">
body {
	padding: 0px;
	margin: 0px;
	background-color: #008000;
	font-size: small;
	line-height: 1.5em;
}
#container {
	width: 960px;
	margin: 0 auto;
	background-color: #ffffff;
}
#header {
	padding: 5px;
}
#contents {
	padding: 15px;
}
#contents h1, #contents h2, #contents h3 {
	border-bottom: solid 1px;
}
#footer {
	border-top: solid 1px #909090;
	padding: 5px;
	text-align: right;
}
table {
}
.view-url {
	padding: 5px 6em 5px 24px;;
	border: solid 1px #fff000;
	background-color: #fff9d0;
	border: solid 5px #ffffff;
}
.msg-enable {
	color: #0000ff;
}
.msg-error {
	color: #ff0000;
}
pre {
	line-height: 1.4em;
	border: solid 1px #808080;
	background-color: #e0e0e0;
	padding: 5px;
	font-size: 12px;
	font-family: monospace;
}
</style>
</head>
<body><div id="container">
	<div id="header">
		<div style="float:right;width:50%;text-align:right;font-size:16px;font-weight:bold;text-decoration:underline;">
			インストールチェックスクリプト
		</div>
		<img alt="<?php echo RELEASE_NAME; ?> installer" src="./<?php echo SYSTEM_DIR_NAME_ADMIN_PANEL.'/'.RELEASE_MAIN_PACKAGE; ?>/images/logo_01.jpg"><br />
	</div>
	<div id="contents">
		<?php if( count($nativeErrors) == 0 ) { $isGlobalErrors	= false; ?>
		<p>
			<?php echo RELEASE_NAME; ?>が動作するようにアップロードされているか設置状況を確認し、
			赤字のエラーメッセージがでている場合は問題を解決してください。<br />
			<span style="color:#803030;font-weight:bold;">※インストールが完了したらこのファイル(checkinstall.php)はサーバー上から削除してください。</span>
		</p>
		<h3>設置URL</h3>
		<table>
		<tbody>
		<tr>
			<td>自動判断したURL:</td>
			<td class="view-url" id="real-url"><?php echo SPIDER_URL_BASE; ?></td>
		</tr>
		<tr>
			<td>実際の設置URL:</td>
			<td class="view-url" id="auto-url"><?php echo SPIDER_URL_BASE; ?></td>
		</tr>
		</tbody>
		</table>
		
		<p id="url-message"></p>
		
		<h3>パーミッション環境</h3>
		<?php
			$thisPageFilePath	= realpath($_SERVER['SCRIPT_FILENAME']);
			$execUser	= '';
			$execGroup	= '';
			$ownerUser	= fileowner($thisPageFilePath);
			$ownerGroup	= filegroup($thisPageFilePath);
			$checkFile	= DIR_PATH_WORK.'/check';
			if( @touch($checkFile) ) {
				$execUser	= fileowner($checkFile);
				$execUser	= filegroup($checkFile);
				@unlink($checkFile);
			}
		?>
		<p>
			実行者 = <?php echo $execUser; ?>
			&nbsp; / &nbsp;
			所有者 = <?php echo $ownerUser; ?>
		</p>
		<?php if( $execUser == $ownerUser ) { ?>
		<p class="msg-enable">設置フォルダ内にファイルやフォルダを作成することができます。</p>
		<?php } else { ?>
			<?php if( !is_writable(dirname($thisPageFilePath)) || !is_executable(dirname($thisPageFilePath)) ) { $isGlobalErrors =true; ?>
				<p class="msg-error">インストールするには設置フォルダを書込・実行可能に設定してください。</p>
			<?php } else { ?>
				<p class="msg-enable">設置フォルダ内にファイルやフォルダを作成することができます。</p>
			<?php } ?>
		<?php } ?>
			
		<h4>実行ファイル作成のパーミッションチェック</h4>
		<?php if( @include_once(DIR_PATH_LIB.'/util/HttpRequest.class.php') ) { ?>
			<?php
				$errors	= array();
				$requireExtPermittionCheck	= false;
				$checkExecFilePath			= preg_replace('/\\/$/','',realpath(SPIDER_BASE_PATH)).'/check.php';
				$checkExecFileUrl			= SPIDER_URL_BASE.'check.php';
				if( @copy($thisPageFilePath, $checkExecFilePath) ) {
					@chmod($checkExecFilePath, SPIDER_PERMITTION_PUBLIC_FILE);
					// コピーして作成したファイルにアクセスしてみる
					$httpRequest	= new util_HttpRequest($checkExecFileUrl,'get');
					if( $httpRequest->send(null,30) ) {
						if( $httpRequest->statusCode != 200 ) {
							array_push($errors, 'プログラムで生成したphpファイルへのアクセスでエラーが発生しています。 ERROR='.$httpRequest->statusCode.' '.$httpRequest->statusMessage.'<br />'
								.'spider/unique_setting.inc.phpをテキストエディタで開いてSPIDER_PERMITTION_PUBLIC_FILEの値を調整してからアップロードしてください。');
							$requireExtPermittionCheck	= true;
						}
					} else {
						array_push($errors, 'サーバーでHTTP通信をおこなうことができませんでした。');
					}
					@unlink($checkExecFilePath);
				} else {
					array_push($errors, '設置フォルダ内にファイルを作成できません。設置フォルダのパーミッションを確認してください。');
				}
				if( count($errors) > 0 ) {
					$isGlobalErrors	= true;
			?>
				<p class="msg-error">
				<?php foreach( $errors as $error ) { ?>
					<?php echo $error; ?><br />
				<?php } ?>
				</p>
				<?php if( $requireExtPermittionCheck ) { ?>
				<!-- TODO: 次バージョンで追加パーミッション確認	-->
				<p class="msg-error">
					このサーバーでは、<?php echo RELEASE_NAME; ?>初期のphpファイル作成時のパーミッション設定( <?php printf('%03o',SPIDER_PERMITTION_PUBLIC_FILE); ?> )でphpファイルを実行できないようです。
					<br />
					解決するには、<span style="font-weight:bold;">[設置フォルダ]/spider/unique_setting.inc.php</span> ファイルをテキストエディタで開いて<br />
					下記のファイル作成パーミッションの設定を修正してサーバーにアップしなおしてください。<br />
				</p>
<div>修正箇所) unique_setting.inc.php &nbsp; 24行目: 0666をそれぞれホスティング会社指定の動作可能なパーミッションに変更してください。</div>
<pre style="margin-top:0px;">
/** プログラム生成ファイルパーミッション: 公開フォルダ以下のphpファイル	*/
define('SPIDER_PERMITTION_PUBLIC_FILE',<span style="color:#0000ff;font-weight:bold;">0666</span>);
</pre>			
<br />

				<?php } ?>
			<?php } else { ?>
				<p class="msg-enable">ファイル作成パーミッション設定を変更する必要はありません。</p>
			<?php } ?>


			<h4>実行ファイル配置フォルダのパーミッションチェック</h4>
			<?php
				$errors	= array();
				$requireExtPermittionCheck	= false;
				$checkExecFolderPath	= preg_replace('/\\/$/','',realpath(SPIDER_BASE_PATH)).'/check';
				$checkExecFilePath		= $checkExecFolderPath.'/check.php';
				if( file_exists($checkExecFolderPath) ) {
					if( file_exists( $checkExecFilePath ) ) {
						@unlink($checkExecFilePath);
					}
					@rmdir($checkExecFolderPath);
				}
				if( @mkdir($checkExecFolderPath, SPIDER_PERMITTION_PUBLIC_FOLDER) ) {
					@chmod($checkExecFolderPath, SPIDER_PERMITTION_PUBLIC_FOLDER);
					if( @copy(realpath(SPIDER_BASE_PATH.'/checkinstall.php'), $checkExecFilePath)) {
						@chmod($checkExecFilePath, SPIDER_PERMITTION_PUBLIC_FILE);
						// コピーして作成したファイルにアクセスしてみる
						$httpRequest	= new util_HttpRequest(SPIDER_URL_BASE.'check/check.php','get');
						if( $httpRequest->send(null,30) ) {
							if( $httpRequest->statusCode != 200 ) {
								array_push($errors, 'プログラムで生成したphpファイルへのアクセスでエラーが発生しています。 ERROR='.$httpRequest->statusCode.' '.$httpRequest->statusMessage.'<br />'
									.'spider/unique_setting.inc.phpをテキストエディタで開いてSPIDER_PERMITTION_PUBLIC_FOLDERの値を調整してからアップロードしてください。');
								$requireExtPermittionCheck	= true;
							}
						} else {
							array_push($errors, 'サーバーでHTTP通信をおこなうことができませんでした。');
						}
						@unlink($checkExecFilePath);
					}
					@rmdir($checkExecFolderPath);
				} else {
					array_push($errors, '設置フォルダ内にフォルダを作成できません。設置フォルダを書込・実行可能に設定してください。');
				}
				if( count($errors) > 0 ) {
					$isGlobalErrors	= true;
			?>
				<p class="msg-error">
				<?php foreach( $errors as $error ) { ?>
					<?php echo $error; ?><br />
				<?php } ?>
				</p>
				<?php if( $requireExtPermittionCheck ) { ?>
				<!-- TODO: 次バージョンで追加パーミッション確認	-->
				<p class="msg-error">
					このサーバーでは、<?php echo RELEASE_NAME; ?>初期のphp配置フォルダ作成時のパーミッション設定( <?php printf('%03o',SPIDER_PERMITTION_PUBLIC_FOLDER); ?> )でphpファイルを実行できないようです。
					<br />
					解決するには、<span style="font-weight:bold;">[設置フォルダ]/spider/unique_setting.inc.php</span> ファイルをテキストエディタで開いて<br />
					ファイル作成パーミッションの設定を修正してサーバーにアップしなおしてください。<br />
				</p>
<div>修正箇所) unique_setting.inc.php &nbsp; 26行目: 0777をそれぞれホスティング会社指定の動作可能なパーミッションに変更してください。</div>
<pre style="margin-top:0px;">
/** プログラム生成ファイルパーミッション: 公開フォルダ以下のフォルダ	*/
define('SPIDER_PERMITTION_PUBLIC_FOLDER',<span style="color:#0000ff;font-weight:bold;">0777</span>);
</pre>			
				
				<?php } ?>
			<?php } else { ?>
				<p class="msg-enable">フォルダ作成パーミッション設定を変更する必要はありません。</p>
			<?php } ?>
			
		<?php } else { ?>
			<p class="msg-error">通信ライブラリ読み込みに失敗しました。実行ファイル作成パーミッションチェックを行えませんでした。</p>
		<?php } ?>
		
		<h4>アプリケーションデータフォルダ</h4>
		<?php
			$isWritableData		= is_writable(DIR_PATH_DATA);
			$isWritablelib		= is_writable(DIR_PATH_LIB);
			$isWritablePages	= is_writable(DIR_PATH_PAGES);
			$isWritableWidgets	= is_writable(DIR_PATH_WIDGETS);
			$isWritableTmplates	= is_writable(DIR_PATH_TEMPLATES);
			$isWritableWork		= is_writable(DIR_PATH_WORK);
		?>
		<table>
		<tbody>
		<tr>
			<td class="view-url"><?php echo DIR_PATH_DATA; ?></td>
			<?php if( $isWritableData ) { ?>
			<td class="view-url" style="background-color:#a0a0ff;">OK</td>
			<?php } else { $isGlobalErrors = true; ?>
			<td class="view-url" style="background-color:#ffa0a0;">NG</td>
			<?php } ?>
		</tr>
		<tr>
			<td class="view-url"><?php echo DIR_PATH_LIB; ?></td>
			<?php if( $isWritablelib ) { ?>
			<td class="view-url" style="background-color:#a0a0ff;">アップデートを利用できると思われます</td>
			<?php } else { ?>
			<td class="view-url" style="background-color:#ffffa0;">アップデートを利用できません</td>
			<?php } ?>
		</tr>
		<tr>
			<td class="view-url"><?php echo DIR_PATH_PAGES; ?></td>
			<?php if( $isWritablePages ) { ?>
			<td class="view-url" style="background-color:#a0a0ff;">OK</td>
			<?php } else { $isGlobalErrors	= true; ?>
			<td class="view-url" style="background-color:#ffa0a0;">NG</td>
			<?php } ?>
		</tr>
		<tr>
			<td class="view-url"><?php echo DIR_PATH_WIDGETS; ?></td>
			<?php if( $isWritableWidgets ) { ?>
			<td class="view-url" style="background-color:#a0a0ff;">OK</td>
			<?php } else { $isGlobalErrors = true; ?>
			<td class="view-url" style="background-color:#ffa0a0;">NG</td>
			<?php } ?>
		</tr>
		<tr>
			<td class="view-url"><?php echo DIR_PATH_TEMPLATES; ?></td>
			<?php if( $isWritableTmplates ) { ?>
			<td class="view-url" style="background-color:#a0a0ff;">OK</td>
			<?php } else { $isGlobalErrors = true; ?>
			<td class="view-url" style="background-color:#ffa0a0;">NG</td>
			<?php } ?>
		</tr>
		<tr>
			<td class="view-url"><?php echo DIR_PATH_WORK; ?></td>
			<?php if( $isWritableWork ) { ?>
			<td class="view-url" style="background-color:#a0a0ff;">OK</td>
			<?php } else { $isGlobalErrors	= true; ?>
			<td class="view-url" style="background-color:#ffa0a0;">NG</td>
			<?php } ?>
		</tr>
		</tbody>
		</table>
		
		<h3>自動判断した実行環境</h3>
		<table>
		<tbody>
		<tr>
			<td>SPIDER_ORG_URL_DOC</td>
			<td class="view-url"><?php echo SPIDER_ORG_URL_DOC; ?></td>
		</tr>
		<tr>
			<td>SPIDER_ORG_URL_BASE</td>
			<td class="view-url"><?php echo SPIDER_ORG_URL_BASE; ?></td>
		</tr>
		<tr>
			<td>SPIDER_ORG_URL_REQUEST</td>
			<td class="view-url"><?php echo SPIDER_ORG_URL_REQUEST; ?></td>
		</tr>
		<tr>
			<td>SPIDER_ORG_URI_BASE</td>
			<td class="view-url"><?php echo SPIDER_ORG_URI_BASE; ?></td>
		</tr>
		<tr>
			<td>SPIDER_ORG_URI_REQUEST</td>
			<td class="view-url"><?php echo SPIDER_ORG_URI_REQUEST; ?></td>
		</tr>


		<tr>
			<td>SPIDER_URL_DOC</td>
			<td class="view-url"><?php echo SPIDER_URL_DOC; ?></td>
		</tr>
		<tr>
			<td>SPIDER_URL_BASE</td>
			<td class="view-url"><?php echo SPIDER_URL_BASE; ?></td>
		</tr>
		<tr>
			<td>SPIDER_URL_REQUEST</td>
			<td class="view-url"><?php echo SPIDER_URL_REQUEST; ?></td>
		</tr>
		<tr>
			<td>SPIDER_URI_BASE</td>
			<td class="view-url"><?php echo SPIDER_URI_BASE; ?></td>
		</tr>
		<tr>
			<td>SPIDER_URI_REQUEST</td>
			<td class="view-url"><?php echo SPIDER_URI_REQUEST; ?></td>
		</tr>


		<tr>
			<td>SPIDER_URI_APP</td>
			<td class="view-url"><?php echo SPIDER_URI_APP; ?></td>
		</tr>
		<tr>
			<td>DIR_PATH_SPIDER</td>
			<td class="view-url"><?php echo DIR_PATH_SPIDER; ?></td>
		</tr>

		</tbody>
		</table>
		
		<? } else { $isGlobalErrors = true; ?>
		<h3 style="color:#ff0000;">設置パーミッションに問題があります</h3>
		<p style="color:#ff0000;">
		<?php foreach( $nativeErrors as $error ) { ?>
			<?php echo $error; ?><br />
		<?php } ?>
		</p>
		<?php } ?>
		
		<h3>管理パネル</h3>
		<p>
			<?php if( $isGlobalErrors ) { ?>
				<span style="color:#ff0000;">設置状況に問題がある為管理パネルにアクセスできません。</span>
			<?php } else { ?>
				<input type="button" value="管理パネルへ" onclick="window.location.href='./<?php echo SYSTEM_DIR_NAME_ADMIN_PANEL; ?>/loginform.php';" />
			<?php } ?>
		</p>
	</div>
	<div id="footer">
		<a href="http://sourceforge.jp/projects/shopformer/" target="_blank">MDS Tools Software Install Check Script.</a><br />
		CopyRight(C)2010. Development Section. <a href="http://sourceforge.jp/projects/shopformer/" target="_blank">Shopformer Development Team.</a> All Right Reserved.
	</div>
</div></body>
</html>