﻿//
// App.xaml.h
// App クラスの宣言。
//

#pragma once

#include "App.g.h"
#include "MainPage.xaml.h"
#include "GameMain.h"
#include "SoundDriver.h"
#include "BasicTimer.h"

namespace ShootingGame
{
  /// <summary>
  /// 既定の Application クラスを補完するアプリケーション固有の動作を提供します。
  /// </summary>
  ref class App sealed
  {
  public:
    App();
    virtual void OnLaunched(Windows::ApplicationModel::Activation::LaunchActivatedEventArgs^ pArgs) override;

    Windows::UI::Xaml::Controls::SwapChainBackgroundPanel^ App::SwapChainBackGrroundPanel()
    {
      return mainPage_->SwapChainBackgroundPanel();
    }

   private:
    MainPage^ mainPage_;
    GameMain^ gameMain_;
    BasicTimer^ timer_;
    Windows::Foundation::EventRegistrationToken         eventToken_;
    void OnSuspending(
      _In_ Platform::Object^ sender,
      _In_ Windows::ApplicationModel::SuspendingEventArgs^ args
      );

    void OnResuming(
      _In_ Platform::Object^ sender,
      _In_ Platform::Object^ args
      );

    void OnWindowActivationChanged(
      _In_ Platform::Object^ sender,
      _In_ Windows::UI::Core::WindowActivatedEventArgs^ args
      );

    void OnWindowSizeChanged(
      _In_ Windows::UI::Core::CoreWindow^ sender,
      _In_ Windows::UI::Core::WindowSizeChangedEventArgs^ args
      );

    void OnLogicalDpiChanged(
      _In_ Platform::Object^ sender
      );

    void OnRendering(
      _In_ Object^ sender, 
      _In_ Object^ args
      );
    void OnPointerPressed(
      _In_ Windows::UI::Core::CoreWindow^ sender,
      _In_ Windows::UI::Core::PointerEventArgs^ args
      );
		void OnPointerReleased(
			_In_ Windows::UI::Core::CoreWindow^ sender,
			_In_ Windows::UI::Core::PointerEventArgs^ args
			);
		void OnPointerMoved(
			_In_ Windows::UI::Core::CoreWindow^ sender,
			_In_ Windows::UI::Core::PointerEventArgs^ args
			);

  };
}
