////// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
//// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
//// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
//// PARTICULAR PURPOSE.
////
//// Copyright (c) Microsoft Corporation. All rights reserved

#pragma once

#include "DirectXBase.h"
#include "SampleOverlay.h"
#include "AutoThrottle.h"
#include "BasicSprites.h"
#include "BasicLoader.h"
#include "GameStateMachine.h"
#include "SoundManager.h"

namespace ShootingGame {
  

  struct CharacterData
  {
    float2 pos;
    float2 vel;
    float rot;
    float rotVel;
    float scale;
  };

//  ref class MainPage;
  
  ref class GameMain : public DirectXBase
  {
  internal:
    
    delegate void SubFrameFuncDelegate(Windows::UI::Xaml::Controls::Page^ p);
    delegate void IsBackButtonEnabledDelgate(bool v);

    explicit GameMain();
    ~GameMain();
    virtual void CreateDeviceIndependentResources() override;
    virtual void CreateDeviceResources() override;
    virtual void CreateWindowSizeDependentResources() override;
    virtual void Render() override;

    void Initialize(
      _In_ Windows::UI::Core::CoreWindow^ window,
      _In_ Windows::UI::Xaml::Controls::SwapChainBackgroundPanel^ swapChainPanel,
      _In_ float dpi
      ) ;

    void Update(float timeTotal, float timeDelta);

    static const float BACKBUFFER_WIDTH;
    static const float BACKBUFFER_HEIGHT;

    sf::SoundManager& GameMain::SoundManager()
    {
      return *soundManager_;
    }

    sf::SoundDriver& GameMain::SoundDriver()
    {
      return *soundDriver_;
    }

    BasicSprites::SpriteBatch^ GameMain::SpriteBatch()
    {
      return spriteBatch_;
    }

    ::AutoThrottle^ GameMain::AutoThrottle() {return autoThrottle_;}
    ::SampleOverlay^ GameMain::SampleOverlay() {return sampleOverlay_;}

    //  void InitSound();
    float RandFloat(float min, float max);
    void StartSound();
    void StopSound();
    void ClearScreen();
    void RenderScreen();

    void LoadTexture(const std::wstring& filename,ID3D11Texture2D** texPtrAddr);

    void Subframe(Windows::UI::Xaml::Controls::Page^ p)
    {
      subFrameFunction_(p);
    }

    void SetSubFrameFunc(SubFrameFuncDelegate^ func)
    {
        subFrameFunction_ = func;
    }

    ShootingGame::GameStateMachine&  GameMain::GameStateMachine()
    {
      return state_;
    }

    void SetIsBackButtonEnabledDelgate(IsBackButtonEnabledDelgate^ d)
    {
      isBackButtonEnabledDelgate_ = d;
    }

    void IsBackButtonEnabled(bool v)
    {
      isBackButtonEnabledDelgate_(v);
    }

  private:
//    std::function<void(Windows::UI::Xaml::Controls::Page^ p)> subFrameFunction_;
    SubFrameFuncDelegate^ subFrameFunction_;
    IsBackButtonEnabledDelgate^ isBackButtonEnabledDelgate_;
    ShootingGame::GameStateMachine state_;
    void ExecuteSoundThread();
    ::SampleOverlay^ sampleOverlay_;
    ::AutoThrottle^ autoThrottle_;
    BasicSprites::SpriteBatch^ spriteBatch_;
    Microsoft::WRL::ComPtr<ID3D11Texture2D> backBuffer_;
    Microsoft::WRL::ComPtr<ID3D11RenderTargetView>  backBufferRenderTargetView_;
    //  Microsoft::WRL::ComPtr<ID3D11DepthStencilView>  backBufferDepthStencilView_;
    //	Microsoft::WRL::ComPtr<ID3D11DepthStencilState> backBufferDepthStencilState_;
    float scale_;
    CD3D11_VIEWPORT backBufferViewPort_;
    CD3D11_VIEWPORT swapChainViewPort_;
    std::vector<CharacterData> characters_;
    bool isDestroy_;
    Windows::UI::Xaml::Controls::SwapChainBackgroundPanel^ panel_;
    std::unique_ptr<sf::SoundManager> soundManager_;
    std::unique_ptr<sf::SoundDriver> soundDriver_;
    concurrency::task<void> soundTask_;
    sf::handle_holder eventHolder_;
  };
}
