﻿#pragma once

namespace sf
{
	template <typename ExceptionTag> class ExceptionT :  public std::exception
	{
	public:
		typedef ExceptionTag tag;
		explicit ExceptionT(const std::wstring& reason)
		{
			m_reason = reason;
		};
		const wchar_t * what() {return m_reason.c_str();};
		const std::wstring& what_str() { return m_reason;};
	protected:
		std::wstring m_reason;
	};

	#define DefineException(x) struct x {}; typedef sf::ExceptionT<x> x## Exception;

	inline void ThrowIfErr(HRESULT hr) {if(hr != S_OK){throw Platform::Exception::CreateException(hr);}}

}

