#include "pch.h"
#include <array>
#include "WaveTableSynth.h"
#include "Sequencer.h"
#include "TestSong.h"

namespace sf {



  TestSong::TestSong(SequenceTracksType& tracks) : tracks_(tracks)
  {
    for(float i = -5.0f;i < 5.0f;++i)
    {
      noteTable_.push_back(powf(2.0f,-9.0f/12.0f + i  ));//C
      noteTable_.push_back(powf(2.0f,-8.0f/12.0f + i ));//C#
      noteTable_.push_back(powf(2.0f,-7.0f/12.0f + i ));//D
      noteTable_.push_back(powf(2.0f,-6.0f/12.0f + i ));//D#
      noteTable_.push_back(powf(2.0f,-5.0f/12.0f + i ));//E
      noteTable_.push_back(powf(2.0f,-4.0f/12.0f + i ));//F
      noteTable_.push_back(powf(2.0f,-3.0f/12.0f + i ));//F#
      noteTable_.push_back(powf(2.0f,-2.0f/12.0f + i ));//G
      noteTable_.push_back(powf(2.0f,-1.0f/12.0f + i ));//G#4
      noteTable_.push_back(powf(2.0f,0.0f + i ));//A4
      noteTable_.push_back(powf(2.0f,1.0f/12.0f + i ));//A#4
      noteTable_.push_back(powf(2.0f,2.0f/12.0f + i ));//B4  
    }

    for(int i = 0;i < tracks.size();++i)
    {
      stepCounters_.push_back(0);
    }

    //CreateTestTone();
 /*   for(int i = 0;i < 5;++i){
      CreateMappyData();
    }*/
    CreateCosmicSurfin();


 }

  void TestSong::CreateMappyData()
  {
    AddNote(0,480,Note::E,5,1.0f,120);
    AddNote(0,480,Note::B,5,1.0f,120);
    AddNote(0,480,Note::AS,5,1.0f,120);
    AddNote(0,360,Note::B,5,1.0f,90);
    AddNote(0,120,Note::B,5,1.0f,90);
    
    AddNote(0,120,Note::C,6,1.0f,30);
    AddNote(0,120,Note::C,6,1.0f,30);
    AddNote(0,120,Note::C,6,1.0f,30);
    AddNote(0,120,Note::C,6,1.0f,30);
    AddNote(0,120,Note::C,6,1.0f,30);
    AddNote(0,120,Note::C,6,1.0f,30);
    AddNote(0,120,Note::C,6,1.0f,30);
    AddNote(0,120,Note::C,6,1.0f,30);
    AddNote(0,120,Note::B,5,1.0f,30);
    AddNote(0,120,Note::B,5,1.0f,30);
    AddNote(0,120,Note::B,5,1.0f,30);
    AddNote(0,120,Note::B,5,1.0f,30);
    AddNote(0,120,Note::B,5,1.0f,30);
    AddNote(0,120,Note::B,5,1.0f,30);
    AddNote(0,120,Note::B,5,1.0f,30);
    AddNote(0,120,Note::B,5,1.0f,30);

    AddNote(0,480,Note::A,5,1.0f,90);
    AddNote(0,480,Note::B,5,1.0f,90);
    AddNote(0,360,Note::A,5,1.0f,90);
    AddNote(0,120,Note::G,5,1.0f,90);
    AddNote(0,360,Note::E,5,1.0f,90);
    AddNote(0,120,Note::A,5,1.0f,90);

    AddNote(0,120,Note::A,5,1.0f,90);
    AddNote(0,120,Note::A,5,1.0f,90);
    AddNote(0,120,Note::A,5,1.0f,90);
    AddNote(0,120,Note::A,5,1.0f,90);
    AddNote(0,120,Note::A,5,1.0f,90);
    AddNote(0,120,Note::A,5,1.0f,90);
    AddNote(0,120,Note::A,5,1.0f,90);
    AddNote(0,120,Note::A,5,1.0f,90);

    AddNote(0,120,Note::A,5,1.0f,90);
    AddNote(0,120,Note::A,5,1.0f,90);
    AddNote(0,120,Note::A,5,1.0f,90);
    AddNote(0,120,Note::A,5,1.0f,90);
    AddNote(0,120,Note::A,5,1.0f,90);
    AddNote(0,120,Note::A,5,1.0f,90);
    AddNote(0,120,Note::A,5,1.0f,90);
    AddNote(0,120,Note::A,5,1.0f,90);

    AddNote(0,480,Note::D,5,1.0f,90);
    AddNote(0,480,Note::A,5,1.0f,90);
    AddNote(0,480,Note::GS,5,1.0f,90);
    AddNote(0,360,Note::A,5,1.0f,90);
    AddNote(0,120,Note::A,5,1.0f,90);

    AddNote(0,120,Note::B,5,1.0f,90);
    AddNote(0,120,Note::B,5,1.0f,90);
    AddNote(0,120,Note::B,5,1.0f,90);
    AddNote(0,120,Note::B,5,1.0f,90);
    AddNote(0,120,Note::B,5,1.0f,90);
    AddNote(0,120,Note::B,5,1.0f,90);
    AddNote(0,120,Note::B,5,1.0f,90);
    AddNote(0,120,Note::B,5,1.0f,90);
    AddNote(0,120,Note::A,5,1.0f,90);
    AddNote(0,120,Note::A,5,1.0f,90);
    AddNote(0,120,Note::A,5,1.0f,90);
    AddNote(0,120,Note::A,5,1.0f,90);
    AddNote(0,120,Note::A,5,1.0f,90);
    AddNote(0,120,Note::A,5,1.0f,90);
    AddNote(0,120,Note::A,5,1.0f,90);
    AddNote(0,120,Note::A,5,1.0f,90);

    AddNote(0,480,Note::G,5,1.0f,90);
    AddNote(0,480,Note::A,5,1.0f,90);
    AddNote(0,360,Note::G,5,1.0f,90);
    AddNote(0,480,Note::E,5,1.0f,90);
    AddNote(0,120,Note::D,5,1.0f,90);

    AddNote(0,120,Note::D,5,1.0f,90);
    AddNote(0,120,Note::D,5,1.0f,90);
    AddNote(0,120,Note::D,5,1.0f,90);
    AddNote(0,120,Note::D,5,1.0f,90);
    AddNote(0,120,Note::D,5,1.0f,90);
    AddNote(0,120,Note::D,5,1.0f,90);
    AddNote(0,120,Note::D,5,1.0f,90);
    AddNote(0,120,Note::D,5,1.0f,90);
    AddNote(0,120,Note::D,5,1.0f,90);
    AddNote(0,120,Note::D,5,1.0f,90);
    AddNote(0,120,Note::D,5,1.0f,90);
    AddNote(0,120,Note::D,5,1.0f,90);
    AddNote(0,120,Note::D,5,1.0f,90);
    AddNote(0,120,Note::D,5,1.0f,90);
    AddNote(0,120,Note::D,5,1.0f,90);
    AddNote(0,120,Note::D,5,1.0f,90);

    AddNote(0,360,Note::B,3,1.0f,90);
    AddNote(0,120,Note::D,5,1.0f,90);
    AddNote(0,360,Note::G,5,1.0f,90);
    AddNote(0,120,Note::B,3,1.0f,90);
    AddNote(0,360,Note::D,5,1.0f,90);
    AddNote(0,120,Note::G,5,1.0f,90);
    AddNote(0,360,Note::B,3,1.0f,90);
    AddNote(0,120,Note::D,5,1.0f,90);

    AddNote(0,360,Note::C,5,1.0f,90);
    AddNote(0,120,Note::E,5,1.0f,90);
    AddNote(0,360,Note::G,5,1.0f,90);
    AddNote(0,120,Note::CS,5,1.0f,90);
    AddNote(0,360,Note::E,5,1.0f,90);
    AddNote(0,120,Note::G,5,1.0f,90);
    AddNote(0,360,Note::CS,5,1.0f,90);
    AddNote(0,120,Note::E,5,1.0f,90);

    AddRest(0,480);
    AddNote(0,360,Note::B,5,1.0f,90);
    AddNote(0,120,Note::AS,5,1.0f,90);
    AddNote(0,480,Note::A,5,1.0f,90);
    AddNote(0,360,Note::D,5,1.0f,90);
    AddNote(0,600,Note::G,5,1.0f,90);

    AddNote(0,480,Note::G,5,1.0f,90);
    AddNote(0,480,Note::FS,5,1.0f,90);
    AddNote(0,480,Note::E,5,1.0f,90);

    //

    AddNote(2/*channel*/,480/*step*/,Note::E /*K*/,5/*octave*/,1.0f/*velocity*/,10 /*gatetime*/,0.002f/*ofset*/);
    AddNote(2,480,Note::B,5,1.0f,10,0.002f);
    AddNote(2,480,Note::AS,5,1.0f,10,0.002f);
    AddNote(2,360,Note::B,5,1.0f,10,0.002f);
    AddNote(2,120,Note::B,5,1.0f,10,0.002f);
    
    AddNote(2,120,Note::C,6,1.0f,10,0.002f);
    AddNote(2,120,Note::C,6,1.0f,10,0.002f);
    AddNote(2,120,Note::C,6,1.0f,10,0.002f);
    AddNote(2,120,Note::C,6,1.0f,10,0.002f);
    AddNote(2,120,Note::C,6,1.0f,10,0.002f);
    AddNote(2,120,Note::C,6,1.0f,10,0.002f);
    AddNote(2,120,Note::C,6,1.0f,10,0.002f);
    AddNote(2,120,Note::C,6,1.0f,10,0.002f);
    AddNote(2,120,Note::B,6,1.0f,10,0.002f);
    AddNote(2,120,Note::B,6,1.0f,10,0.002f);
    AddNote(2,120,Note::B,6,1.0f,10,0.002f);
    AddNote(2,120,Note::B,6,1.0f,10,0.002f);
    AddNote(2,120,Note::B,6,1.0f,10,0.002f);
    AddNote(2,120,Note::B,6,1.0f,10,0.002f);
    AddNote(2,120,Note::B,6,1.0f,10,0.002f);
    AddNote(2,120,Note::B,6,1.0f,10,0.002f);

    AddNote(2,480,Note::A,5,1.0f,10,0.002f);
    AddNote(2,480,Note::B,5,1.0f,10,0.002f);
    AddNote(2,360,Note::A,5,1.0f,10,0.002f);
    AddNote(2,120,Note::G,5,1.0f,10,0.002f);
    AddNote(2,360,Note::E,5,1.0f,10,0.002f);
    AddNote(2,120,Note::A,5,1.0f,10,0.002f);

    AddNote(2,120,Note::A,5,1.0f,10,0.002f);
    AddNote(2,120,Note::A,5,1.0f,10,0.002f);
    AddNote(2,120,Note::A,5,1.0f,10,0.002f);
    AddNote(2,120,Note::A,5,1.0f,10,0.002f);
    AddNote(2,120,Note::A,5,1.0f,10,0.002f);
    AddNote(2,120,Note::A,5,1.0f,10,0.002f);
    AddNote(2,120,Note::A,5,1.0f,10,0.002f);
    AddNote(2,120,Note::A,5,1.0f,10,0.002f);

    AddNote(2,120,Note::A,5,1.0f,10,0.002f);
    AddNote(2,120,Note::A,5,1.0f,10,0.002f);
    AddNote(2,120,Note::A,5,1.0f,10,0.002f);
    AddNote(2,120,Note::A,5,1.0f,10,0.002f);
    AddNote(2,120,Note::A,5,1.0f,10,0.002f);
    AddNote(2,120,Note::A,5,1.0f,10,0.002f);
    AddNote(2,120,Note::A,5,1.0f,10,0.002f);
    AddNote(2,120,Note::A,5,1.0f,10,0.002f);

    AddNote(2,480,Note::D,5,1.0f,10,0.002f);
    AddNote(2,480,Note::A,5,1.0f,10,0.002f);
    AddNote(2,480,Note::GS,5,1.0f,10,0.002f);
    AddNote(2,360,Note::A,5,1.0f,10,0.002f);
    AddNote(2,120,Note::A,5,1.0f,10,0.002f);

    AddNote(2,120,Note::B,5,1.0f,10,0.002f);
    AddNote(2,120,Note::B,5,1.0f,10,0.002f);
    AddNote(2,120,Note::B,5,1.0f,10,0.002f);
    AddNote(2,120,Note::B,5,1.0f,10,0.002f);
    AddNote(2,120,Note::B,5,1.0f,10,0.002f);
    AddNote(2,120,Note::B,5,1.0f,10,0.002f);
    AddNote(2,120,Note::B,5,1.0f,10,0.002f);
    AddNote(2,120,Note::B,5,1.0f,10,0.002f);
    AddNote(2,120,Note::A,5,1.0f,10,0.002f);
    AddNote(2,120,Note::A,5,1.0f,10,0.002f);
    AddNote(2,120,Note::A,5,1.0f,10,0.002f);
    AddNote(2,120,Note::A,5,1.0f,10,0.002f);
    AddNote(2,120,Note::A,5,1.0f,10,0.002f);
    AddNote(2,120,Note::A,5,1.0f,10,0.002f);
    AddNote(2,120,Note::A,5,1.0f,10,0.002f);
    AddNote(2,120,Note::A,5,1.0f,10,0.002f);

    AddNote(2,480,Note::G,5,1.0f,10,0.002f);
    AddNote(2,480,Note::A,5,1.0f,10,0.002f);
    AddNote(2,360,Note::G,5,1.0f,10,0.002f);
    AddNote(2,480,Note::E,5,1.0f,10,0.002f);
    AddNote(2,120,Note::D,5,1.0f,10,0.002f);

    AddNote(2,120,Note::D,5,1.0f,10,0.002f);
    AddNote(2,120,Note::D,5,1.0f,10,0.002f);
    AddNote(2,120,Note::D,5,1.0f,10,0.002f);
    AddNote(2,120,Note::D,5,1.0f,10,0.002f);
    AddNote(2,120,Note::D,5,1.0f,10,0.002f);
    AddNote(2,120,Note::D,5,1.0f,10,0.002f);
    AddNote(2,120,Note::D,5,1.0f,10,0.002f);
    AddNote(2,120,Note::D,5,1.0f,10,0.002f);
    AddNote(2,120,Note::D,5,1.0f,10,0.002f);
    AddNote(2,120,Note::D,5,1.0f,10,0.002f);
    AddNote(2,120,Note::D,5,1.0f,10,0.002f);
    AddNote(2,120,Note::D,5,1.0f,10,0.002f);
    AddNote(2,120,Note::D,5,1.0f,10,0.002f);
    AddNote(2,120,Note::D,5,1.0f,10,0.002f);
    AddNote(2,120,Note::D,5,1.0f,10,0.002f);
    AddNote(2,120,Note::D,5,1.0f,10,0.002f);

    AddNote(2,360,Note::B,3,1.0f,10,0.002f);
    AddNote(2,120,Note::D,5,1.0f,10,0.002f);
    AddNote(2,360,Note::G,5,1.0f,10,0.002f);
    AddNote(2,120,Note::B,3,1.0f,10,0.002f);
    AddNote(2,360,Note::D,5,1.0f,10,0.002f);
    AddNote(2,120,Note::G,5,1.0f,10,0.002f);
    AddNote(2,360,Note::B,3,1.0f,10,0.002f);
    AddNote(2,120,Note::D,5,1.0f,10,0.002f);

    AddNote(2,360,Note::C,5,1.0f,10,0.002f);
    AddNote(2,120,Note::E,5,1.0f,10,0.002f);
    AddNote(2,360,Note::G,5,1.0f,10,0.002f);
    AddNote(2,120,Note::CS,5,1.0f,10,0.002f);
    AddNote(2,360,Note::E,5,1.0f,10,0.002f);
    AddNote(2,120,Note::G,5,1.0f,10,0.002f);
    AddNote(2,360,Note::CS,5,1.0f,10,0.002f);
    AddNote(2,120,Note::E,5,1.0f,10,0.002f);

    AddRest(2,480);
    AddNote(2,360,Note::B,5,1.0f,10,0.002f);
    AddNote(2,120,Note::AS,5,1.0f,10,0.002f);
    AddNote(2,480,Note::A,5,1.0f,10,0.002f);
    AddNote(2,360,Note::D,5,1.0f,10,0.002f);
    AddNote(2,600,Note::G,5,1.0f,10,0.002f);

    AddNote(2,480,Note::G,5,1.0f,10,0.002f);
    AddNote(2,480,Note::FS,5,1.0f,10,0.002f);
    AddNote(2,480,Note::E,5,1.0f,10,0.002f);

    //

    AddNote(1,480,Note::E,2,1.0f,90);
    AddRest(1,480);
    AddNote(1,480,Note::B,1,1.0f,90);
    AddRest(1,360);
    AddNote(1,120,Note::E,2,1.0f,90);

    AddRest(1,360);
    AddNote(1,120,Note::E,2,1.0f,90);
    AddNote(1,480,Note::B,1,1.0f,90);
    AddNote(1,360,Note::E,2,1.0f,90);
    AddNote(1,120,Note::FS,2,1.0f,90);
    AddNote(1,480,Note::GS,2,1.0f,90);

    AddNote(1,480,Note::A,2,1.0f,90);
    AddRest(1,480);
    AddNote(1,480,Note::E,2,1.0f,90);
    AddRest(1,360);
    AddNote(1,120,Note::A,2,1.0f,90);

    AddRest(1,360);
    AddNote(1,120,Note::A,2,1.0f,90);
    AddNote(1,480,Note::G,2,1.0f,90);
    AddNote(1,480,Note::FS,2,1.0f,90);
    AddNote(1,480,Note::E,2,1.0f,90);

    AddNote(1,480,Note::D,2,1.0f,90);
    AddRest(1,480);
    AddNote(1,480,Note::A,1,1.0f,90);
    AddRest(1,360);
    AddNote(1,120,Note::D,2,1.0f,90);

    AddRest(1,360);
    AddNote(1,120,Note::D,2,1.0f,90);
    AddNote(1,480,Note::A,1,1.0f,90);
    AddNote(1,360,Note::D,2,1.0f,90);
    AddNote(1,120,Note::E,2,1.0f,90);
    AddNote(1,480,Note::FS,2,1.0f,90);
  }

  void TestSong::CreateTestTone()
  {
    for(int j = 0;j < 5;++j){
      for(int i = 2;i < 9;++i)
      {
        AddNote(0,960,Note::C,i,1.0f,600);
        AddNote(0,960,Note::D,i,1.0f,600);
        AddNote(0,960,Note::E,i,1.0f,600);
        AddNote(0,960,Note::F,i,1.0f,600);
        AddNote(0,960,Note::G,i,1.0f,600);
        AddNote(0,960,Note::A,i,1.0f,600);
        AddNote(0,960,Note::B,i,1.0f,600);
      }
    }
  }

  void TestSong::CreateCosmicSurfin()
  {

    for(int i = 0;i < 8;++i){
    AddNote(0,240,Note::A,2,1.0f,190);
    AddNote(0,240,Note::A,3,1.0f,190);
    AddNote(0,240,Note::G,2,1.0f,190);
    AddNote(0,240,Note::G,3,1.0f,190);
    AddNote(0,240,Note::A,2,1.0f,190);
    AddNote(0,240,Note::A,3,1.0f,190);
    AddNote(0,240,Note::G,2,1.0f,190);
    AddNote(0,240,Note::G,3,1.0f,190);

    AddNote(0,240,Note::A,2,1.0f,190);
    AddNote(0,240,Note::A,3,1.0f,190);
    AddNote(0,240,Note::G,2,1.0f,190);
    AddNote(0,240,Note::G,3,1.0f,190);
    AddNote(0,240,Note::A,2,1.0f,190);
    AddNote(0,240,Note::A,3,1.0f,190);
    AddNote(0,240,Note::G,2,1.0f,190);
    AddNote(0,240,Note::G,3,1.0f,190);
    
    AddNote(0,240,Note::A,2,1.0f,190);
    AddNote(0,240,Note::A,3,1.0f,190);
    AddNote(0,240,Note::G,2,1.0f,190);
    AddNote(0,240,Note::G,3,1.0f,190);
    AddNote(0,240,Note::A,2,1.0f,190);
    AddNote(0,240,Note::A,3,1.0f,190);
    AddNote(0,240,Note::G,2,1.0f,190);
    AddNote(0,240,Note::G,3,1.0f,190);

    AddNote(0,240,Note::A,2,1.0f,190);
    AddNote(0,240,Note::A,3,1.0f,190);
    AddNote(0,240,Note::G,2,1.0f,190);
    AddNote(0,240,Note::G,3,1.0f,190);
    AddNote(0,240,Note::A,2,1.0f,190);
    AddNote(0,240,Note::A,3,1.0f,190);
    AddNote(0,240,Note::G,2,1.0f,190);
    AddNote(0,240,Note::G,3,1.0f,190);

    AddNote(0,240,Note::D,3,1.0f,190);
    AddNote(0,240,Note::D,4,1.0f,190);
    AddNote(0,240,Note::C,3,1.0f,190);
    AddNote(0,240,Note::C,4,1.0f,190);
    AddNote(0,240,Note::D,3,1.0f,190);
    AddNote(0,240,Note::D,4,1.0f,190);
    AddNote(0,240,Note::D,3,1.0f,190);
    AddNote(0,240,Note::D,4,1.0f,190);

    AddNote(0,240,Note::F,3,1.0f,190);
    AddNote(0,240,Note::F,4,1.0f,190);
    AddNote(0,240,Note::DS,3,1.0f,190);
    AddNote(0,240,Note::DS,4,1.0f,190);
    AddNote(0,240,Note::F,3,1.0f,190);
    AddNote(0,240,Note::F,4,1.0f,190);
    AddNote(0,240,Note::F,3,1.0f,190);
    AddNote(0,240,Note::F,4,1.0f,190);

    AddNote(0,240,Note::C,3,1.0f,190);
    AddNote(0,240,Note::C,4,1.0f,190);
    AddNote(0,240,Note::C,3,1.0f,190);
    AddNote(0,240,Note::C,4,1.0f,190);
    AddNote(0,240,Note::C,3,1.0f,190);
    AddNote(0,240,Note::C,4,1.0f,190);
    AddNote(0,240,Note::C,3,1.0f,190);
    AddNote(0,240,Note::C,4,1.0f,190);
    AddNote(0,240,Note::C,3,1.0f,190);
    AddNote(0,240,Note::C,4,1.0f,190);
    AddNote(0,240,Note::C,3,1.0f,190);
    AddNote(0,240,Note::C,4,1.0f,190);
    AddNote(0,240,Note::C,3,1.0f,190);
    AddNote(0,240,Note::C,4,1.0f,190);
    AddNote(0,240,Note::B,2,1.0f,190);
    AddNote(0,240,Note::B,3,1.0f,190);

    }

  }


  void TestSong::AddNote(int channel,int step,float pitch,float velocity,int gatetime)
  {
    tracks_[channel].push_back(SequenceData(SequenceCommand::Note,stepCounters_[channel],pitch,velocity,gatetime));
    stepCounters_[channel] += step;
  }

  void TestSong::AddNote(int channel,int step,Note note,int octave,float velocity,int gatetime,float detune )
  {
    tracks_[channel].push_back(SequenceData(SequenceCommand::Note,stepCounters_[channel],GetPitch(note,octave) + detune,velocity,gatetime));
    stepCounters_[channel] += step;
  }

  void TestSong::AddRest(int channel,int step)
  {
    stepCounters_[channel] += step;
  }

  float  TestSong::GetPitch(Note note,int octave)
  {
    return noteTable_[(int)note +  octave * 12];
  }

  TestSong::~TestSong(void)
  {
  }
}
