from trac.core import *
from trac.config import Option, Configuration
from trac.web.chrome import add_script,add_stylesheet,ITemplateProvider,INavigationContributor
from trac.web.main import IRequestHandler, IRequestFilter
from genshi.template import MarkupTemplate
import json

class CompleteUserWeb(Component):
    implements(IRequestHandler, IRequestFilter, ITemplateProvider, INavigationContributor)

    # INavitationContributor methods
    def get_active_navigation_item(self, req):
        return "completeuser"

    def get_navigation_items(self, req):
        single_fields = Configuration.getlist(self.config,"complete-user","single_fields","owner");
        composite_fields = Configuration.getlist(self.config,"complete-user","composite_fields","cc");

        script = "<script type='text/javascript'>\n"
        script = script+"$(function(){\n"
        script = script+"  ultimania.trac.setAutoComplete('reassign_reassign_owner','" + req.base_path + "/completeuser',false);\n"
        for field in single_fields:
           script = script+"  ultimania.trac.setAutoComplete('field-" + field + "','" + req.base_path + "/completeuser',false);\n"
        for field in composite_fields:
           script = script+"  ultimania.trac.setAutoComplete('field-" + field + "','" + req.base_path + "/completeuser',true);\n"
        script = script+"})\n"
        script = script+"</script>"

        yield ('metanav', 'completeuser', MarkupTemplate(script).generate())

    # IRequestFilter methods
    def pre_process_request(self, req, handler):
        return handler
        
    def post_process_request(self, req, template, content_type):
        return (template, content_type)

    def post_process_request(self, req, template, data, content_type):
        add_stylesheet(req, 'completeuser/css/trac-completeuser.css')
        add_script(req, 'completeuser/js/yui/utilities/utilities.js')
        add_script(req, 'completeuser/js/yui/autocomplete/autocomplete-min.js')
        add_script(req, 'completeuser/js/trac-completeuser.js')
        return (template, data, content_type)

    # IRequestHandler methods
    def match_request(self, req):
        if req.path_info in ('/login/completeuser', '/completeuser'):
            self.log.debug("%s matches %s" % (req.path_info, True))
            return True
        return False

    def process_request(self, req):
        query = req.args.get('query')
        db = self.env.get_db_cnx()
        cursor = db.cursor();
        q = ""
        if query != None:
            q = ("AND s.sid LIKE '%%%s%%'") % (query)
        sql = ("SELECT s.sid, sa.value FROM session s JOIN session_attribute sa ON s.sid = sa.sid WHERE s.authenticated = 1 AND sa.name = 'name' %s") % (q)
        cursor.execute(sql)
        userlist = []
        for sid, value in cursor:
            userlist.append({"Id":sid, "Name": value});
        response = json.write({"UserList":userlist});
	
        req.send_response(200)
        req.send_header('Content-Type', 'application/json; charset=utf-8')
        req.send_header('Content-Length', len(response.encode("utf-8")))
        req.end_headers()
        req.write(response)

    # ITemplateProvider methods
    def get_templates_dirs(self):
        return []

    def get_htdocs_dirs(self):
        from pkg_resources import resource_filename
        return [('completeuser', resource_filename(__name__, 'htdocs'))]
