/*
 * }`vbgtH[`GWuSherryv
 * Copyright(C) 2010-2011 SherryProject. all rights reserved.
 *
 * The MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/*
 *	mushroom.c
 *		Copyright (C) 2010-2011 Cap5ule. all rights reserved.
 * 
 *	Date		|Version	|Author		|Summary
 *	2010/02/01	|v0.01		|onakah		|
 */

/*---- CN[ht@C ----*/

#include <windows.h>			//!<WindowsAPI
#include <use_sherry.h>			//!<SherryCugp

/*---- }N` ----*/

#define RESISTANCE		(0.6f)	//!<]Rl
#define MUSUROOMNUM		(9)		//!<̂ő吔iO[vj
#define SCREEN_WIDTH	(640)	//!<^bvpAn[hɂĕύX
#define SCREEN_HEIGHT	(480)	//!<


/*---- \̒` ----*/


/*---- O[oϐ ----*/

extern shTexture	g_testTex;		//!<eNX`f[^
extern shMesh		g_testMesh;		//!<bVf[^
extern shShaderProg g_shaderpg;		//!<VF[_vO


shVector3	g_axis[9];				//!<̂]
float		g_rot[9];				//!<̂]p
shMatrix	g_rotMatrix[9];			//!<̂]s


/*
 *	void InitMushroom(void)
 *
 *	̂
 */
void InitMushroom(void)
{
	int index;
	for(index = 0; index < MUSUROOMNUM; index ++){
		shMatrixIdentity(&g_rotMatrix[index]);
	}
}


/*
 *	void MoveMushroom(shVector2 vec)
 *
 *	̂]
 *	
 *		int isClick		: NbN/^bvĂ邩i0:no / 1:yesj
 *		float _x		: ^bvĂwW
 *		float _y		: ^bvĂxW
 *		shVector2 vec	: ړ
 */
void MoveMushroom(int isClick, float _x, float _y, shVector2 vec)
{
	int				mdlX = 0;		// ^bvΏۂ̃fp
	int				mdlY = 0;		// ^bvΏۂ̃fp
	int				mdlIndex = -1;	// ^bvΏۂ̃fzԍ
	int				index = 0;		// JE^[
	shQuaternion	quatWork;		// lvZp
	shMatrix		matWork;		// svZp

	if(isClick){
		// ^bvĂ
		if(_x < SCREEN_WIDTH/3){
			mdlX = 0;
		}else if(_x > (SCREEN_WIDTH/3)*2){
			mdlX = 2;
		}else{
			mdlX = 1;
		}
		if(_y < SCREEN_HEIGHT/3){
			mdlY = 0;
		}else if(_y > (SCREEN_HEIGHT/3)*2){
			mdlY = 2;
		}else{
			mdlY = 1;
		}
		// zvZ
		mdlIndex = mdlY*3+mdlX;
		// xNgl𐶐鏀
		g_axis[mdlIndex].x = vec.y;
		g_axis[mdlIndex].y = vec.x;
		g_axis[mdlIndex].z = 0.0f;
		g_rot[mdlIndex] = -sqrtf(vec.x*vec.x+vec.y*vec.y)/2.0f;
		shVec3Normalize(&g_axis[mdlIndex]);
	}

	// 
	// Rlŉ]x
	for(index = 0; index < MUSUROOMNUM; index ++){
		if(index != mdlIndex){
			// ݏĂ镨ȊO
			if(g_rot[index] < 0){
				g_rot[index] += RESISTANCE;
				if(g_rot[index] > 0){
					g_rot[index] = 0.0f;
				}
			}
			else if(g_rot[index] > 0){
				g_rot[index] -= RESISTANCE;
				if(g_rot[index] < 0){
					g_rot[index] = 0.0f;
				}
			}
		}
	}
//	g_rot /= 1.1f;

	// ]s쐬
	for(index = 0; index < MUSUROOMNUM; index ++){
		// l𐶐
		shQuaternionRotation(&quatWork, TO_RADIAN(g_rot[index]), g_axis[index].x, g_axis[index].y, g_axis[index].z);
		// ls
		shQuaternionToMatrix(&matWork, &quatWork);
		// ]
		shMatrixMultiply(&g_rotMatrix[index], &g_rotMatrix[index], &matWork);
	}
}


/*
 *	void UpdateMushroom(void)
 *
 *	̂XV
 */
void UpdateMushroom(void)
{
}


/*
 *	void DrawMushroom(void)
 *
 *	̂`揈
 */
void DrawMushroom(void)
{
	// [Jϐ
	shMatrix drawmat, drawmat2, drawans;	// ϊp̍s

	//|S`
	{
		int ii;
		int iii;
		shVector3 eye,at,up;

		//ݒ
		eye.x = 0.0f;
		eye.y = 0.0f;
		eye.z = 4.0f;
		at.x = 0.0f;
		at.y = 0.0f;
		at.z = 0.0f;
		up.x = 0.0f;
		up.y = 1.0f;
		up.z = 0.0f;

		// VF[_[Kp
		shBeginShader(&g_shaderpg);

		// eNX`ݒ
		shSetTexture(&g_testTex);

		// sϊ
		shMatrixIdentity(&drawans);	// Pʍs
		shMatrixPerspectiveFovRH(&drawmat,45,640.0f/480.0f,0.5f,20.0f);
		shLookAtMatrixRH(&drawmat2,&eye,&at,&up);
//		shMatrixMultiply(&drawans,&drawmat2,&drawmat);
//		shMatrixMultiply(&drawans,&g_rotMatrix,&drawans);

		// f`Jn
		// fQ9`悷
		for(iii = 0; iii < 9; iii++) {
			shMatrix transMat;

			const shVector3 mdlPos[] = {
				{-2,  1.4f, 0},
				{ 0,  1.4f, 0},
				{ 2,  1.4f, 0},
				{-2,  0, 0},
				{ 0,  0, 0},
				{ 2,  0, 0},
				{-2, -1.4f, 0},
				{ 0, -1.4f, 0},
				{ 2, -1.4f, 0},
			};
			shMatrixMultiply(&drawans,&drawmat2,&drawmat);
			// sړ
			shMatrixTranslation(&transMat,mdlPos[iii].x,mdlPos[iii].y,mdlPos[iii].z);
			// ړ
			shMatrixMultiply(&drawans, &transMat, &drawans);
			// ]
			shMatrixMultiply(&drawans, &g_rotMatrix[iii], &drawans);

			// f\9`悷
			for(ii = 0; ii < 1; ii++) {
				shMatrix drawmat_tran, drawmat_ans;

				const shVector3 pos[] = {
					{0,0,0},
				};

				// sړ
				shMatrixTranslation(&drawmat_tran,pos[ii].x,pos[ii].y,pos[ii].z);
				// svZ
				shMatrixMultiply(&drawmat_ans,&drawmat_tran,&drawans);
				// s
				shUniformMatrix(&g_shaderpg,"u_worldViewProjMatrix",&drawmat_ans);

				// `
				shDrawMesh(&g_testMesh);
			}
		}

		shEndShader(&g_shaderpg);
	}
}

