﻿/*
 * マルチプラットフォーム描画エンジン「Sherry」
 * Copyright(C) 2010-2011 SherryProject. all rights reserved.
 *
 * The MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/*
 *	main.c
 *		Copyright (C) 2010-2011 Cap5ule. all rights reserved.
 * 
 *	Date		|Version	|Author		|Summary
 *	常に更新
 */

/*---- インクルードファイル ----*/

#include <use_sherry.h>			//!<Sherryライブラリを使用する

/*---- マクロ定義 ----*/


/*---- 構造体定義 ----*/


/*---- グローバル変数 ----*/

shTexture	g_testTex;			//!<テクスチャデータ
shTexture	g_testTex2;
shMesh		g_testMesh;			//!<メッシュデータ

shShaderProg g_shaderpg;		//!<シェーダプログラム

const char* source_vs= { "\
attribute vec3 vPos;\
attribute vec2 vTex;\
uniform mat4 u_worldViewProjMatrix;\
varying vec2 texCoord;\
void main(void) \
{ \
	texCoord = vTex;\
	gl_Position = u_worldViewProjMatrix * vec4(vPos,1); \
} "};

const char* source_fs = { "\
#ifdef GL_ES \n \
precision mediump float;\n \
#endif \n \
uniform sampler2D sampler2d;\
varying vec2 texCoord;\
void main (void) \
{ \
	gl_FragColor = texture2D(sampler2d, texCoord); \
} " };

// 頂点シェーダ要素
shVertexElements mushroom_ve[] = {
	{0,SHVETYPE_FLOAT3,SHVEUSAGE_POSITION,"vPos"},
	{0,SHVETYPE_FLOAT2,SHVEUSAGE_NORMAL,"vTex"},
	SHVE_TMT()	//終了
};


static float rot = 0;

static float g_Scroll = 0;

/*---- スタティックプロトタイプ宣言 ----*/


/*---- スタティック関数 ----*/

/*
 *	void DrawFunc()
 *
 *	描画関数：最大パフォーマンスで呼び出されます。
 */
void DrawFunc()
{
	// ローカル変数
	shMatrix drawmat, drawmat2, drawans;	// マトリックス
	
	// 画面クリア
	shClear();
	{
		int ii;
		shVector3 eye,at,up;
		
		eye.x = 0.0f;
		eye.y = 0.0f;
		eye.z = 4.0f;
		at.x = 0.0f;
		at.y = 0.0f;
		at.z = 0.0f;
		up.x = 0.0f;
		up.y = 1.0f;
		up.z = 0.0f;
		
		shBeginShader(&g_shaderpg);
		
		shSetTexture(&g_testTex2);
		
		shMatrixIdentity(&drawans);
		shMatrixPerspectiveFovRH(&drawmat,45,480.0f/320.0f,0.5f,20.0f);
		shLookAtMatrixRH(&drawmat2,&eye,&at,&up);
		shMatrixMultiply(&drawans,&drawmat2,&drawmat);
		shMatrixRotationYawPitchRoll(&drawmat2,rot,rot,rot);
		shMatrixMultiply(&drawans,&drawmat2,&drawans);
		
		for(ii = 0; ii < 9; ii++) {
			shMatrix drawmat_tran, drawmat_ans;
			
			const shVector3 pos[] = {
				{0,0,0},
				{0,0,1},
				{0,0,-1},
				{1,0,0},
				{-1,0,0},
				{0,0,2},
				{0,0,-2},
				{2,0,0},
				{-2,0,0},
			};
			
			shMatrixTranslation(&drawmat_tran,pos[ii].x,pos[ii].y,pos[ii].z);
			
			shMatrixMultiply(&drawmat_ans,&drawmat_tran,&drawans);

			shUniformMatrix(&g_shaderpg,"u_worldViewProjMatrix",&drawmat_ans);
			
			shDrawMesh(&g_testMesh);
		}
		
		shEndShader(&g_shaderpg);
	}
	
	shSetSpriteTexCoord(g_Scroll, g_Scroll, 1.0f, 1.0f);
	shSetSpritePositionSize(128.0f,128.0f,-0.5f,192.0f,192.0f);
	shSetSpriteTexture(&g_testTex);
	shSpriteDraw();

	shPrintf(300, 100, "Sherry");
	shPrintf(300, 140, "test:%d", (int)rot);
}

/*
 *	void UpdateFunc()
 *
 *	更新関数：60fpsで呼び出されます。
 */
void UpdateFunc()
{
	float posX, posY;
	
	// スクロールのテスト
	g_Scroll += 0.01f;
	if(g_Scroll >= 1.0f){
		g_Scroll = 0.0f;
	}

	if(shGetCursorPos(&posX,&posY)) {
		//押されている
		printf("押下%f:%f\n",posX,posY);
	} else {
		//押されてない
	}
	
	rot+=5.0f;
	// ループします。
}

/*
 *	int main(void)
 *
 *	エントリーポイント。ここからスタートします。
 */
int main(void) 
{
	// Sherryライブラリを初期化
	shInitCreateSherry("Sherryライブラリ テスト",640,480,OpenGL);	// OpenGLを使用する

	if(shInitSprite())
		return 1;
	if(shInitDebug())
		return 1;
	 
	shSetSpriteScSize(640,480);
	 
	// 関数をセット
	shSetUpdateThread(30,UpdateFunc);	// 更新
	shSetDrawThread(DrawFunc);			// 描画
	 
	// 情報をセット
	shSetClear(0.2f,0.2f,0.2f,1,
		SH_CLS_COLOR_BUFFER|SH_CLS_DEPTH_BUFFER);	//クリア情報
	 
	// テクスチャ
	shCreateTextureFromPNG(&g_testTex,shDCP("testtex_a.png"));
	shCreateTextureFromPNG(&g_testTex2,shDCP("mushroom.png"));
	 
	// シェーダ
	shCreateShader(&g_shaderpg,source_vs,source_fs,mushroom_ve);
	 
	// モデル読み込み
	shLoadMeshCOLLADA(&g_testMesh, shDCP("mushroom.dae"));
	 
	// Sherryメインループへ
	shMainSherry();
	 
	//削除
	shDeleteTexture(&g_testTex);
	shDeleteTexture(&g_testTex2);
	 
	shExitDebug();
	 
	// Sherryライブラリの終了処理
	shExitSherry();
	
	return 0;
 }
