﻿/*
 * マルチプラットフォーム描画エンジン「Sherry」
 * Copyright(C) 2010-2011 SherryProject. all rights reserved.
 *
 * The MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/*
 *	shTexture.h
 *		Copyright (C) 2010-2011 Cap5ule. all rights reserved.
 *
 *	Date		|Version	|Author		|Summary
 *	2010/11/16	|v0.01		|Cap5ule	|初回版
 *	2010/11/27	|v0.02		|onakah		|PNGデータ構造体作成、PNGファイルの読み込み、
 *				|						|破棄の関数を作成。
 *	2010/12/23	|v0.03		|onakah		|埋め込みテクスチャリソースの読み込みを追加
 */


#ifndef _SH_TEXTURE_H_
#define _SH_TEXTURE_H_

/*---- マクロ定義 ----*/

typedef unsigned int texparam;	//!<テクスチャパラメータフラグ型

/*---- 構造体定義 ----*/

/*
 *	struct _shtexture
 *
 *	テクスチャデータ構造体
 */
typedef struct _shtexture {
	union {
		GLuint gltex;			//!<OpenGL向けテクスチャ
	};
} shTexture;

/*---- 外部グローバル変数 ----*/

extern shDrawMode g_sh_DrawMode;	//!<描画モード

/*---- プロトタイプ宣言 ----*/

#ifdef __cplusplus
extern "C" {
#endif

/*
 *	int shCreateTextureFromPNG(shTexture* stex, const char* filepath)
 *
 *	＜引数＞
 *　　shTexture* stex	: テクスチャ構造体ポインタ
 *　　char* filepath	: ファイルパス
 *	＜戻り値＞
 *　　int				: エラーコードが返ります
 *	＜説明＞
 *　　テクスチャデータを作成する。
 *　　PNGフォーマットからテクスチャデータを読み込む
 */
int shCreateTextureFromPNG(shTexture* stex, const char* filepath);

/*
 *	int shCreateTextureFromData(shTexture* stex, int w, int h,
 *								 unsigned char* data)
 *
 *	＜引数＞
 *		shTexture* stex	: テクスチャ構造体ポインタ
 *		int w			: テクスチャサイズ横幅
 *		int h			: テクスチャサイズ縦幅
 *		unsigned char* data		: テクスチャデータ本体
 *	＜戻り値＞
 *		int				: エラーコードが返ります
 *	＜説明＞
 *		テクスチャデータを作成する。
 *		埋め込みデータからテクスチャデータを生成する。
 */
int shCreateTextureFromData(shTexture* stex, int w, int h, unsigned char* data);

/*
 *	int shCreateTexture(shTexture* stex, int w, int h,
 *					int colortype, char* texbuf)
 *
 *	＜引数＞
 *　　shTexture* stex	: テクスチャ構造体ポインタ
 *　　int w			: テクスチャサイズ横幅
 *　　int h			: テクスチャサイズ縦幅
 *　　int colortype	: テクスチャデータ色配置
 *　　int texbuf		: テクスチャバッファポインタ
 *	＜戻り値＞
 *　　int				: エラーコードが返ります
 *	＜説明＞
 *　　テクスチャデータを作成する。データを描画に使えるようにする。
 */
int shCreateTexture(shTexture* stex, int w, int h,
					int colortype, char* texbuf);

/*
 *	int shDeleteTexture(shTexture* stex)
 *
 *	＜引数＞
 *　　shTexture* stex	: テクスチャ構造体ポインタ
 *	＜戻り値＞
 *　　int				: エラーコードが返ります
 *	＜説明＞
 *　　テクスチャデータを削除する。メモリを開放します。
 */
int shDeleteTexture(shTexture* stex);

/*
 *	void shSetTextureWarp(texparam u, texparam v)
 *
 *	＜引数＞
 *　　texparam u	: U座標テクスチャワープパラメータ
 *　　texparam v	: V座標テクスチャワープパラメータ
 *	＜戻り値＞
 *　　なし
 *	＜説明＞
 *　　テクスチャのワープの設定をします。
 *　　[SH_TP_REPEAT][SH_TP_CLAMP]
 */
void shSetTextureWarp(texparam u, texparam v);

/*
 *	void shSetTextureFilter(texparam min, texparam mag)
 *
 *	＜引数＞
 *　　texparam min	: MINテクスチャフィルタパラメータ
 *　　texparam mag	: MAGテクスチャフィルタパラメータ
 *	＜戻り値＞
 *　　なし
 *	＜説明＞
 *　　テクスチャのフィルタの設定をします。
 *　　[SH_TP_NEAREST][SH_TP_LINEAR]
 */
void shSetTextureFilter(texparam min, texparam mag);

#ifdef __cplusplus
}
#endif

#endif /*_SH_TEXTURE_H_*/
