﻿/*
 * マルチプラットフォーム描画エンジン「Sherry」
 * Copyright(C) 2010-2011 SherryProject. all rights reserved.
 *
 * The MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/*
 *	shDebug.h
 *		Copyright (C) 2010-2011 Cap5ule. all rights reserved.
 *
 *	Date		|Version	|Author		|Summary
 *	2010/11/16	|v0.01		|Cap5ule	|初回版
 *	2010/12/04	|v0.02		|onakah		|デバッグウィンドウ構造体定義、
 *										|初期化、削除、生成、描画の追加
 *	2010/12/21	|v0.03		|onakah		|FPSの取得関数を追加
 *	2010/12/23	|v0.04		|onakah		|デバッグGUIのリソースを埋め込み
 *	2010/12/24	|v0.05		|onakah		|ASCII文字の1文字描画を追加
 *	2010/12/25	|v0.06		|onakah		|文字列の描画を追加
 */

#ifndef _SH_DEBUG_H_
#define _SH_DEBUG_H_

#ifdef __cplusplus
extern "C" {
#endif

/*---- マクロ定義 ----*/



/*---- 構造体定義 ----*/

/*
 *	struct _shdebugwindow
 *
 *	デバッグウィンドウ構造体
 */
typedef struct _shdebugwindow
{
	float	x;				// X座標
	float	y;				// Y座標
	float	width;			// 横幅
	float	height;			// 縦幅
	int		windowState;	// ウィンドウの状態
}shDebugWindow;

/*
 *	struct _shdwlist
 *
 *	簡易リスト構造体
 */
typedef struct _shdwlist
{
	int					no;			// ウィンドウ番号
	shDebugWindow		data;		// ウィンドウデータ
	struct _shdwlist*	pNext;		// 次のリストへのポインタ
} shDWList;


/*---- 定数定義 ----*/

#define SH_DW_MAX					(100)		// 生成できるウィンドウの最大数
#define SH_DW_STATE_MAXIMIZED		(0)			// ウィンドウ最大化
#define SH_DW_STATE_MINIMIZED		(1)			// ウィンドウ最小化


/*---- 外部グローバル変数 ----*/


/*---- プロトタイプ宣言 ----*/

/*
 *	int shInitDebug(void)
 *
 *	＜戻り値＞
 *	　int			: エラーコードが返ります。
 *	＜説明＞
 *　　デバッグシステムの初期化。
 *	　デバッグシステムを使用する初期準備を行います。
 */
int shInitDebug(void);

/*
 *	int shExitDebug(void)
 *
 *	＜戻り値＞
 *	　なし
 *	＜説明＞
 *　　デバッグシステムの終了処理。
 *	　デバッグシステムのリソースの解放を行います。
 */
void shExitDebug(void);

/*
 *	int shCreateDebugWindow(float x, float y, float width, float height)
 *
 *	＜引数＞
 *	　float x			: 左上のX座標
 *	　float y			: 左上のY座標
 *	　float width		: ウィンドウの横幅（最低１６）
 *	　float height	: ウィンドウの縦幅（最低１６）
 *	＜戻り値＞
 *	　int				: ウィンドウの番号を返します。
 *						  生成に失敗した場合には-1を返します。
 *	＜説明＞
 *	　デバッグシウィンドウを生成します。
 */
int shCreateDebugWindow(float x, float y, float width, float height);

/*
 *	void shDeleteDebugWindow(int num)
 *
 *	＜引数＞
 *　　float num		: ウィンドウ番号
 *	＜戻り値＞
 *	　なし
 *	＜説明＞
 *	　指定された番号のデバッグウィンドウを削除します。
 */
void shDeleteDebugWindow(int num);

/*
 *	void shDebugDraw()
 *
 *	＜引数＞
 *		なし
 *	＜戻り値＞
 *		なし
 *	＜説明＞
 *　　デバッグ情報を描画。
 *	　設定されているすべてのデバッグ情報を描画します。
 */
void shDebugDraw();

/*
 *	void shPrintf(int _x, int _y, char * fmt, ...)
 *
 *	＜引数＞
 *　　int _x		: X座標
 *　　int _y		: Y座標
 *　　char * fmt	: 文字列
 *	＜戻り値＞
 *　　なし
 *	＜説明＞
 *　　指定位置に文字列を描画します。
 *　　winAPIのprintfに近い動作をします。現在 %d %x %s に対応しています。
 */
void shPrintf(int _x, int _y, char * fmt, ...);

/*
 *	void shFontSize(int size)
 *
 *	＜引数＞
 *　　int size	: フォントサイズ
 *	＜戻り値＞
 *　　なし
 *	＜説明＞
 *　　フォントサイズを設定する。
 */
void shFontSize(int size);

/*
 *	void shPrintString(int _x, int _y, char* str)
 *
 *	＜引数＞
 *　　int _x			: 描画するX座標
 *　　int _y			: 描画するY座標
 *　　char* str			: 描画する文字列
 *	＜戻り値＞
 *　　なし
 *	＜説明＞
 *　　ASCII文字列を描画します。
 */
void shPrintString(int _x, int _y, char* str);

/*
 *	void shPrintChar(int _x, int _y, char inChar)
 *
 *	＜引数＞
 *		int _x			: 描画するX座標
 *		int _y			: 描画するY座標
 *		char inChar		: 描画する文字
 *	＜戻り値＞
 *		なし
 *	＜説明＞
 *		ASCII文字を1文字描画します。
 */
void shPrintChar(int _x, int _y, char inChar);


#ifdef __cplusplus
}
#endif

#endif /*_SH_DEBUG_H_*/
