﻿///////////////////////////////////////////////////////////////////////////////
// This file is part of SharpWebBrowser.
///////////////////////////////////////////////////////////////////////////////
// Copyright (C) 2009-2011 bis5 <bis5@users.sourceforge.jp>
// All rights reserved.
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the Microsoft Public Licence (Ms-PL) as published by 
// Microsoft Corp.
//
// You should have received a copy of the Microsoft Public License along 
// with this program. 
// If not, see <http://www.microsoft.com/opensource/licenses.mspx>
//
///////////////////////////////////////////////////////////////////////////////
//
// File information
// Name: PropertySheet.cs, PropertySheet.Designer.cs
// Author: bis5
//
///////////////////////////////////////////////////////////////////////////////

using System;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using System.IO;
using System.Xml;
using System.Xml.Serialization;
using System.Collections.Generic;

namespace Bis5Products.SharpWebBrowser {

    public partial class PropertySheet : UserControl, ISWBPropertySheet {
        private MainForm main;
        private ConfigurationManager cm;

        private LanguageManager lnsel;
        private List<SearchProviderInfo> defaultSearchProvidersList = new List<SearchProviderInfo>();
        private System.Collections.ObjectModel.ReadOnlyCollection<SearchProviderInfo> readonlyDefaultSearchProvidersList;
        private List<SearchProviderInfo> currentSearchProvidersList = new List<SearchProviderInfo>();
        private string strRemoveProviderConfirm;

        public string GetPropertySheetName() {
            return lnsel.Get("Core_Property_Name");
        }

        /// <summary>
        /// <see cref="Bis5Products.SharpWebBrpwser.PropertySheet"/>の新しいスタンスを開始します。
        /// </summary>
        /// <param name="mf"><see cref="SharpWebBrowser.MainForm"/>の参照</param>
        internal PropertySheet(ConfigurationManager confmgr, LanguageManager ln, MainForm mf) {
            main = mf;
            cm = confmgr;
            lnsel = ln;
            InitializeComponent();
            this.panel1.Visible = false;
            this.radioButton3.CheckedChanged += new System.EventHandler(radioButton3_CheckedChanged);

            defaultSearchProvidersList.Add(new SearchProviderInfo("http://www.google.com/search?hl=ja&q={0}", "Google"));
            defaultSearchProvidersList.Add(new SearchProviderInfo("http://www.yahoo.co.jp/", "Yahoo! Japan"));
            readonlyDefaultSearchProvidersList = defaultSearchProvidersList.AsReadOnly();
            defaultSearchProvidersList = null;
            lnsel.AppendDelegate(setLang, true);
            Load();
        }

        private void setLang() {
            //Load Language Constances
            //Prefix : Core_Property_
            //Template :  = main.LnSel.GetValue("Core.Property.");
            this.groupBox1.Text = lnsel.GetValue("Core_Property_groupBox1.Text");
            this.radioButton1.Text = lnsel.GetValue("Core_Property_radioButton1.Text");
            this.radioButton2.Text = lnsel.GetValue("Core_Property_radioButton2.Text");
            this.radioButton3.Text = lnsel.GetValue("Core_Property_radioButton3.Text");
            this.groupBox2.Text = lnsel.GetValue("Core_Property_groupBox2.Text");
            this.button1.Text = lnsel.GetValue("Core_Property_button1.Text");
            this.button2.Text = lnsel.GetValue("Core_Property_button2.Text");

            this.lbSearchProvider.Text = lnsel.GetValue("Core_Property_lbSearchProvider.Text");
            this.groupBox3.Text = lnsel.GetValue("Core_Property_groupBox3.Text");
            this.btAddSearchProvider.Text = lnsel.GetValue("Core_Property_btAddSearchProvider.Text");
            this.btRemoveSearchProvider.Text = lnsel.GetValue("Core_Property_btRemoveSearchProvider.Text");
            strRemoveProviderConfirm = lnsel.GetValue("Core_Property_strRemoveProviderConfirm");
        }

        void radioButton3_CheckedChanged(object sender, System.EventArgs e) {
            textBox1.Enabled = radioButton3.Checked;
        }

        /// <summary>
        /// 設定フォームが呼び出された際に、設定を読み直してコントロールを再構成します
        /// </summary>
        public void Load() {
            //Load Settings

            if (cm.IsContains("NewTabOpenMode")) {
                switch ((TabOpenMode)cm.GetObj("NewTabOpenMode", typeof(TabOpenMode))) {
                    case TabOpenMode.hp:
                        radioButton2.Checked = true;
                        break;
                    case TabOpenMode.any:
                        radioButton3.Checked = true;
                        textBox1.Enabled = true;
                        if (cm.IsContains("AnyPageInNewTab"))
                            this.textBox1.Text = cm.GetStr("AnyPageInNewTab");
                        else
                            this.textBox1.Text = "http;//www.google.com";
                        break;
                    case TabOpenMode.blank:
                    default:
                        radioButton1.Checked = true;
                        break;
                }

                //HomePage
                if (cm.IsContains("HomePage"))
                    textBox2.Text = cm.GetStr("HomePage");
                else //REMIND: This is temporary. Remove this!
                    textBox2.Text = "http://www.google.com";


                //SearchProvider
                listBox1.Items.Clear();
                SearchProviderInfo currentProvider = null;

                if (cm.IsContains("IsExistSearchProviders")) {
                    var fs = new FileStream(Application.StartupPath + "\\SearchProvidersList.config", FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                    var reader = XmlReader.Create(fs);
                    var serializer = new XmlSerializer(typeof(SearchProviderInfo));
                    currentSearchProvidersList.Clear();

                    reader.ReadStartElement("configuration");
                    reader.ReadStartElement("CurrentSearchProvidersList");
                    while (reader.NodeType != XmlNodeType.EndElement)
                        if (reader.NodeType != XmlNodeType.Whitespace)
                            currentSearchProvidersList.Add((SearchProviderInfo)serializer.Deserialize(reader));
                        else
                            reader.Skip();
                    reader.ReadEndElement();

                    reader.ReadStartElement("EnableSearchProvider");
                    currentProvider = (SearchProviderInfo)serializer.Deserialize(reader);
                    reader.ReadEndElement();

                    reader.Close();
                    fs.Close();
                    foreach (var item in currentSearchProvidersList)
                        listBox1.Items.Add(item.Name);
                } else {
                    currentSearchProvidersList.Clear();
                    foreach (var item in readonlyDefaultSearchProvidersList) {
                        listBox1.Items.Add(item.Name);
                        currentSearchProvidersList.Add(item);
                    }
                }


                if (cm.IsContains("EnableSearchProvider")) {
                    try { listBox1.SetSelected(listBox1.Items.IndexOf(currentProvider.Name), true); } catch {
                        try { listBox1.SetSelected(0, true); }//一番上の項目選択を試みる
                        catch {
                            /*SearchProviderが登録されていない*/
                        }
                    }
                } else//初回起動か何かでEnableSearchProviderが設定されていない
                    listBox1.SetSelected(listBox1.Items.IndexOf("Google"), true);

                if (searchProvidersEdit)
                    btAddSearchProvider_Click(null, new EventArgs());
            }
        }

        /// <summary>
        /// 設定ダイアログのModifybuttonをクリックした際に呼び出されます。
        /// </summary>
        public void Commit() {
            //NewTabOpenMode

            if (cm.IsContains("NewTabOpenMode")) {
                if (radioButton1.Checked)
                    cm.Set("NewTabOpenMode", TabOpenMode.blank);
                else if (radioButton2.Checked)
                    cm.Set("NewTabOpenMode", TabOpenMode.hp);
                else {
                    cm.Set("NewTabOpenMode", TabOpenMode.any);
                    if (cm.IsContains("AnyPageInNewTab"))
                        cm.Set("AnyPageInNewTab", this.textBox1.Text);
                    else
                        cm.Add("AnyPageInNewTab", this.textBox1.Text);
                }
            } else {
                if (radioButton1.Checked)
                    cm.Add("NewTabOpenMode", TabOpenMode.blank);
                else if (radioButton2.Checked)
                    cm.Add("NewTabOpenMode", TabOpenMode.hp);
                else {
                    cm.Add("NewTabOpenMode", TabOpenMode.any);
                    if (cm.IsContains("AnyPageInNewTab"))
                        cm.Set("AnyPageInNewTab", this.textBox1.Text);
                    else
                        cm.Add("AnyPageInNewTab", this.textBox1.Text);
                }
            }

            //HomePage

            if (cm.IsContains("HomePage"))
                cm.Set("HomePage", textBox2.Text);
            else
                cm.Add("HomePage", textBox2.Text);

            //SearchProvider
            SearchProviderInfo query = null;

            if (listBox1.SelectedItem != null) {
                if (cm.IsContains("EnableSearchProvider")) {
                    foreach (var item in currentSearchProvidersList) {
                        if (item.Name == listBox1.SelectedItem.ToString()) {
                            cm.Set("EnableSearchProvider", item.Query);
                            query = item;
                            break;
                        }
                    }
                } else {
                    foreach (var item in currentSearchProvidersList) {
                        if (item.Name == listBox1.SelectedItem.ToString()) {
                            cm.Add("EnableSearchPrivider", item.Query);
                            query = item;
                            break;
                        }
                    }
                }
            } else {
                if (listBox1.Items.Count != 0) {
                    if (cm.IsContains("EnableSearchProvider")) {
                        foreach (var item in currentSearchProvidersList) {
                            if (item.Name == listBox1.Items[0].ToString()) {
                                cm.Set("EnableSearchProvider", item.Query);
                                query = item;
                                break;
                            }
                        }
                    } else {
                        foreach (var item in currentSearchProvidersList) {
                            if (item.Name == listBox1.Items[0].ToString()) {
                                cm.Add("EnableSearchProvider", item.Query);
                                query = item;
                                break;
                            }
                        }
                    }

                } else {
                    currentSearchProvidersList.Clear();
                    foreach (var item in readonlyDefaultSearchProvidersList) {
                        listBox1.Items.Add(item.Name);
                        currentSearchProvidersList.Add(item);
                    }

                    if (cm.IsContains("EnableSearchProvider")) {
                        cm.Set("EnableSearchProvider", "http://www.google.com/search?hl=ja&q={0}");
                        query = new SearchProviderInfo("http://www.google.com/search?hl=ja&q={0}", "Google");
                    } else {
                        cm.Add("EnableSearchProvider", "http://www.google.com/search?hl=ja&q={0}");
                        query = new SearchProviderInfo("http://www.google.com/search?hl=ja&q={0}", "Google");
                    }
                }
            }// if(listBox1.SelectedItem != null)

            var fs = new FileStream(Application.StartupPath + "\\SearchProvidersList.config", FileMode.OpenOrCreate, FileAccess.ReadWrite, FileShare.ReadWrite);
            var writer = XmlWriter.Create(fs);
            var serializer = new XmlSerializer(typeof(SearchProviderInfo));

            writer.WriteStartDocument();
            writer.WriteStartElement("configuration"); writer.WriteString("\r\n");
            writer.WriteStartElement("CurrentSearchProvidersList"); writer.WriteString("\r\n");

            for (int i = 0; i < currentSearchProvidersList.Count; i++) {
                serializer.Serialize(writer, currentSearchProvidersList[i]);
                writer.WriteString("\r\n");
            }
            writer.WriteEndElement();

            writer.WriteStartElement("EnableSearchProvider");
            writer.WriteString("\r\n");
            serializer.Serialize(writer, query);
            writer.WriteString("\r\n");
            writer.WriteEndElement();

            writer.Close();
            fs.Close();

            if (cm.IsContains("IsExistSearchProviders"))
                cm.Set("IsExistSearchProviders", true);
            else
                cm.Add("IsExistSearchProviders", true);

        }

        /// <summary>
        /// 現在のページ
        /// </summary>
        private void button1_Click(object sender, System.EventArgs e) {
            textBox2.Text = ((WebBrowser_NewWindowHacked)main.tabControl1.SelectedTab.Controls[0]).Url.ToString();
        }

        /// <summary>
        /// 空白のページ
        /// </summary>
        private void button2_Click(object sender, System.EventArgs e) {
            textBox2.Text = "about:blank";
        }

        bool searchProvidersEdit = false;
        private void btAddSearchProvider_Click(object sender, EventArgs e) {
            if (searchProvidersEdit) {
                searchProvidersEdit = false;
                panel1.Visible = false;
                btAddSearchProvider.Text = lnsel.GetValue("Core_Property_btAddSearchProvider.Text");
                btRemoveSearchProvider.Text = lnsel.GetValue("Core_Property_btRemoveSearchProvider.Text");
                btAddSearchProvider.Click -= new EventHandler(AddSearchProvider);
                btAddSearchProvider.Click += new EventHandler(btAddSearchProvider_Click);
                btRemoveSearchProvider.Click -= new EventHandler(btAddSearchProvider_Click);
                btRemoveSearchProvider.Click += new EventHandler(btRemoveSearchProvider_Click);
            } else {
                searchProvidersEdit = true;
                panel1.Visible = true;
                btAddSearchProvider.Text = lnsel.GetValue("Generic_OK");
                btAddSearchProvider.Click -= new EventHandler(btAddSearchProvider_Click);
                btAddSearchProvider.Click += new EventHandler(AddSearchProvider);
                btRemoveSearchProvider.Text = lnsel.GetValue("Generic_Cancel");
                btRemoveSearchProvider.Click -= new EventHandler(btRemoveSearchProvider_Click);
                btRemoveSearchProvider.Click += new EventHandler(btAddSearchProvider_Click);
            }
        }

        void AddSearchProvider(object sender, EventArgs e) {
            if (Regex.IsMatch(tbSearchQuery.Text, "^(http://)") && Regex.IsMatch(tbSearchQuery.Text, "\\{0\\}") && !listBox1.Items.Contains(tbSearchName.Text)) {
                listBox1.Items.Add(tbSearchName.Text);
                currentSearchProvidersList.Add(new SearchProviderInfo(tbSearchQuery.Text, tbSearchName.Text));
                tbSearchName.Text = string.Empty;
                tbSearchQuery.Text = String.Empty;
                btAddSearchProvider_Click(sender, e);
            } else
                MessageBox.Show(lnsel.GetValue("Core_Property_SearchQueryIsNotAvailable"));
        }

        private void btRemoveSearchProvider_Click(object sender, EventArgs e) {
            if (listBox1.SelectedItem != null) {
                if (MessageBox.Show(String.Format(strRemoveProviderConfirm, listBox1.SelectedItem.ToString()), null, MessageBoxButtons.YesNo) == DialogResult.Yes) {
                    currentSearchProvidersList.RemoveAt(listBox1.SelectedIndex);
                    listBox1.Items.RemoveAt(listBox1.SelectedIndex);
                }
            }
        }


    }// class PropertySheet
}// namespace Bis5Products.SharpWebBrowser