////////////////////////////////////////////////////////////////////////////////
// This file is part of SHarpWebBrowser.
////////////////////////////////////////////////////////////////////////////////
// Copyright (C) 2009-2011 bis5 <bis5@users.sourceforge.jp>
// All rights reserved.
////////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the Microsoft Public Licence (Ms-PL) as published by
// Microsoft Corp.
//
// You should have received a copy of the Microsoft Public Licence along
// with this program.
// If not, see <http://www.microsoft.com/opensource/licences.mspx>
//
////////////////////////////////////////////////////////////////////////////////
//
// File information
// Name: BehaveProp.cs, BehaveProp.Designer.cs
// Author: bis5
//
////////////////////////////////////////////////////////////////////////////////

using System;
using System.Windows.Forms;

namespace Bis5Products.SharpWebBrowser {
    public partial class BehaveProp : UserControl, ISWBPropertySheet {
        private ConfigurationManager cmgr = null;
        private ILangMgr lmgr = null;

        private BehaveProp() {
            InitializeComponent();
            this.Dock = DockStyle.Fill;
        }

        public BehaveProp(ConfigurationManager cmgr, ILangMgr lmgr)
            : this() {
            this.cmgr = cmgr;
            this.lmgr = lmgr;
            lmgr.AppendDelegate(GetLangConst, true);
        }

        public void Commit() {
            if (cmgr.IsContains("Behavior_Open")) {
                cmgr.Set("Behavior_Open", (radioButton1.Checked ? "Current" : "New"));
            } else {
                cmgr.Add("Behavior_Open", (radioButton1.Checked ? "Current" : "New"));
            }

            bool _suptool = false;
            if (cmgr.IsContains("Behavior_TridentVersion")) {
                if (cmgr.GetStr("Behavior_TridentVersion") != _tridentver) _suptool = true;
            } else {
                _suptool = true;
                cmgr.Add("Behavior_TridentVersion", "4");
            }

            if (_suptool) {
                string arg = "/v ";
                switch (_tridentver) {
                    case "4":
                        arg += "7";
                        break;
                    case "5IE8":
                        arg += "8";
                        break;
                    case "5IE9":
                        arg += "9";
                        break;
                    default:
                        goto case "4";
                }
                System.Diagnostics.Process sup = new System.Diagnostics.Process();
                sup.StartInfo.FileName = System.IO.Path.Combine(Application.StartupPath, "SupportTool.exe");
                sup.StartInfo.Arguments = arg;
                try {
                    sup.Start();
                    sup.WaitForExit();
                    MessageBox.Show(lmgr.Get("SupportTool_Used"), "SharpWebBrowser", MessageBoxButtons.OK, MessageBoxIcon.Information);
                    cmgr.Set("Behavior_TridentVersion", _tridentver);
                } catch (System.ComponentModel.Win32Exception) {
                    Load();
                }

            }
        }

        public string GetPropertySheetName() {
            return lmgr.Get("Behave_PropName");
        }
        private bool _loading = false;
        public new void Load() {
            _loading = true;
            if (cmgr.IsContains("Behavior_Open")) {
                string val = null;
                switch (val = cmgr.GetStr("Behavior_Open")) {
                    case "Current":
                        radioButton1.Checked = true;
                        break;
                    case "New":
                        radioButton2.Checked = true;
                        break;
                    default:
                        goto case "Current";
                }
            } else {
                cmgr.Add("Behavior_Open", "Current");
                Load();
            }
            _loading = true;
            if (cmgr.IsContains("Behavior_TridentVersion")) {
                string val = null;
                switch (cmgr.GetStr("Behavior_TridentVersion")) {
                    case "4":
                        radioV4IE7.Checked=true;
                        break;
                    case "5IE8":
                        radioV5IE8.Checked=true;
                        break;
                    case "5IE9":
                        radioV5IE9.Checked=true;
                        break;
                    default:
                        goto case "4";
                }
            } else {
                cmgr.Add("Behavior_TridentVersion", "4");
                Load();
            }
            _loading = false;
        }

        private void GetLangConst() {
            groupBox1.Text = lmgr.Get("Behavior_OpenBehave");
            radioButton1.Text = lmgr.Get("Behavior_OpenBehave_Current");
            radioButton2.Text = lmgr.Get("Behavior_OpenBehave_New");
            groupBoxTridentVersion.Text = lmgr.Get("Behavior_groupBoxTridentVersion");
            radioV4IE7.Text = lmgr.Get("Behavior_radioV4IE7");
            radioV5IE8.Text = lmgr.Get("Behavior_radioV5IE8");
            radioV5IE9.Text = lmgr.Get("Behavior_radioV5IE9");
        }

        private string _tridentver = "4";
        /*Behavior_TridentVersion*/
        private void radioV4IE7_CheckedChanged(object sender, EventArgs e) {
            if (!_loading) cmgr.SetButtonUac();
            _tridentver = "4";
        }

        private void radioV5IE8_CheckedChanged(object sender, EventArgs e) {
            if (!_loading) cmgr.SetButtonUac();
            _tridentver = "5IE8";
        }

        private void radioV5IE9_CheckedChanged(object sender, EventArgs e) {
            if (!_loading) cmgr.SetButtonUac();
            _tridentver = "5IE9";
        }

    }
}
