﻿///////////////////////////////////////////////////////////////////////////////
// This file is part of SharpWebBrowser.
///////////////////////////////////////////////////////////////////////////////
// Copyright (C) 2009-2011 bis5 <bis5@users.sourceforge.jp>
// All rights reserved.
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the Microsoft Public Licence (Ms-PL) as published by 
// Microsoft Corp.
//
// You should have received a copy of the Microsoft Public License along 
// with this program. 
// If not, see <http://www.microsoft.com/opensource/licenses.mspx>
//
///////////////////////////////////////////////////////////////////////////////
//
// File information
// Name: ISWBPlugin.cs
// Author: bis5
//
///////////////////////////////////////////////////////////////////////////////

/**
 * Caution:
 * プラグインシステム新設予定のため、将来的にこのファイルは削除されます。
 * 記述されているインターフェース等を使用しないでください。
 */

namespace Bis5Products.SharpWebBrowser
{
    [System.Obsolete("Interface is NOT completeness!", false)]
    public interface ISWBPlugin
    {
        /// <summary>
        /// プラグインからバージョン情報ダイアログに表示する情報を取得します。
        /// </summary>
        /// <returns>プラグインの情報を格納したstringの配列。名前、バージョン情報、作者名、クラスライブラリファイル名の順に格納します。</returns>
        string[] GetPluginVersion();

        /// <summary>
        /// プラグインのプロパティシートの名称を取得します。
        /// </summary>
        /// <returns>プロパティシートの名称を表すstring文字列。</returns>
        string GetPropertyTitle();

        /// <summary>
        /// プラグインのプロパティシートを取得します。
        /// </summary>
        /// <returns>Bis5Products.SimpleWebBrowser.ISWBPropertySheetを実装したSystem.Windows.Forms.UserControl</returns>
        ISWBPropertySheet GetPropertySheet();

        /// <summary>
        /// 設定の変更を適用します。
        /// </summary>
        void ModifySetting();

        /// <summary>
        /// Guid認証を行います
        /// </summary>
        /// <param name="guid">認証を行うSystem.Guid</param>
        /// <returns>認証の是非を表すbool値</returns>
        bool GuidAuth(System.Guid guid);
    }// interface ISWBPlugin

    public interface ISWBPluginConnecter
    {
        /// <summary>
        /// Configダイアログにプロパティシートを追加します。
        /// </summary>
        void AddPropertySheet();

    }

    public interface ISWBPropertySheet
    {
        /// <summary>
        /// 設定ダイアログのModifybuttonをクリックした際に呼び出されます。
        /// </summary>
        void Commit();

        /// <summary>
        /// 設定フォームが呼び出された際に、設定を読み直してコントロールを再構成します
        /// </summary>
        void Load();

        string GetPropertySheetName();
    }
}// namespace Bis5Products.SharpWebBrowser
