///////////////////////////////////////////////////////////////////////////////
// This file is part of SharpWebBrowser.
///////////////////////////////////////////////////////////////////////////////
// Copyright (C) 2009-2011 bis5 <bis5@users.sourceforge.jp>
// All rights reserved.
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can reddistribute it and/or modify it
// under the terms of the Microsoft Public Licence (Ms-PL) as published by
// Microsoft Corp.
//
// You should  have received a copy of the Microsoft Public Licence along
// with this program.
// If not, see <http://www.microsoft.com/opensource/licence.aspx>
//
///////////////////////////////////////////////////////////////////////////////
//
// File information
// Name: ErrorReportingDialog.cs, ErrorReportingDialog.Designer.cs
// Author: bis5
//
///////////////////////////////////////////////////////////////////////////////

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Bis5Products.SharpWebBrowser {
    public partial class ErrorReportingDialog : Form {
        public ErrorReportingDialog(Exception ex) {
            InitializeComponent();
            this.FormClosing += new FormClosingEventHandler(ErrorReportingDialog_FormClosing);
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.TopMost = true;
            textBox1.Text += "To: bis5@users.sourceforge.jp\r\n";
            textBox1.Text += "[Version]\r\n\t" + Application.ProductVersion;
            textBox1.Text += "\r\n[Exception]\r\n\t" + ex.GetType().Name;
            textBox1.Text += "\r\n[Message]\r\n\t" + ex.Message + "\r\n[Source]\r\n\t" + ex.Source + "\r\n[StackTrace]\r\n" + ex.StackTrace;
            textBox1.Text += "\r\n\r\n---\r\n・エラー発生時の操作：\r\n\r\n・Windows以外で使用している方は、ここを削除してください";
            textBox1.ReadOnly = true;
            textBox1.WordWrap = false;
            this.button1.Text = "Restart";
            this.button2.Text = "Exit";
            this.CancelButton = button2;
        }

        void ErrorReportingDialog_FormClosing(object sender, FormClosingEventArgs e) {
            if (this.DialogResult == DialogResult.None)
                this.DialogResult = DialogResult.OK;
        }

        private void button1_Click(object sender, EventArgs e) {
            this.DialogResult = DialogResult.Yes;
            this.Close();
            this.Dispose();
        }

        private void button2_Click(object sender, EventArgs e) {
            this.DialogResult = DialogResult.OK;
            this.Close();
            this.Dispose();
        }

    }
}
