﻿///////////////////////////////////////////////////////////////////////////////
// This file is part of SharpWebBrowser.
///////////////////////////////////////////////////////////////////////////////
// Copyright (C) 2009-2011 bis5 <bis5@users.sourceforge.jp>
// All rights reserved.
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the Microsoft Public Licence (Ms-PL) as published by 
// Microsoft Corp.
//
// You should have received a copy of the Microsoft Public License along 
// with this program. 
// If not, see <http://www.microsoft.com/opensource/licenses.mspx>
//
///////////////////////////////////////////////////////////////////////////////
//
// File information
// Name: VerInfoDialog.cs, VerInfoDialog.Designer.cs
// Author: bis5
//
///////////////////////////////////////////////////////////////////////////////

using System;
using System.Collections.Generic;
using System.Reflection;
using System.Windows.Forms;

namespace Bis5Products.SharpWebBrowser.Dialogs {
    partial class VerInfoDialog : Form {
        /// <summary>
        /// <see cref="Bis5Products.SharpWebBrowser.Dialogs.VerInfoDialog"/>の新しいインスタンスを開始します。
        /// </summary>
        /// <param name="buildDate">デバッグ構成用ビルド日時</param>
        public VerInfoDialog(DateTime buildDate)
            : this() {
#if DEBUG
            textBoxDescription.Text += "This is Test Version!";
            textBoxDescription.Text += "\r\n   Build at: " + buildDate.Date.ToString();
            textBoxDescription.Text += "\r\nCommandLine: \r\n" + Environment.CommandLine;
#endif
        }

        /// <summary>
        /// <see cref="VerInfoDialog"/>の新しいインスタンスを開始します。
        /// </summary>
        public VerInfoDialog() {
            InitializeComponent();
            this.Text = String.Format("{0} のバージョン情報 {0}", AssemblyTitle);
            this.labelProductName.Text = AssemblyProduct;
            this.labelVersion.Text = String.Format("バージョン {0}", AssemblyVersion[0]);
            this.labelCopyright.Text = AssemblyCopyright;
            this.labelCompanyName.Text = AssemblyCompany;
            this.textBoxDescription.Text = AssemblyDescription;
        }

        #region アセンブリ属性アクセサ

        /// <summary>
        /// 実行中のアセンブリの名称を取得します。
        /// </summary>
        public string AssemblyTitle {
            get {
                object[] attributes = Assembly.GetExecutingAssembly().GetCustomAttributes(typeof(AssemblyTitleAttribute), false);
                if (attributes.Length > 0) {
                    AssemblyTitleAttribute titleAttribute = (AssemblyTitleAttribute)attributes[0];
                    if (titleAttribute.Title != "") {
                        return titleAttribute.Title;
                    }
                }
                return System.IO.Path.GetFileNameWithoutExtension(Assembly.GetExecutingAssembly().CodeBase);
            }
        }

        /// <summary>
        /// 実行中のアセンブリのバージョン番号を取得します。
        /// </summary>
        public string[] AssemblyVersion {
            get {
                string[] ret = new string[2] { null, null };
                ret[0] = Assembly.GetExecutingAssembly().GetName().Version.ToString() + " ";
                ret[1] = ((AssemblyFileVersionAttribute)(Assembly.GetExecutingAssembly().GetCustomAttributes(typeof(AssemblyFileVersionAttribute), false))[0]).Version.ToString();
                return ret;
            }
        }

        /// <summary>
        /// 実行中のアセンブリの説明を取得します。
        /// </summary>
        public string AssemblyDescription {
            get {
                object[] attributes = Assembly.GetExecutingAssembly().GetCustomAttributes(typeof(AssemblyDescriptionAttribute), false);
                if (attributes.Length == 0) {
                    return "";
                }
                return ((AssemblyDescriptionAttribute)attributes[0]).Description;
            }
        }

        /// <summary>
        /// 実行中のアセンブリのプロダクト名を取得します。
        /// </summary>
        public string AssemblyProduct {
            get {
                object[] attributes = Assembly.GetExecutingAssembly().GetCustomAttributes(typeof(AssemblyProductAttribute), false);
                if (attributes.Length == 0) {
                    return "";
                }
                return ((AssemblyProductAttribute)attributes[0]).Product;
            }
        }

        /// <summary>
        /// 実行中のアセンブリの著作権表示を取得します。
        /// </summary>
        public string AssemblyCopyright {
            get {
                object[] attributes = Assembly.GetExecutingAssembly().GetCustomAttributes(typeof(AssemblyCopyrightAttribute), false);
                if (attributes.Length == 0) {
                    return "";
                }
                return ((AssemblyCopyrightAttribute)attributes[0]).Copyright;
            }
        }

        /// <summary>
        /// 実行中のアセンブリを制作した会社(組織)を取得します。
        /// </summary>
        public string AssemblyCompany {
            get {
                object[] attributes = Assembly.GetExecutingAssembly().GetCustomAttributes(typeof(AssemblyCompanyAttribute), false);
                if (attributes.Length == 0) {
                    return "";
                }
                return ((AssemblyCompanyAttribute)attributes[0]).Company;
            }
        }
        #endregion
    }// class VerInfoDialog
}// namespace Bis5Products.SharpWebBrowser.Dialogs
