package jp.ac.titech.sharp4k.cuten;

import java.io.File;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;

public class Teacher {
	private static final String TAG = Teacher.class.getSimpleName();

	private int id;
	private String name;
	private String iconPath;

	public Teacher(int id, String name, String iconPath) {
		this.id = id;
		this.name = name;
		this.iconPath = iconPath;
	}

	public int getId() {
		return id;
	}

	public String getName() {
		return name;
	}

	public String getIconPath() {
		return iconPath;
	}

	public static Teacher find(SQLiteDatabase db, int id) {
		try {
			Cursor c = db.rawQuery("SELECT teachers.name, teachers.icon_path"
					+ " FROM teachers WHERE teachers.id = ? LIMIT 1",
					new String[] { String.valueOf(id) });
			if (c.moveToNext()) {
				Teacher t = new Teacher(id, c.getString(0), c.getString(1));
				c.close();
				return t;
			} else {
				return null;
			}
		} catch (SQLException e) {
			e.printStackTrace();
			return null;
		}
	}

	public long save(SQLiteDatabase db, Context context) {
		Teacher old = Teacher.find(db, getId());
		if (old != null && old.getIconPath() != null
				&& !old.getIconPath().equals(getIconPath())) {
			Log.d(TAG,
					"[" + getId() + "] Delete old cache " + old.getIconPath());
			old.getIconCacheFile(context).delete();
		}
		return replace(db);
	}

	public long replace(SQLiteDatabase db) {
		ContentValues row = new ContentValues();
		row.put("id", getId());
		row.put("name", getName());
		row.put("icon_path", getIconPath());
		return db.insertWithOnConflict("teachers", null, row,
				SQLiteDatabase.CONFLICT_REPLACE);
	}

	public File getIconCacheFile(Context context) {
		if (iconPath == null) {
			return null;
		} else {
			String baseName = new File(iconPath).getName();
			return new File(context.getDir("icons", Context.MODE_PRIVATE),
					baseName);
		}
	}
}
