package jp.ac.titech.sharp4k.cuten;

import org.apache.http.StatusLine;
import org.json.JSONException;
import org.json.JSONObject;

import roboguice.activity.RoboActivity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;

import com.google.inject.Inject;

public abstract class BaseMenuActivity extends RoboActivity {
	private static final String TAG = BaseMenuActivity.class.getSimpleName();

	private static final int MENU_ID_MENU_ABOUT = (Menu.FIRST + 1);
	private static final int MENU_ID_MENU_TOKEN = (Menu.FIRST + 2);
	private static final int MENU_ID_MENU_RECORD = (Menu.FIRST + 3);
	private static final int MENU_ID_MENU_RESETTOKEN = (Menu.FIRST + 4);

	@Inject
	private HttpAPIClient apiClient;
	ProgressDialog pDialog;

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// メニューアイテム
		menu.add(Menu.NONE, MENU_ID_MENU_ABOUT, Menu.NONE, "About");
		menu.add(Menu.NONE, MENU_ID_MENU_TOKEN, Menu.NONE, "Token Auth");
		menu.add(Menu.NONE, MENU_ID_MENU_RECORD, Menu.NONE, "Record");
		menu.add(Menu.NONE, MENU_ID_MENU_RESETTOKEN, Menu.NONE, "Reset Token");
		return super.onCreateOptionsMenu(menu);
	}

	@Override
	public boolean onPrepareOptionsMenu(Menu menu) {
		return super.onPrepareOptionsMenu(menu);
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		boolean ret = true;
		Intent intent;
		switch (item.getItemId()) {
		case MENU_ID_MENU_ABOUT:
			// Aboutアクティビティに遷移
			intent = new Intent(this, AboutActivity.class);
			startActivity(intent);
			break;
		case MENU_ID_MENU_TOKEN:
			// TokenAuthenticationアクティビティに遷移
			intent = new Intent(this, TokenAuthenticationActivity.class);
			startActivity(intent);
			break;
		case MENU_ID_MENU_RECORD:
			// Recordアクティビティに遷移
			intent = new Intent(this, RecordActivity.class);
			startActivity(intent);
			break;
		case MENU_ID_MENU_RESETTOKEN:
			if (Token.isExist(this)) {
				resetToken();
			} else {
				showAlertDialog("トークンがありません。先に認証トークンを生成してください。");
			}
			break;
		default:
			ret = super.onOptionsItemSelected(item);
			break;
		}
		return ret;
	}

	// 警告ダイアログ
	public void showAlertDialog(String message) {
		new AlertDialog.Builder(this).setTitle("警告").setMessage(message)
				.setPositiveButton("OK", new DialogInterface.OnClickListener() {
					@Override
					public void onClick(DialogInterface dialog, int which) {
					}
				}).setCancelable(false).show();
	}

	// プログレスダイアログ(サーバとの通信中に表示)
	public void showProgressDialog(String message) {
		pDialog = new ProgressDialog(this);
		pDialog.setTitle("通信中");
		pDialog.setMessage(message);
		pDialog.setProgressStyle(ProgressDialog.STYLE_SPINNER);
		pDialog.setCancelable(false);
		pDialog.show();
	}

	// プログレスダイアログを非表示にする
	public void dismissProgressDialog() {
		pDialog.dismiss();
	}

	private void resetToken() {
		// トークンリセット
		showProgressDialog("リセット中・・・");
		apiClient.resetToken(Token.load(this),
				new SimpleHttpResponseListener() {
					@Override
					public void preExec() {
						dismissProgressDialog();
					}

					@Override
					public void onSuccess(String result) {
						// 認証成功
						try {
							JSONObject root = new JSONObject(result);
							// トークンをローカルファイルとして保存
							String token = root.getString("auth_token");
							Token.delete(BaseMenuActivity.this);
							Token.save(token, BaseMenuActivity.this);
							showAlertDialog("トークンのリセットに成功しました！");
						} catch (JSONException e) {
							e.printStackTrace();
						}
					}

					@Override
					public void onUnauthorized() {
						// 認証に失敗
						showAlertDialog("認証に失敗しました。トークンが正しいか確認してください。");
					}

					@Override
					public void onFailure(Exception e) {
						// ネットワークエラー
						showAlertDialog("ネットワークエラーが発生しました。もう一度試してください。");
						e.printStackTrace();
					}

					@Override
					public void onHttpFailure(StatusLine status, String body) {
						showAlertDialog("ネットワークエラーが発生しました。もう一度試してください。");
						Log.e(TAG,
								"resetToken: returned "
										+ status.getStatusCode());
					}
				});
	}
}
