package jp.ac.titech.sharp4k.cuten;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;

public class AchievementsConsumer {
	private final Context context;
	private final BlockingQueue<Achievement> queue;
	private final HttpAPIClient apiClient;
	private final ScheduledExecutorService executor;
	private static final ThreadFactory THREAD_FACTORY = new ThreadFactory() {
		@Override
		public Thread newThread(Runnable r) {
			return new Thread(r, "AchievementsConsumer thread pool");
		}
	};

	public AchievementsConsumer(Context context,
			BlockingQueue<Achievement> queue, HttpAPIClient apiClient) {
		this.context = context;
		this.queue = queue;
		this.apiClient = apiClient;
		this.executor = Executors.newScheduledThreadPool(1, THREAD_FACTORY);
	}

	public void start() {
		SQLiteDatabase db = new SQLHelper(context).getReadableDatabase();
		queue.addAll(Achievement.findNotSubmitted(db));
		db.close();

		executor.schedule(new AchievementsSenderTask(executor, context, queue,
				apiClient), 0, TimeUnit.SECONDS);
	}

	public void stop() {
		executor.shutdown();
	}
}
