require 'java'

module SdkLib
  def self.init(sdk)
    unless defined? ApkBuilder
      require sdk.tools.join('lib', 'sdklib.jar').to_s
      include_package 'com.android.sdklib.build'
      import ApkBuilder
    end
  end

  # https://android.googlesource.com/platform/sdk/+/master/sdkmanager/libs/sdklib/src/com/android/sdklib/build/ApkBuilder.java
  def apkbuilder(apk_path, res_path, dex_path)
    buf = Java::JavaIo::ByteArrayOutputStream.new
    builder = ApkBuilder.new apk_path, res_path, dex_path, nil, Java::JavaIo::PrintStream.new(buf)
    builder.debug_mode = true
    builder.seal_apk
    puts buf.to_string
  end
  module_function :apkbuilder
end
