require 'rexml/document'
require 'rake/tasklib'
$LOAD_PATH.unshift File.expand_path('../../tools/lib', __FILE__)
require 'cuten_app'

module REXML
  module ResourcesBuilder
    def string_array(name)
      add_element 'string-array', 'name' => name
    end

    def integer_array(name)
      add_element 'integer-array', 'name' => name
    end

    def array(name)
      add_element 'array', 'name' => name
    end

    def item(text)
      add_element('item').add_text text
    end

    def resources
      add_element 'resources'
    end

    def string(name, text)
      add_element('string', 'name' => name).add_text text
    end
  end

  module UTF8Document
    def initialize(*)
      super
      self << XMLDecl.new('1.0', 'UTF-8')
    end
  end

  Element.send :include, ResourcesBuilder
  Document.send :include, UTF8Document
end

class Rake::QATask < Rake::TaskLib
  def initialize(name)
    @name = name
  end

  def define
    app_name = "QA-#{@name}"
    project = Android::Project.new app_name
    sdk = Android::Sdk.new ENV['ANDROID_HOME'], project

    namespace @name do
      task = Rake::CutenAppTask.new(sdk)
      task.before_resources do
        generate_resources
      end
      task.define_all
    end
  end

  def generate_resources
    input_path = Pathname.new('.').join('qa').join("#{@name}.txt")
    doc = REXML::Document.new

    input_path.open('r:utf-8') do |f|
      title = f.gets.chomp
      open('res/values/strings.xml', 'w:utf-8') do |out|
        doc2 = REXML::Document.new
        doc2.resources.tap do |res|
          res.string 'app_name', 'Q and A'
          res.string 'first', title
        end
        doc2.write out, 4
        out.puts
      end

      res = doc.resources
      answers = res.integer_array 'answers'
      while ans = f.gets and !ans.chomp!.empty?
        answers.item ans
      end

      questions = res.string_array 'questions'
      choices = res.array 'choices'
      answers.size.times do |i|
        q = ''
        while line = f.gets and !line.chomp!.empty?
          q += "#{line}\\n"
        end
        questions.item q

        choices.item "@array/q#{i}"
        choice = res.string_array "q#{i}"
        while line = f.gets and !line.chomp!.empty?
          choice.item line
        end
      end
    end

    open('res/values/array.xml', 'w:utf-8') do |f|
      doc.write f, 4
      f.puts
    end
  end
end
