package jp.ac.titech.sharp4k.cuten.sampletask.polychoron;

import android.opengl.Matrix;

public class PolychoronVertex {
	public float v4[];
	private float[] m1 = new float[16];
	public float v3[] = new float[4];
	private float[] m2 = new float[16];
	private float[] m1u = new float[16];
	private float[] ms = new float[16];

	public PolychoronVertex() {
		Matrix.setIdentityM(m1, 0);
		Matrix.setIdentityM(m1u, 0);
		Matrix.setIdentityM(m2, 0);
		Matrix.setIdentityM(ms, 0);
	}

	public void nextStep() {
		addConvert1(m1u);
	}

	public void setScale(float s) {
		Matrix.setIdentityM(ms, 0);
		Matrix.scaleM(ms, 0, s, s, s);
	}

	public void convert1() {
		Matrix.multiplyMV(v3, 0, m1, 0, v4, 0);
		v3[3] = 1;
	}

	public void addConvert1(float[] m) {
		Matrix.multiplyMM(m1, 0, m, 0, m1, 0);
	}

	public void addConvert2(float[] m) {
		Matrix.multiplyMM(m2, 0, m, 0, m1, 0);
	}

	public void setConvert1(float[] m) {
		m1 = m;
	}

	public void setConvert1u(float[] m) {
		m1u = m;
	}

	public void setConvert2(float[] m) {
		m2 = m;
	}

	public void convert2() {
		Matrix.multiplyMV(v3, 0, ms, 0, v3, 0);
		Matrix.multiplyMV(v3, 0, m2, 0, v3, 0);
	}


	public static float[] rotateUX(float[] m,float u) {
		Matrix.setIdentityM(m, 0);
		m[0]=(float) Math.cos(u);
		m[3]=(float) -Math.sin(u);
		m[12]=(float) Math.sin(u);
		m[15]=(float) Math.cos(u);
		return m;
	}

	public static float[] rotateUY(float[] m,float u) {
		Matrix.setIdentityM(m, 0);
		m[5]=(float) Math.cos(u);
		m[7]=(float) -Math.sin(u);
		m[13]=(float) Math.sin(u);
		m[15]=(float) Math.cos(u);
		return m;
	}

	public static float[] rotateUZ(float[] m,float u) {
		Matrix.setIdentityM(m, 0);
		m[10]=(float) Math.cos(u);
		m[11]=(float) -Math.sin(u);
		m[14]=(float) Math.sin(u);
		m[15]=(float) Math.cos(u);
		return m;
	}
}
