package jp.ac.titech.sharp4k.cuten.sampletask.polychoron;
/*
 * 構成立体：正四面体5個
 * 構成面：10枚
 * 辺：10
 * 頂点：5
 * 双対：自己双対多胞体
 * シュレーフリの記号：{3,3,3}
 * (wikipediaより)
 */
public class PentachoronObj extends PolychoronObj {
	PentachoronObj(float[] v) {
		super(v);
	}
	public PentachoronObj(float size){
		float f=(float)((1-Math.sqrt(5))/4);
		float[] v={1,0,0,0, 0,1,0,0, 0,0,1,0, 0,0,0,1, f,f,f,f,};
		for(int i=0; i < v.length; i++){
			v[i] *= size;
		}
		int[] e={0,1, 0,2, 0,3, 0,4, 1,2, 1,3, 1,4, 2,3, 2,4, 3,4};
		this.vertex = v;
		init();
		edges = new PolychoronVertex[e.length];
		for(int i=0; i < e.length; i++){
			edges[i] = vertexList[e[i]];
		}
	}
	@Override
	public int getPlaneNum() {
		return 10;
	}
}
