package jp.ac.titech.sharp4k.cuten.sampletask.polychoron;
/*
 * 構成立体：立方体8個
 * 構成面：正方形24枚
 * 辺：32の各辺に立方体3個が集まる。
 * 頂点：16の各頂点に立方体4個が集まる。
 * 双対：正十六胞体
 * シュレーフリの記号：{4,3,3}
 * (wikipediaより)
 */
public class OctachoronObj extends PolychoronObj {
	OctachoronObj(float[] v) {
		super(v);
	}
	public OctachoronObj(float size){
		float[] v={1,1,1,1, 1,1,-1,1, 1,-1,-1,1, 1,-1,1,1,  -1,1,1,1, -1,1,-1,1, -1,-1,-1,1, -1,-1,1,1,
				1,1,1,-1, 1,1,-1,-1, 1,-1,-1,-1, 1,-1,1,-1,  -1,1,1,-1, -1,1,-1,-1, -1,-1,-1,-1, -1,-1,1,-1};
		for(int i=0; i < v.length; i++){
			v[i] *= size;
		}
		int[] e={0,1, 0,3, 0,4, 1,2, 1,5, 2,3, 2,6, 3,7, 4,5, 4,7, 5,6, 6,7,
				0+8,1+8, 0+8,3+8, 0+8,4+8, 1+8,2+8, 1+8,5+8, 2+8,3+8, 2+8,6+8, 3+8,7+8, 4+8,5+8, 4+8,7+8, 5+8,6+8, 6+8,7+8, 
				0,8, 1,9, 2,10, 3,11, 4,12, 5,13, 6,14, 7,15
		};
		this.vertex = v;
		init();
		edges = new PolychoronVertex[e.length];
		for(int i=0; i < e.length; i++){
			edges[i] = vertexList[e[i]];
		}
	}
	@Override
	public int getPlaneNum() {
		return 24;
	}
}
