package jp.ac.titech.sharp4k.cuten.sampletask.polychoron;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.concurrent.TimeUnit;

import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

import jp.ac.titech.sharp4k.cuten.R;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.opengl.GLSurfaceView.Renderer;
import android.opengl.GLUtils;
import android.opengl.Matrix;

public class GameRender implements Renderer {
	private GLSurfaceView view;
	private ScreenInfo screen;
	private int program;
	// シェーダの各点の情報
	private int aPositionIndex;
	private int uvHandle;
	// 頂点の大きさ
	float elPosition[] = { -0.1f, -0.1f, 0.01f, 0.1f, -0.1f, 0.01f, -0.1f,
			0.1f, 0.01f, 0.1f, 0.1f, 0.01f };
	float edgeR = 0.5f;// 辺の太さ
	private FloatBuffer elPositionBuffer;
	private FloatBuffer lineBuffer;
	private int vTexture; // 頂点テクスチャのインデックス
	private int lineTexture; // 辺テクスチャのインデックス
	private float[] viewMatrix = new float[16];// ビュー行列
	private int viewMatrixIndex;
	private float[] projMatrix = new float[16];// ビュー行列
	private int projMatrixIndex;
	private float[] modelMatrix = new float[16];// ビュー行列
	private int modelMatrixIndex;

	// バーテックスシェーダのコード
	private static final String vertexShaderCode = "attribute vec4 a_Position;\n"
			+ "attribute vec2 a_UV;\n"
			+ "varying vec2 v_UV;\n"
			+ "uniform mat4 u_MatView;\n"
			+ "uniform mat4 u_MatProj;\n"
			+ "uniform mat4 u_MatModel;\n"
			+ "void main()"
			+ "{"
			// + "gl_PointSize = a_Size;"
			+ "gl_Position = (u_MatProj*u_MatView*u_MatModel)*a_Position;"
			+ "v_UV=a_UV;" + "}";
	// フラグメントシェーダのコード
	private static final String fragmentShaderCode = "precision mediump float;"
			+ "uniform sampler2D u_Texture;\n" + "varying vec2 v_UV;\n"
			+ "void main()" + "{" + "vec4 color;"
			+ "color = texture2D(u_Texture,v_UV);"//
			+ "gl_FragColor = color;" + "}";

	// 表示する多胞体オブジェクト
	public PolychoronObj obj;
	// cuten
	// リソース指定
	public Resources resouce;

	public GameRender(GLSurfaceView view, ScreenInfo aScreen, PolychoronObj obj) {
		this.view = view;
		screen = aScreen;
		this.obj = obj;
	}

	FloatBuffer triangleVB;
	FloatBuffer textureBuffer;
	FloatBuffer textureBuffer2;

	// スクリーンサイズに応じた計算
	private void scalePos(float pos[]) {
		for (int i = 0; i < pos.length / 3; i++) {// 移動してからスケール
			pos[i * 3 + 0] -= screen.centerX;
			pos[i * 3 + 0] *= screen.scale;
			pos[i * 3 + 1] -= screen.centerY;
			pos[i * 3 + 1] *= screen.scale;
			pos[i * 3 + 2] *= screen.scale;
		}
	}

	// 3次元ベクトルの正規化
	private void normalize(float[] v) {
		double d = Math.sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
		v[0] /= d;
		v[1] /= d;
		v[2] /= d;
	}

	private float ballPosition[] = new float[5 * 2 * 3];
	private PolychoronVertex[] drawEdge = new PolychoronVertex[2];
	float[] tempVec = new float[3];
	float[] axisA = new float[3];
	float[] axisB = new float[3];

	public void update() {
		// 表示位置決定
		obj.nextStep();
	}
	@Override
	// ここで描画
	public void onDrawFrame(GL10 gl) {
		// 描画クリア
		GLES20.glClear(GLES20.GL_COLOR_BUFFER_BIT | GLES20.GL_DEPTH_BUFFER_BIT);
		// 位置指定の有効化
		GLES20.glEnable(GLES20.GL_DEPTH_TEST);
		GLES20.glEnableVertexAttribArray(aPositionIndex);
		GLES20.glEnableVertexAttribArray(uvHandle);
		// 画像の透過の有効化
		GLES20.glBlendFunc(GLES20.GL_SRC_ALPHA, GLES20.GL_ONE_MINUS_SRC_ALPHA);
		GLES20.glEnable(GLES20.GL_BLEND);
		Matrix.setIdentityM(modelMatrix, 0);
		Matrix.rotateM(modelMatrix, 0, 0.2f, 0, 1, 0);
		obj.update();
		obj.sort();
		
		// 辺
		for (int i = 0; i < obj.getEdgeNum() / 2; i++) {
			obj.getEdge(drawEdge, i);
			float[] b1 = drawEdge[0].v3;
			float[] b2 = drawEdge[1].v3;
			tempVec[0] = b1[0] - b2[0];
			tempVec[1] = b1[1] - b2[1];
			tempVec[2] = b1[2] - b2[2];
			normalize(tempVec);
			//
			axisA[0] = -tempVec[1];
			axisA[1] = tempVec[0];
			axisA[2] = 0;
			if (-tempVec[1] == 0 && tempVec[0] == 0) {
				axisA[1] = -tempVec[2];
				axisA[2] = tempVec[1];
			}

			normalize(axisA);
			axisB[0] = axisA[1] * tempVec[2] - axisA[2] * tempVec[1];
			axisB[1] = axisA[2] * tempVec[0] - axisA[0] * tempVec[2];
			axisB[2] = axisA[0] * tempVec[1] - axisA[1] * tempVec[0];
			for (int k = 0; k < 3; k++) {
				axisA[k] *= 0.05;
				axisB[k] *= 0.05;
			}

			for (int j = 0; j < ballPosition.length / 2 / 3; j++) {
				ballPosition[j * 6 + 0] = (float) (b1[0]
						+ Math.cos(j * 3.14 * 2 / 4.0) * axisA[0] * edgeR + Math
						.sin(j * 3.14 * 2 / 4.0) * axisB[0] * edgeR);
				ballPosition[j * 6 + 1] = (float) (b1[1]
						+ Math.cos(j * 3.14 * 2 / 4.0) * axisA[1] * edgeR + Math
						.sin(j * 3.14 * 2 / 4.0) * axisB[1] * edgeR);
				ballPosition[j * 6 + 2] = (float) (b1[2]
						+ Math.cos(j * 3.14 * 2 / 4.0) * axisA[2] * edgeR + Math
						.sin(j * 3.14 * 2 / 4.0) * axisB[2] * edgeR);
				ballPosition[j * 6 + 3] = (float) (b2[0]
						+ Math.cos(j * 3.14 * 2 / 4.0) * axisA[0] * edgeR + Math
						.sin(j * 3.14 * 2 / 4.0) * axisB[0] * edgeR);
				ballPosition[j * 6 + 4] = (float) (b2[1]
						+ Math.cos(j * 3.14 * 2 / 4.0) * axisA[1] * edgeR + Math
						.sin(j * 3.14 * 2 / 4.0) * axisB[1] * edgeR);
				ballPosition[j * 6 + 5] = (float) (b2[2]
						+ Math.cos(j * 3.14 * 2 / 4.0) * axisA[2] * edgeR + Math
						.sin(j * 3.14 * 2 / 4.0) * axisB[2] * edgeR);
			}
			// 位置指定
			setFloatBuffer(lineBuffer, ballPosition);

			GLES20.glActiveTexture(GLES20.GL_TEXTURE0);
			GLES20.glBindTexture(GLES20.GL_TEXTURE_2D, lineTexture);
			// 位置指定
			GLES20.glVertexAttribPointer(uvHandle, 2, GLES20.GL_FLOAT, false,
					0, textureBuffer2);
			GLES20.glVertexAttribPointer(aPositionIndex, 3, GLES20.GL_FLOAT,
					false, 0, lineBuffer);
			GLES20.glUniformMatrix4fv(modelMatrixIndex, 1, false, modelMatrix,
					0);
			GLES20.glEnableVertexAttribArray(uvHandle);
			GLES20.glEnableVertexAttribArray(aPositionIndex);
			GLES20.glDrawArrays(GLES20.GL_TRIANGLE_STRIP, 0, 10);
		}
		// 頂点
		for (int i = 0; i < obj.getVertexNum(); i++) {
			// 位置指定
			setFloatBuffer(elPositionBuffer, elPosition);
			// 画像の指定
			GLES20.glActiveTexture(GLES20.GL_TEXTURE0);
			GLES20.glBindTexture(GLES20.GL_TEXTURE_2D, vTexture);
			// 転送
			GLES20.glVertexAttribPointer(uvHandle, 2, GLES20.GL_FLOAT, false,
					0, textureBuffer);
			GLES20.glVertexAttribPointer(aPositionIndex, 3, GLES20.GL_FLOAT,
					false, 0, elPositionBuffer);
			//
			obj.copyMatrix3d(modelMatrix, i);
			GLES20.glUniformMatrix4fv(viewMatrixIndex, 1, false, viewMatrix, 0);
			GLES20.glUniformMatrix4fv(projMatrixIndex, 1, false, projMatrix, 0);
			GLES20.glUniformMatrix4fv(modelMatrixIndex, 1, false, modelMatrix,
					0);
			GLES20.glEnableVertexAttribArray(uvHandle);
			GLES20.glEnableVertexAttribArray(aPositionIndex);
			GLES20.glDrawArrays(GLES20.GL_TRIANGLE_STRIP, 0, 4);
		}

		// 位置指定の無効化
		GLES20.glDisable(aPositionIndex);
		GLES20.glDisable(uvHandle);
	}

	// 透視変換の指定
	public static void gluPerspective(float[] m, float angle, float aspect,
			float near, float far) {
		float top = near * (float) Math.tan(angle * (Math.PI / 360.0));
		float bottom = -top;
		float left = bottom * aspect;
		float right = top * aspect;
		Matrix.frustumM(m, 0, left, right, bottom, top, near, far);
	}

	@Override
	public void onSurfaceChanged(GL10 gl, int width, int height) {
		screen.w = width;
		screen.h = height;
		GLES20.glViewport(0, 0, width, height);
		float ratio = width / (float) height;
		Matrix.frustumM(projMatrix, 0, -ratio, ratio, -1, 1, 3, 10);
	}

	@Override
	// 初期化
	public void onSurfaceCreated(GL10 gl, EGLConfig config) {
		GLES20.glClearColor(1f, 1f, 1f, 1f); // 背景色指(灰色)
		scalePos(elPosition);
		// 頂点データで頂点バッファ作成
		float[] vertices = { 0.0f, 1.0f, // 左下
				1.0f, 1.0f, // 右下
				0.0f, 0.0f, // 左上
				1.0f, 0.0f, // 右上
		};
		textureBuffer = makeFloatBuffer(vertices);
		float[] vertices2 = new float[10 * 2];
		for (int i = 0; i < vertices2.length / 4; i++) {
			vertices2[i + 0] = 0;
			vertices2[i + 0] = i / 4.0f;
			vertices2[i + 0] = 1;
			vertices2[i + 0] = i / 4.0f;
		}
		textureBuffer2 = makeFloatBuffer(vertices2);

		// テクスチャの登録(GLSurfaceViewのqueueEventのに登録する)
		view.queueEvent(new Runnable() {
			public void run() {
				vTexture = makeTexture(R.drawable.marble2a);
				lineTexture = makeTexture(R.drawable.ice);
			}
		});

		// 頂点シェーダ
		int vertexShader = GLES20.glCreateShader(GLES20.GL_VERTEX_SHADER);
		GLES20.glShaderSource(vertexShader, vertexShaderCode);
		GLES20.glCompileShader(vertexShader);

		// フラグメントシェーダ
		int fragmentShader = GLES20.glCreateShader(GLES20.GL_FRAGMENT_SHADER);
		GLES20.glShaderSource(fragmentShader, fragmentShaderCode);
		GLES20.glCompileShader(fragmentShader);
		// シェーダを登録
		program = GLES20.glCreateProgram();
		GLES20.glAttachShader(program, vertexShader);
		GLES20.glAttachShader(program, fragmentShader);
		GLES20.glLinkProgram(program);
		// 位置パラメータインデックスをとっとく
		aPositionIndex = GLES20.glGetAttribLocation(program, "a_Position");
		uvHandle = GLES20.glGetAttribLocation(program, "a_UV");
		// 射影行列初期化
		Matrix.setLookAtM(viewMatrix, 0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -5.0f,
				0.0f, 1.0f, 0.0f);
		Matrix.translateM(viewMatrix, 0, 0, 0, -5);

		// シェーダ中の各行列のindexを取得
		viewMatrixIndex = GLES20.glGetUniformLocation(program, "u_MatView");
		projMatrixIndex = GLES20.glGetUniformLocation(program, "u_MatProj");
		modelMatrixIndex = GLES20.glGetUniformLocation(program, "u_MatModel");
		//
		GLES20.glUseProgram(program); // 作ったプログラムを使う
		//
		lineBuffer = makeFloatBuffer(ballPosition);
		elPositionBuffer = makeFloatBuffer(elPosition);
		//
		
	}

	// フロートの配列からフロートバッファを返す
	private FloatBuffer makeFloatBuffer(float[] fArray) {
		FloatBuffer fb = ByteBuffer.allocateDirect(fArray.length * 4)
				.order(ByteOrder.nativeOrder()).asFloatBuffer();
		fb.put(fArray).position(0);
		return fb;
	}

	private void setFloatBuffer(FloatBuffer fb, float[] fArray) {
		fb.position(0);
		fb.put(fArray).position(0);
		return;
	}

	// リソースIDから bitmap を GL に登録して テクスチャID を返す
	private int makeTexture(int resId) {
		Resources r = resouce;// view.getResources();
		Bitmap bp;
		int textures[] = new int[1];
		bp = BitmapFactory.decodeResource(r, resId);
		GLES20.glGenTextures(1, textures, 0);
		GLES20.glBindTexture(GLES20.GL_TEXTURE_2D, textures[0]);
		GLES20.glTexParameterf(GLES20.GL_TEXTURE_2D,
				GLES20.GL_TEXTURE_MAG_FILTER, GLES20.GL_LINEAR);
		GLES20.glTexParameterf(GLES20.GL_TEXTURE_2D,
				GLES20.GL_TEXTURE_MIN_FILTER, GLES20.GL_LINEAR);
		GLUtils.texImage2D(GL10.GL_TEXTURE_2D, 0, bp, 0);
		bp.recycle();
		return textures[0];
	}
}
