package jp.ac.titech.sharp4k.cuten.sampletask;

import jp.ac.titech.sharp4k.cuten.BaseApp;
import jp.ac.titech.sharp4k.cuten.R;
import android.content.Context;
import android.content.res.Resources;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

public class ECCTask extends BaseApp {
	final private int TEXT_VIEW = 1;
	final private int IMAGE_VIEW = 1;
	final private int MATRIX_VIEW = 2;
	final private int RESET_BUTTON = 3;
	final private int NEXT_BUTTON = 4;
	private Context ctx;
	private Resources res;
	private RelativeLayout reLay;
	private MatrixView mv;
	private int cnt;
	private int[] result;

	@Override
	protected View createView(Context ctx, Resources res) {
		this.ctx = ctx;
		this.res = res;
		result = new int[res.obtainTypedArray(R.array.questions).length()];
		cnt = 0;

		// set layout
		reLay = new RelativeLayout(ctx);

		// imageview
		ImageView iv = new ImageView(ctx);
		iv.setImageDrawable(res.getDrawable(R.drawable.title));
		iv.setId(IMAGE_VIEW);
		RelativeLayout.LayoutParams ivParam = new RelativeLayout.LayoutParams(
				ViewGroup.LayoutParams.WRAP_CONTENT,
				ViewGroup.LayoutParams.WRAP_CONTENT);
		ivParam.addRule(RelativeLayout.ALIGN_PARENT_TOP, -1);
		ivParam.addRule(RelativeLayout.CENTER_HORIZONTAL, -1);
		reLay.addView(iv, ivParam);

		// button
		Button start = new Button(ctx);
		start.setText("start");
		RelativeLayout.LayoutParams startParam = new RelativeLayout.LayoutParams(
				ViewGroup.LayoutParams.WRAP_CONTENT,
				ViewGroup.LayoutParams.WRAP_CONTENT);
		startParam.addRule(RelativeLayout.BELOW, IMAGE_VIEW);
		startParam.addRule(RelativeLayout.CENTER_HORIZONTAL, -1);
		reLay.addView(start, startParam);

		start.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				nextLayout();
			}
		});

		return reLay;
	}

	void nextLayout() {
		int qNum = res.obtainTypedArray(R.array.questions).length();
		if (cnt == qNum) {
			reLay.removeAllViews();
			// textview
			TextView tv = new TextView(ctx);
			tv.setText("おわり");
			tv.setTextSize(50);
			tv.setId(TEXT_VIEW);
			RelativeLayout.LayoutParams tvParam = new RelativeLayout.LayoutParams(
					ViewGroup.LayoutParams.WRAP_CONTENT,
					ViewGroup.LayoutParams.WRAP_CONTENT);
			tvParam.addRule(RelativeLayout.ALIGN_PARENT_TOP, -1);
			tvParam.addRule(RelativeLayout.CENTER_HORIZONTAL, -1);
			reLay.addView(tv, tvParam);
			// send button
			Button b = new Button(ctx);
			b.setText("実績を送信");
			b.setOnClickListener(new OnClickListener() {
				@Override
				public void onClick(View v) {
					sendResult(result);
					close();
				}
			});
			RelativeLayout.LayoutParams bParam = new RelativeLayout.LayoutParams(
					ViewGroup.LayoutParams.WRAP_CONTENT,
					ViewGroup.LayoutParams.WRAP_CONTENT);
			bParam.addRule(RelativeLayout.BELOW, TEXT_VIEW);
			bParam.addRule(RelativeLayout.CENTER_HORIZONTAL, -1);
			reLay.addView(b, bParam);
		} else if (cnt < qNum) {
			reLay.removeAllViews();
			// textview
			TextView tv = new TextView(ctx);
			tv.setText(res.getString(R.string.text));
			tv.setTextSize(30);
			tv.setId(TEXT_VIEW);
			RelativeLayout.LayoutParams tvParam = new RelativeLayout.LayoutParams(
					ViewGroup.LayoutParams.WRAP_CONTENT,
					ViewGroup.LayoutParams.WRAP_CONTENT);
			tvParam.addRule(RelativeLayout.ALIGN_PARENT_TOP, -1);
			tvParam.addRule(RelativeLayout.ALIGN_PARENT_LEFT, -1);
			reLay.addView(tv, tvParam);
			// reset button
			Button reset = new Button(ctx);
			reset.setText("reset");
			reset.setId(RESET_BUTTON);
			RelativeLayout.LayoutParams resetParam = new RelativeLayout.LayoutParams(
					ViewGroup.LayoutParams.WRAP_CONTENT,
					ViewGroup.LayoutParams.WRAP_CONTENT);
			resetParam.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM, -1);
			resetParam.addRule(RelativeLayout.ALIGN_PARENT_LEFT, -1);
			reLay.addView(reset, resetParam);
			// next button
			Button next = new Button(ctx);
			next.setText("next");
			next.setId(NEXT_BUTTON);
			RelativeLayout.LayoutParams nextParam = new RelativeLayout.LayoutParams(
					ViewGroup.LayoutParams.WRAP_CONTENT,
					ViewGroup.LayoutParams.WRAP_CONTENT);
			nextParam.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM, -1);
			nextParam.addRule(RelativeLayout.ALIGN_PARENT_RIGHT, -1);
			reLay.addView(next, nextParam);
			// Matrix View
			mv = new MatrixView(ctx, res, res.obtainTypedArray(
					R.array.questions).getResourceId(cnt, -1));
			mv.setId(MATRIX_VIEW);
			RelativeLayout.LayoutParams mvParam = new RelativeLayout.LayoutParams(
					ViewGroup.LayoutParams.FILL_PARENT,
					ViewGroup.LayoutParams.FILL_PARENT);
			mvParam.addRule(RelativeLayout.BELOW, TEXT_VIEW);
			mvParam.addRule(RelativeLayout.ABOVE, RESET_BUTTON);
			reLay.addView(mv, mvParam);

			reset.setOnClickListener(new OnClickListener() {
				@Override
				public void onClick(View v) {
					mv.reset();
				}
			});
			next.setOnClickListener(new OnClickListener() {
				@Override
				public void onClick(View v) {
					result[cnt] = mv.mark();
					cnt += 1;
					nextLayout();
				}
			});
		}

	}
}
