class BootstrapFormBuilder < ActionView::Helpers::FormBuilder
  def control_group(method, options = {}, &blk)
    errors = object.errors
    options[:class] ||= []
    if not options[:class].is_a? Array
      options[:class] = [options[:class]]
    end
    options[:class] << 'control-group'
    if not errors[method].empty?
      options[:class] << 'error'
    end
    builder = ControlGroupBuilder.new object_name, object, @template, method
    @template.content_tag(:div, options) do
      blk.call builder
    end
  end

  class ControlGroupBuilder
    def initialize(object_name, object, template, method)
      @object_name = object_name
      @object = object
      @template = template
      @method = method
    end

    def label
      @template.label @object_name, @method
    end

    def controls(options = {}, &blk)
      builder = ControlsBuilder.new @object_name, @object, @template, @method
      options[:class] ||= []
      if not options[:class].is_a? Array
        options[:class] = [options[:class]]
      end
      options[:class] << 'controls'
      @template.content_tag(:div, options) do
        blk.call builder
      end
    end
  end

  class ControlsBuilder
    def initialize(object_name, object, template, method)
      @object_name = object_name
      @object = object
      @template = template
      @method = method
    end

    [
      :email_field,
      :file_field,
      :password_field,
      :text_field,
    ].each do |sym|
      define_method sym do |options = {}|
        form sym, options
      end
    end

    def select(choices, options = {})
      form :select, choices, options
    end

    private

    def form(field_type, *args)
      buf = @template.send field_type, @object_name, @method, *args
      @object.errors[@method].each do |msg|
        full_msg = @object.errors.full_message(@method, msg)
        buf.concat @template.content_tag(:span, full_msg, :class => 'help-inline')
      end
      buf
    end
  end
end
