class User < ActiveRecord::Base
  # Include default devise modules. Others available are:
  # :token_authenticatable, :confirmable,
  # :lockable, :timeoutable and :omniauthable
  devise :database_authenticatable, :registerable,
         :recoverable, :rememberable, :trackable, :validatable

  devise :token_authenticatable
  before_save :ensure_authentication_token

  # Setup accessible (or protected) attributes for your model
  attr_accessible :email, :password, :password_confirmation, :remember_me
  attr_accessible :student_number
  # attr_accessible :title, :body

  has_many :achievements
  belongs_to :teacher
  attr_accessible :teacher_id

  validates_format_of :student_number, :with => /\A[0-9A-Z]+\z/

  include JsonWithoutTimestamps
end
