package jp.ac.titech.sharp4k.cuten.test;

import jp.ac.titech.sharp4k.cuten.Token;
import roboguice.RoboGuice;
import roboguice.activity.RoboActivity;

import com.google.inject.Module;
import com.google.inject.util.Modules;

import android.app.Application;
import android.content.Context;
import android.test.ActivityInstrumentationTestCase2;
import android.view.View;

public abstract class ActivityTestCaseWithRobo<T extends RoboActivity> extends
		ActivityInstrumentationTestCase2<T> {
	private Module[] modules;
	private String savedToken;
	protected static String dummyToken = "dummytoken";

	public ActivityTestCaseWithRobo(Class<T> klass, Module... ms) {
		super(klass);
		modules = new Module[ms.length + 2];
		System.arraycopy(ms, 0, modules, 0, ms.length);
		modules[ms.length] = new DummyDBModule();
		modules[ms.length + 1] = new StaticInjectionModule();
	}

	@Override
	protected void setUp() throws Exception {
		super.setUp();
		Context ctx = getInstrumentation().getTargetContext();
		Application app = (Application) ctx.getApplicationContext();
		Module m = Modules.override(RoboGuice.newDefaultRoboModule(app)).with(
				modules);
		RoboGuice.setBaseApplicationInjector(app, RoboGuice.DEFAULT_STAGE, m);
		savedToken = Token.load(ctx);
		Token.save(dummyToken, ctx);
	}

	@Override
	protected void tearDown() throws Exception {
		T activity = getActivity();
		Token.delete(activity);
		if (savedToken != null) {
			Token.save(savedToken, activity);
		}
		activity.deleteDatabase(DummyDBModule.DB_NAME);
		RoboGuice.util.reset();
		super.tearDown();
	}

	protected void waitUI() {
		getInstrumentation().waitForIdleSync();
	}

	protected void click(final View v) {
		getActivity().runOnUiThread(new Runnable() {
			@Override
			public void run() {
				v.performClick();
			}
		});
		waitUI();
	}
}