package jp.ac.titech.sharp4k.cuten;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

import java.nio.channels.FileChannel;

import java.util.Date;

import android.app.Activity;

import android.content.Context;
import android.content.Intent;

import android.os.Bundle;
import android.os.Environment;

import android.util.Log;

import android.view.View;

import android.view.View.OnClickListener;

import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.Toast;

import dalvik.system.DexClassLoader;

public class TaskActivity extends Activity {
	private static final String TAG = "TaskActivity";

	public static final String TASK_NAME_KEY = "taskName";
	public static final String JAR_NAME_KEY = "jarName";
	public static final String QUAL_NAME_KEY = "qualName";
	public static final String RESULT_KEY = "result";

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		Intent me = getIntent();
		String taskName = me.getStringExtra(TASK_NAME_KEY);
		String jarName = me.getStringExtra(JAR_NAME_KEY);
		String qualName = me.getStringExtra(QUAL_NAME_KEY);

		if (taskName == null || jarName == null || qualName == null) {
			Log.e(TAG, "Invalid extras!");
			finish();
		}
		Log.d(TAG, "Try to launch " + jarName + ":" + qualName);
		try {
			DexClassLoader cl = loadDex(new File(
					Environment.getExternalStorageDirectory(), jarName));
			Class<?> klass = cl.loadClass(qualName);
			Log.d(TAG, "Successfully loaded " + qualName);
			Constructor<?> ctor = klass.getConstructor();
			Object task = ctor.newInstance();
			Method meth = klass.getMethod("createView", Context.class);
			View view = (View) meth.invoke(task, this);
			Log.d(TAG, "Successfully created view of " + qualName);

			setupLayout(view);
			setResponse(-1);
		} catch (Exception ex) {
			ex.printStackTrace();
			Log.e(TAG, "Failed to launch " + jarName + ":" + qualName);
			Toast.makeText(this, taskName + "を起動できなかった＞＜", Toast.LENGTH_SHORT)
					.show();
			setResult(RESULT_CANCELED);
			finish();
		}
	}

	private void setResponse(int result) {
		Intent intent = new Intent();
		intent.putExtra(RESULT_KEY, result);
		setResult(RESULT_OK, intent);
	}

	private void setupLayout(View taskView) {
		setContentView(R.layout.task);

		LinearLayout layout = (LinearLayout) findViewById(R.id.task_root_layout);
		layout.addView(taskView);

		Button b = (Button) findViewById(R.id.task_close_button);
		b.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				setResponse(new Date().getSeconds());
				finish();
			}
		});
	}

	private DexClassLoader loadDex(File dexFile) throws IOException {
		File copied = new File(getDir("dex", Context.MODE_PRIVATE),
				dexFile.getName());
		copyFile(dexFile, copied);
		File odexDir = getDir("odex", Context.MODE_PRIVATE);
		return new DexClassLoader(copied.getAbsolutePath(),
				odexDir.getAbsolutePath(), null, getClassLoader());
	}

	private static void copyFile(File src, File dst) throws IOException {
		FileChannel in = new FileInputStream(src).getChannel();
		FileChannel out = new FileOutputStream(dst).getChannel();
		in.transferTo(0, in.size(), out);
	}
}
