package jp.ac.titech.sharp4k.cuten;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import android.content.ContentValues;

import android.database.Cursor;

import android.database.sqlite.SQLiteDatabase;

public class Lecture implements Serializable, PandaAdapter.Child {
	/**
	 * 
	 */
	private static final long serialVersionUID = -755691162493385388L;
	private int id;
	private String name;
	private Teacher teacher;
	private List<Integer> taskIds;

	public Lecture(int id, String name, Teacher teacher, List<Integer> taskIds) {
		this.id = id;
		this.name = name;
		this.teacher = teacher;
		this.taskIds = taskIds;
	}

	public int getId() {
		return id;
	}

	public String getName() {
		return name;
	}

	public Teacher getTeacher() {
		return teacher;
	}

	public List<Integer> getTaskIds() {
		return taskIds;
	}

	@Override
	public String getTitle() {
		return getName();
	}

	@Override
	public String getSummary() {
		return getTeacher().getName();
  }

	public static List<Lecture> findSelected(SQLiteDatabase db) {
		Cursor c = db
				.rawQuery(
						"SELECT lectures.id,lectures.name,teachers.id,teachers.name FROM selected_lectures,lectures,teachers WHERE lectures.id=selected_lectures.id AND lectures.teacher_id=teachers.id",
						new String[] {});
		List<Lecture> lectures = new ArrayList<Lecture>();
		while (c.moveToNext()) {
			lectures.add(fromCursor(db, c));
		}
		return lectures;
	}

	public static Lecture find(SQLiteDatabase db, int id) {
		Cursor c = db
				.rawQuery(
						"SELECT lectures.id,lectures.name,teachers.id,teachers.name FROM lectures,teachers WHERE lectures.id=? AND lectures.teacher_id=teachers.id",
						new String[] { String.valueOf(id) });
		if (c.moveToFirst()) {
			Lecture lecture = fromCursor(db, c);
			c.close();
			return lecture;
		} else {
			// not found
			c.close();
			return null;
		}
	}

	private static Lecture fromCursor(SQLiteDatabase db, Cursor c) {
		int lectureId = c.getInt(0);
		String lectureName = c.getString(1);
		int teacherId = c.getInt(2);
		String teacherName = c.getString(3);
		Teacher t = new Teacher(teacherId, teacherName);
		List<Integer> taskIds = new ArrayList<Integer>();

		Cursor d = db.rawQuery(
				"SELECT tasks.id FROM tasks WHERE tasks.lecture_id = ?",
				new String[] { String.valueOf(lectureId) });
		while (d.moveToNext()) {
			taskIds.add(d.getInt(0));
		}
		d.close();
		return new Lecture(lectureId, lectureName, t, taskIds);
	}

	public List<Task> findTasks(SQLiteDatabase db) {
		Cursor c = db
				.rawQuery(
						"SELECT tasks.id,tasks.name FROM tasks,lectures WHERE tasks.lecture_id=? AND tasks.lecture_id=lectures.id",
						new String[] { String.valueOf(id) });
		List<Task> tasks = new ArrayList<Task>();
		while (c.moveToNext()) {
			int taskId = c.getInt(0);
			String taskName = c.getString(1);
			tasks.add(new Task(taskId, taskName));
		}
		c.close();
		return tasks;
	}

	public long save(SQLiteDatabase db) {
		ContentValues row = new ContentValues();
		row.put("id", getId());
		row.put("name", getName());
		row.put("teacher_id", getTeacher().getId());
		return db.insert("lectures", null, row);
	}

	public long saveToSelected(SQLiteDatabase db) {
		ContentValues row = new ContentValues();
		row.put("id", getId());
		return db.insert("selected_lectures", null, row);
	}

	public int deleteFromSelected(SQLiteDatabase db) {
		return db.delete("selected_lectures", "id = ?",
				new String[] { String.valueOf(getId()) });
	}
}
