require 'test_helper'

class AchievementTest < ActiveSupport::TestCase
  test 'should merge results' do
    a = [1, 4, 7]
    b = [2, 0, 10]
    expected = [2, 4, 10]
    assert_equal expected, Achievement.merge(a, b)
    assert_equal expected, Achievement.merge(b, a)
  end

  test 'should fail to merge results of different lengths' do
    a = [1, 4, 7]
    b = [2, 0]
    assert_raises(Achievement::MergeError) { Achievement.merge(a, b) }
    assert_raises(Achievement::MergeError) { Achievement.merge(b, a) }
  end

  test 'should merge nil result' do
    a = [1, 4, 7]
    b = nil
    expected = a
    assert_equal expected, Achievement.merge(a, b)
    assert_equal expected, Achievement.merge(b, a)
  end

  test 'should accept' do
    a = Achievement.new :result => '0, 100, 50'
    assert a.save
  end

  test 'should reject out-of-range element' do
    a = Achievement.new :result => '0, 101, 100'
    assert !a.save
    assert a.errors.has_key?(:result)
    assert a.errors[:result].any? { |error| error =~ /out-of-range/ }
  end

  test 'should reject nil result' do
    a = Achievement.new
    assert !a.save
  end
end
