require 'rubygems'
require 'spork'
#uncomment the following line to use spork with the debugger
#require 'spork/ext/ruby-debug'

Spork.prefork do
  # Loading more in this block will cause your tests to run faster. However,
  # if you change any configuration or code from libraries loaded here, you'll
  # need to restart spork for it take effect.

  # https://github.com/colszowka/simplecov/issues/42#issuecomment-4440284
  unless ENV['DRB']
    require 'simplecov'
    SimpleCov.start 'rails'
  end

  ENV["RAILS_ENV"] = "test"
  require File.expand_path('../../config/environment', __FILE__)
  require 'rails/test_help'

  class ActiveSupport::TestCase
    include FactoryGirl::Syntax::Methods

    # Add more helper methods to be used by all tests here...

    def assert_no_routes(&blk)
      assert_raise ActionController::RoutingError, &blk
    end

    def assert_match_any(reg, coll, msg = nil)
      assert_respond_to coll, :any?, 'The collection must respond to :any?'
      msg ||= "Some of <#{coll.pretty_inspect.chomp}> is expected to match <#{reg.pretty_inspect.chomp}>"
      assert coll.any? { |x| x =~ reg }, msg
    end

    teardown do
      FileUtils.rm_rf Apk.directory
    end
  end

  class Rack::Test::UploadedFile
    # monkey patch for this issue: https://github.com/brynary/rack-test/issues/30
    attr_reader :tempfile
  end
end

Spork.each_run do
  # This code will be run each time you run your specs.
  unless ENV['DRB']
    require 'simplecov'
    SimpleCov.start 'rails'
  end

  Dir[Rails.root.join('app/models/*.rb')].each do |file|
    load file
  end

  FactoryGirl.reload
end

# --- Instructions ---
# Sort the contents of this file into a Spork.prefork and a Spork.each_run
# block.
#
# The Spork.prefork block is run only once when the spork server is started.
# You typically want to place most of your (slow) initializer code in here, in
# particular, require'ing any 3rd-party gems that you don't normally modify
# during development.
#
# The Spork.each_run block is run each time you run your specs.  In case you
# need to load files that tend to change during development, require them here.
# With Rails, your application modules are loaded automatically, so sometimes
# this block can remain empty.
#
# Note: You can modify files loaded *from* the Spork.each_run block without
# restarting the spork server.  However, this file itself will not be reloaded,
# so if you change any of the code inside the each_run block, you still need to
# restart the server.  In general, if you have non-trivial code in this file,
# it's advisable to move it into a separate file so you can easily edit it
# without restarting spork.  (For example, with RSpec, you could move
# non-trivial code into a file spec/support/my_helper.rb, making sure that the
# spec/support/* files are require'd from inside the each_run block.)
#
# Any code that is left outside the two blocks will be run during preforking
# *and* during each_run -- that's probably not what you want.
#
# These instructions should self-destruct in 10 seconds.  If they don't, feel
# free to delete them.
