require 'test_helper'

class AchievementsControllerTeacherTest < ActionController::TestCase
  tests AchievementsController

  include Devise::TestHelpers

  setup do
    @achievement = FactoryGirl.create :achievement
    @lecture = @achievement.task.lecture
    @teacher = @lecture.teacher

    @alt_achievement = FactoryGirl.create :achievement
    @alt_lecture = @alt_achievement.task.lecture
  end

  test "teacher can list his lecture's achievements" do
    sign_in @teacher

    get :index
    assert_response :success
    got = assigns :achievements
    assert_not_nil got
    got.each do |a|
      assert_equal @teacher, a.task.lecture.teacher
    end
  end

  test "teacher can see his lecture's achievement" do
    sign_in @teacher

    get :show, :id => @achievement.id
    assert_response :success
    assert_not_nil assigns(:achievement)
  end

  test "teacher cannot see other teacher's achievement" do
    sign_in @teacher

    get :show, :id => @alt_achievement.id
    assert_response 302

    get :show, :format => :json, :id => @alt_achievement.id
    assert_response 401
  end
end
