# http://unicorn.bogomips.org/examples/unicorn.conf.rb
worker_processes 2

listen '127.0.0.1:3010'
pid 'log/unicorn.pid'

preload_app true

stdout_path 'log/unicorn-stdout.log'
stderr_path 'log/unicorn-stderr.log'

before_fork do |server, worker|
  if defined? ActiveRecord::Base
    ActiveRecord::Base.connection.disconnect!
  end

  old_pid = "#{server.config[:pid]}.oldbin"
  if old_pid != server.pid
    begin
      sig = (worker.nr + 1) >= server.worker_processes ? :QUIT : :TTOU
      Process.kill sig, File.read(old_pid).to_i
    rescue Errno::ENOENT, Errno::ESRCH
    end
  end

  sleep 1
end

after_fork do |server, worker|
  if defined? ActiveRecord::Base
    ActiveRecord::Base.establish_connection
  end
end
